/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseBuilder;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.multistep.CLIMultiStepHelper;
import org.apache.geode.management.internal.cli.multistep.MultiStepCommand;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JMXInvocationException;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GfshExecutionStrategy
implements ExecutionStrategy {
    private Class<?> mutex = GfshExecutionStrategy.class;
    private Gfsh shell;
    private LogWrapper logWrapper;

    GfshExecutionStrategy(Gfsh shell) {
        this.shell = shell;
        this.logWrapper = LogWrapper.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ParseResult parseResult) {
        Result result = null;
        Method method = parseResult.getMethod();
        try {
            MultiStepCommand cmd = method.getAnnotation(MultiStepCommand.class);
            if (cmd != null) {
                return CLIMultiStepHelper.execCLISteps(this.logWrapper, this.shell, parseResult);
            }
            if (this.isShellOnly(method)) {
                Assert.notNull((Object)parseResult, (String)"Parse result required");
                Class<?> clazz = this.mutex;
                synchronized (clazz) {
                    Assert.isTrue((boolean)this.isReadyForCommands(), (String)"ProcessManagerHostedExecutionStrategy not yet ready for commands");
                    return ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)parseResult.getInstance(), (Object[])parseResult.getArguments());
                }
            }
            if (!GfshParseResult.class.isInstance(parseResult)) {
                throw new IllegalStateException("Configuration error!");
            }
            result = this.executeOnRemote((GfshParseResult)parseResult);
        }
        catch (NotAuthorizedException e) {
            result = ResultBuilder.createGemFireUnAuthorizedErrorResult("Unauthorized. Reason: " + e.getMessage());
        }
        catch (IllegalStateException | JMXInvocationException e) {
            Gfsh.getCurrentInstance().logWarning(e.getMessage(), e);
        }
        catch (CommandProcessingException e) {
            Gfsh.getCurrentInstance().logWarning(e.getMessage(), null);
            Object errorData = e.getErrorData();
            if (errorData != null && errorData instanceof Throwable) {
                this.logWrapper.warning(e.getMessage(), (Throwable)errorData);
            } else {
                this.logWrapper.warning(e.getMessage());
            }
        }
        catch (Exception e) {
            Gfsh.getCurrentInstance().logWarning("Unexpected exception occurred. " + e.getMessage(), e);
            this.logWrapper.warning("Unexpected error occurred while executing command : " + ((GfshParseResult)parseResult).getUserInput(), e);
        }
        return result;
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public boolean isReadyForCommands() {
        return true;
    }

    public void terminate() {
        this.shell = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeOnRemote(GfshParseResult parseResult) {
        Result postExecResult;
        Result commandResult = null;
        Object response = null;
        if (!this.shell.isConnectedAndReady()) {
            this.shell.logWarning("Can't execute a remote command without connection. Use 'connect' first to connect.", null);
            this.logWrapper.info("Can't execute a remote command \"" + parseResult.getUserInput() + "\" without connection. Use 'connect' first to connect to GemFire.");
            return null;
        }
        byte[][] fileData = null;
        CliAroundInterceptor interceptor = null;
        String interceptorClass = this.getInterceptor(parseResult.getMethod());
        if (!"__NULL__".equals(interceptorClass)) {
            try {
                interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.shell.logWarning("Configuration error", e);
            }
            if (interceptor != null) {
                Result preExecResult = interceptor.preExecution(parseResult);
                if (Result.Status.ERROR.equals((Object)preExecResult.getStatus())) {
                    return preExecResult;
                }
                if (preExecResult instanceof FileResult) {
                    FileResult fileResult = (FileResult)preExecResult;
                    fileData = fileResult.toBytes();
                }
            } else {
                return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
            }
        }
        Map<String, String> env = this.shell.getEnv();
        try {
            response = this.shell.getOperationInvoker().processCommand(new CommandRequest(parseResult, env, fileData));
        }
        catch (NotAuthorizedException e) {
            Result result = ResultBuilder.createGemFireUnAuthorizedErrorResult("Unauthorized. Reason : " + e.getMessage());
            return result;
        }
        catch (Exception e) {
            this.shell.logSevere(e.getMessage(), e);
        }
        finally {
            env.clear();
        }
        if (response == null) {
            this.shell.logWarning("Response was null for: \"" + parseResult.getUserInput() + "\". (gfsh.isConnected=" + this.shell.isConnectedAndReady() + ")", null);
            return ResultBuilder.createBadResponseErrorResult(" Error occurred while executing \"" + parseResult.getUserInput() + "\" on manager. Please check manager logs for error.");
        }
        if (response instanceof String) {
            String debugInfo;
            CommandResponse commandResponse = CommandResponseBuilder.prepareCommandResponseFromJson((String)response);
            if (commandResponse.isFailedToPersist()) {
                this.shell.printAsSevere("Failed to persist the configuration changes due to this command, Revert the command to maintain consistency.\nPlease use \"status cluster-config-service\" to determine whether Cluster configuration service is RUNNING.");
                this.logWrapper.severe("Failed to persist the configuration changes due to this command, Revert the command to maintain consistency.\nPlease use \"status cluster-config-service\" to determine whether Cluster configuration service is RUNNING.");
            }
            if (StringUtils.isNotBlank((String)(debugInfo = commandResponse.getDebugInfo()))) {
                debugInfo = debugInfo.replaceAll("\n\n\n", "\n");
                debugInfo = debugInfo.replaceAll("\n\n", "\n");
                debugInfo = debugInfo.replaceAll("\n", "\n[From Manager : " + commandResponse.getSender() + "]");
                debugInfo = "[From Manager : " + commandResponse.getSender() + "]" + debugInfo;
                LogWrapper.getInstance().info(debugInfo);
            }
            commandResult = ResultBuilder.fromJson((String)response);
        }
        Path tempFile = null;
        if (response instanceof Path) {
            tempFile = (Path)response;
        }
        if (interceptor != null && (postExecResult = interceptor.postExecution(parseResult, commandResult, tempFile)) != null) {
            if (Result.Status.ERROR.equals((Object)postExecResult.getStatus())) {
                if (this.logWrapper.infoEnabled()) {
                    this.logWrapper.info("Post execution Result :: " + postExecResult);
                }
            } else if (this.logWrapper.fineEnabled()) {
                this.logWrapper.fine("Post execution Result :: " + postExecResult);
            }
            commandResult = postExecResult;
        }
        return commandResult;
    }
}

