/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jline.Terminal;
import jline.console.ConsoleReader;
import jline.console.history.History;
import org.apache.geode.internal.Banner;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.ClassUtils;
import org.apache.geode.internal.process.signal.AbstractSignalNotificationHandler;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.HostName;
import org.apache.geode.internal.util.SunAPINotFoundException;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.geode.management.internal.cli.shell.GfshExecutionStrategy;
import org.apache.geode.management.internal.cli.shell.MultiCommandHelper;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.shell.ScriptExecutionDetails;
import org.apache.geode.management.internal.cli.shell.jline.ANSIHandler;
import org.apache.geode.management.internal.cli.shell.jline.GfshHistory;
import org.apache.geode.management.internal.cli.shell.jline.GfshUnsupportedTerminal;
import org.apache.geode.management.internal.cli.shell.unsafe.GfshSignalHandler;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.JLineShell;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ShellStatus;

public class Gfsh
extends JLineShell {
    public static final int DEFAULT_APP_FETCH_SIZE = 100;
    public static final int DEFAULT_APP_LAST_EXIT_STATUS = 0;
    public static final int DEFAULT_APP_COLLECTION_LIMIT = 20;
    public static final boolean DEFAULT_APP_QUIET_EXECUTION = false;
    public static final String DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE = "table";
    public static final String DEFAULT_APP_RESULT_VIEWER = "basic";
    public static final String EXTERNAL_RESULT_VIEWER = "external";
    public static final String GFSH_APP_NAME = "gfsh";
    public static final String LINE_INDENT = "    ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int DEFAULT_WIDTH = 100;
    public static final String ENV_APP_NAME = "APP_NAME";
    public static final String ENV_APP_CONTEXT_PATH = "APP_CONTEXT_PATH";
    public static final String ENV_APP_FETCH_SIZE = "APP_FETCH_SIZE";
    public static final String ENV_APP_LAST_EXIT_STATUS = "APP_LAST_EXIT_STATUS";
    public static final String ENV_APP_COLLECTION_LIMIT = "APP_COLLECTION_LIMIT";
    public static final String ENV_APP_QUERY_RESULTS_DISPLAY_MODE = "APP_QUERY_RESULTS_DISPLAY_MODE";
    public static final String ENV_APP_QUIET_EXECUTION = "APP_QUIET_EXECUTION";
    public static final String ENV_APP_LOGGING_ENABLED = "APP_LOGGING_ENABLED";
    public static final String ENV_APP_LOG_FILE = "APP_LOG_FILE";
    public static final String ENV_APP_PWD = "APP_PWD";
    public static final String ENV_APP_RESULT_VIEWER = "APP_RESULT_VIEWER";
    public static final String ENV_SYS_USER = "SYS_USER";
    public static final String ENV_SYS_USER_HOME = "SYS_USER_HOME";
    public static final String ENV_SYS_HOST_NAME = "SYS_HOST_NAME";
    public static final String ENV_SYS_CLASSPATH = "SYS_CLASSPATH";
    public static final String ENV_SYS_JAVA_VERSION = "SYS_JAVA_VERSION";
    public static final String ENV_SYS_OS = "SYS_OS";
    public static final String ENV_SYS_OS_LINE_SEPARATOR = "SYS_OS_LINE_SEPARATOR";
    public static final String ENV_SYS_GEODE_HOME_DIR = "SYS_GEODE_HOME_DIR";
    public static final String SSL_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String SSL_ENABLED_CIPHERS = "javax.rmi.ssl.client.enabledCipherSuites";
    public static final String SSL_ENABLED_PROTOCOLS = "javax.rmi.ssl.client.enabledProtocols";
    private static final String DEFAULT_SECONDARY_PROMPT = ">";
    private static final int DEFAULT_HEIGHT = 100;
    private static final Object INSTANCE_LOCK = new Object();
    public static boolean SUPPORT_MUTLIPLESHELL = false;
    protected static PrintStream gfshout = System.out;
    protected static PrintStream gfsherr = System.err;
    protected static ThreadLocal<Gfsh> gfshThreadLocal = new ThreadLocal();
    private static Gfsh instance;
    private static ThreadLocal<Boolean> resultTypeTL;
    private static String OS;
    private final Map<String, String> env = new TreeMap<String, String>();
    private final List<String> readonlyAppEnv = new ArrayList<String>();
    private final Map<String, String> expandedPropCommandsMap = new HashMap<String, String>();
    private final ExecutionStrategy executionStrategy;
    private final GfshParser parser;
    private final LogWrapper gfshFileLogger;
    private final GfshConfig gfshConfig;
    private final GfshHistory gfshHistory;
    private final ANSIHandler ansiHandler;
    private final boolean isHeadlessMode;
    private OperationInvoker operationInvoker;
    private int lastExecutionStatus;
    private Thread runner;
    private boolean debugON;
    private Terminal terminal;
    private boolean supressScriptCmdOutput;
    private boolean isScriptRunning;
    private AbstractSignalNotificationHandler signalHandler;

    protected Gfsh() throws ClassNotFoundException, IOException {
        this(null);
    }

    protected Gfsh(String[] args) throws ClassNotFoundException, IOException {
        this(true, args, new GfshConfig());
    }

    protected Gfsh(boolean launchShell, String[] args, GfshConfig gfshConfig) throws ClassNotFoundException, IOException {
        JLineLogHandler.setSuppressDuplicateMessages((boolean)false);
        this.gfshConfig = gfshConfig;
        this.gfshFileLogger = LogWrapper.getInstance();
        this.gfshFileLogger.configure(this.gfshConfig);
        this.ansiHandler = ANSIHandler.getInstance(this.gfshConfig.isANSISupported());
        this.gfshFileLogger.info(Banner.getString(args));
        this.gfshHistory = new GfshHistory();
        this.initializeEnvironment();
        this.executionStrategy = new GfshExecutionStrategy(this);
        this.parser = new GfshParser();
        this.setHistorySize(gfshConfig.getHistorySize());
        String envProps = this.env.toString();
        envProps = envProps.substring(1, envProps.length() - 1);
        envProps = envProps.replaceAll(",", LINE_SEPARATOR);
        this.gfshFileLogger.config("***** gfsh Environment ******" + LINE_SEPARATOR + envProps);
        if (this.gfshFileLogger.fineEnabled()) {
            String gfshConfigStr = this.gfshConfig.toString();
            gfshConfigStr = gfshConfigStr.substring(0, gfshConfigStr.length() - 1);
            gfshConfigStr = gfshConfigStr.replaceAll(",", LINE_SEPARATOR);
            this.gfshFileLogger.fine("***** gfsh Configuration ******" + LINE_SEPARATOR + gfshConfigStr);
        }
        try {
            ClassUtils.forName("sun.misc.Signal", new SunAPINotFoundException("WARNING!!! Not running a Sun JVM.  Could not find the sun.misc.Signal class; Signal handling disabled."));
            this.signalHandler = CliUtil.isGfshVM() ? new GfshSignalHandler() : new AbstractSignalNotificationHandler(){};
        }
        catch (SunAPINotFoundException e) {
            this.signalHandler = new AbstractSignalNotificationHandler(){};
            this.gfshFileLogger.warning(e.getMessage());
        }
        if (this.gfshConfig.isTestConfig()) {
            instance = this;
        }
        boolean bl = this.isHeadlessMode = !launchShell;
        if (this.isHeadlessMode) {
            this.gfshFileLogger.config("Running in headless mode");
            System.setProperty("jline.terminal", GfshUnsupportedTerminal.class.getName());
            this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(true));
            Gfsh.redirectInternalJavaLoggers();
            LogWrapper.getInstance().setParentFor(this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gfsh getInstance(boolean launchShell, String[] args, GfshConfig gfshConfig) throws ClassNotFoundException, IOException {
        if (instance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new Gfsh(launchShell, args, gfshConfig);
                    instance.executeInitFileIfPresent();
                }
            }
        }
        return instance;
    }

    public static boolean isInfoResult() {
        if (resultTypeTL.get() == null) {
            return false;
        }
        return resultTypeTL.get();
    }

    public static void println() {
        gfshout.println();
    }

    public static <T> void println(T toPrint) {
        gfshout.println(toPrint);
    }

    public static <T> void print(T toPrint) {
        gfshout.print(toPrint);
    }

    public static <T> void printlnErr(T toPrint) {
        gfsherr.println(toPrint);
    }

    private static String readLine(ConsoleReader reader, String prompt) throws IOException {
        String earlierLine = reader.getCursorBuffer().toString();
        String readLine = null;
        try {
            readLine = reader.readLine(prompt);
        }
        catch (IndexOutOfBoundsException e) {
            if (earlierLine.length() == 0) {
                reader.println();
                readLine = LINE_SEPARATOR;
                reader.getCursorBuffer().cursor = 0;
            }
            readLine = Gfsh.readLine(reader, prompt);
        }
        return readLine;
    }

    private static String removeBackslash(String result) {
        if (result.endsWith("\\")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void redirectInternalJavaLoggers() {
        LogManager logManager = LogManager.getLogManager();
        try {
            Enumeration<String> loggerNames = logManager.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                Logger javaLogger;
                String loggerName = loggerNames.nextElement();
                if (!loggerName.startsWith("java.") && !loggerName.startsWith("javax.") || (javaLogger = logManager.getLogger(loggerName)) == null) continue;
                LogWrapper.getInstance().setParentFor(javaLogger);
            }
        }
        catch (SecurityException e) {
            LogWrapper.getInstance().warning(e.getMessage(), e);
        }
    }

    public static Gfsh getCurrentInstance() {
        if (!SUPPORT_MUTLIPLESHELL) {
            return instance;
        }
        return gfshThreadLocal.get();
    }

    private static String extractKey(String input) {
        return input.substring("${".length(), input.length() - "}".length());
    }

    public static ConsoleReader getConsoleReader() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh == null ? null : gfsh.reader;
    }

    public static String wrapText(String string, int indentationLevel, int terminalWidth) {
        if (terminalWidth <= 1) {
            return string;
        }
        int maxLineLength = terminalWidth - 1;
        StringBuffer stringBuf = new StringBuffer();
        int index = 0;
        int startOfCurrentLine = 0;
        while (index < string.length()) {
            for (int i = 0; i < indentationLevel; ++i) {
                stringBuf.append(LINE_INDENT);
            }
            for (int currentLineLength = LINE_INDENT.length() * indentationLevel; index < string.length() && currentLineLength < maxLineLength && string.charAt(index) != '\n'; ++index, ++currentLineLength) {
            }
            if (index != string.length() && string.charAt(index) == '\n') {
                stringBuf.append(string.substring(startOfCurrentLine, index));
                stringBuf.append(LINE_SEPARATOR);
                startOfCurrentLine = ++index;
            } else if (index == string.length() || string.charAt(index) == ' ') {
                stringBuf.append(string.substring(startOfCurrentLine, index));
                if (index != string.length()) {
                    stringBuf.append(LINE_SEPARATOR);
                }
            } else {
                int spaceCharIndex = string.lastIndexOf(" ", index);
                if (spaceCharIndex == -1) {
                    stringBuf.append(string.substring(startOfCurrentLine, index)).append(LINE_SEPARATOR);
                } else {
                    stringBuf.append(string.substring(startOfCurrentLine, spaceCharIndex)).append(LINE_SEPARATOR);
                    index = spaceCharIndex + 1;
                }
            }
            startOfCurrentLine = ++index;
        }
        return stringBuf.toString();
    }

    private void initializeEnvironment() {
        this.env.put(ENV_SYS_USER, System.getProperty("user.name"));
        this.env.put(ENV_SYS_USER_HOME, System.getProperty("user.home"));
        this.env.put(ENV_SYS_HOST_NAME, new HostName().determineHostName());
        this.env.put(ENV_SYS_CLASSPATH, System.getProperty("java.class.path"));
        this.env.put(ENV_SYS_JAVA_VERSION, System.getProperty("java.version"));
        this.env.put(ENV_SYS_OS, System.getProperty("os.name"));
        this.env.put(ENV_SYS_OS_LINE_SEPARATOR, System.getProperty("line.separator"));
        this.env.put(ENV_SYS_GEODE_HOME_DIR, System.getenv("GEODE_HOME"));
        this.env.put(ENV_APP_NAME, GFSH_APP_NAME);
        this.readonlyAppEnv.add(ENV_APP_NAME);
        this.env.put(ENV_APP_LOGGING_ENABLED, String.valueOf(!Level.OFF.equals(this.gfshConfig.getLogLevel())));
        this.readonlyAppEnv.add(ENV_APP_LOGGING_ENABLED);
        this.env.put(ENV_APP_LOG_FILE, this.gfshConfig.getLogFilePath());
        this.readonlyAppEnv.add(ENV_APP_LOG_FILE);
        this.env.put(ENV_APP_PWD, System.getProperty("user.dir"));
        this.readonlyAppEnv.add(ENV_APP_PWD);
        this.env.put(ENV_APP_FETCH_SIZE, String.valueOf(100));
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(0));
        this.readonlyAppEnv.add(ENV_APP_LAST_EXIT_STATUS);
        this.env.put(ENV_APP_COLLECTION_LIMIT, String.valueOf(20));
        this.env.put(ENV_APP_QUERY_RESULTS_DISPLAY_MODE, DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE);
        this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(false));
        this.env.put(ENV_APP_RESULT_VIEWER, String.valueOf(DEFAULT_APP_RESULT_VIEWER));
    }

    public AbstractSignalNotificationHandler getSignalHandler() {
        return this.signalHandler;
    }

    public String readPassword(String textToPrompt) throws IOException {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.readWithMask(textToPrompt, Character.valueOf('*'));
    }

    public String readText(String textToPrompt) throws IOException {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.interact(textToPrompt);
    }

    public void start() {
        this.runner = new Thread((Runnable)((Object)this), this.getShellName());
        this.runner.start();
    }

    protected String getShellName() {
        return "Gfsh Launcher";
    }

    public void stop() {
        this.closeShell();
        LogWrapper.close();
        if (this.operationInvoker != null && this.operationInvoker.isConnected()) {
            this.operationInvoker.stop();
        }
    }

    public void waitForComplete() throws InterruptedException {
        this.runner.join();
    }

    private void executeInitFileIfPresent() {
        String initFileName = this.gfshConfig.getInitFileName();
        if (initFileName != null) {
            this.gfshFileLogger.info("Using " + initFileName);
            try {
                File gfshInitFile = new File(initFileName);
                boolean continueOnError = false;
                this.executeScript(gfshInitFile, this.isQuietMode(), continueOnError);
            }
            catch (Exception exception) {
                this.gfshFileLogger.severe(initFileName, exception);
                this.setLastExecutionStatus(-1);
            }
        }
    }

    protected Collection<URL> findResources(String resourceName) {
        return null;
    }

    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public Parser getParser() {
        return this.parser;
    }

    public GfshParser getGfshParser() {
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScriptLine(String line) {
        boolean success = false;
        String withPropsExpanded = line;
        try {
            if (line.contains("$")) {
                withPropsExpanded = this.expandProperties(line);
            }
            String logMessage = "Command String to execute .. ";
            if (!line.equals(withPropsExpanded)) {
                if (!this.isQuietMode()) {
                    Gfsh.println("Post substitution: " + withPropsExpanded);
                }
                logMessage = "Command String after substitution : ";
                this.expandedPropCommandsMap.put(withPropsExpanded, line);
            }
            if (this.gfshFileLogger.fineEnabled()) {
                this.gfshFileLogger.fine(logMessage + withPropsExpanded);
            }
            success = super.executeScriptLine(withPropsExpanded);
        }
        catch (Exception e) {
            this.setLastExecutionStatus(-1);
        }
        finally {
            this.gfshHistory.setAutoFlush(true);
            this.gfshHistory.addToHistory(line);
            this.gfshHistory.setAutoFlush(false);
            this.expandedPropCommandsMap.clear();
        }
        return success;
    }

    public String interact(String textToPrompt) throws IOException {
        return this.reader.readLine(textToPrompt);
    }

    public String readWithMask(String textToPrompt, Character mask) throws IOException {
        return this.reader.readLine(textToPrompt, mask);
    }

    public void printBannerAndWelcome() {
        this.printAsInfo(this.getBanner());
        this.printAsInfo(this.getWelcomeMessage());
    }

    public String getBanner() {
        StringBuilder sb = new StringBuilder();
        sb.append("    _________________________     __").append(LINE_SEPARATOR);
        sb.append("   / _____/ ______/ ______/ /____/ /").append(LINE_SEPARATOR);
        sb.append("  / /  __/ /___  /_____  / _____  / ").append(LINE_SEPARATOR);
        sb.append(" / /__/ / ____/  _____/ / /    / /  ").append(LINE_SEPARATOR);
        sb.append("/______/_/      /______/_/    /_/   ").append(" ").append(this.getVersion()).append(LINE_SEPARATOR);
        return this.ansiHandler.decorateString(sb.toString(), ANSIHandler.ANSIStyle.BLUE);
    }

    protected String getProductName() {
        return GFSH_APP_NAME;
    }

    public String getVersion() {
        return this.getVersion(false);
    }

    public String getVersion(boolean full) {
        if (full) {
            return GemFireVersion.asString();
        }
        return GemFireVersion.getGemFireVersion();
    }

    public String getWelcomeMessage() {
        return this.ansiHandler.decorateString("Monitor and Manage " + GemFireVersion.getProductName(), ANSIHandler.ANSIStyle.CYAN);
    }

    protected void handleExecutionResult(Object result) {
        try {
            if (result instanceof Result) {
                CommandResult cmdResult;
                Result commandResult = (Result)result;
                boolean isError = Result.Status.ERROR.equals((Object)commandResult.getStatus());
                if (isError) {
                    this.setLastExecutionStatus(-2);
                } else {
                    this.setLastExecutionStatus(0);
                }
                if (this.useExternalViewer(commandResult)) {
                    CliUtil.runLessCommandAsExternalViewer(commandResult, isError);
                } else if (!this.isScriptRunning) {
                    while (commandResult.hasNextLine()) {
                        this.write(commandResult.nextLine(), isError);
                    }
                } else if (!this.supressScriptCmdOutput) {
                    while (commandResult.hasNextLine()) {
                        this.write(commandResult.nextLine(), isError);
                    }
                }
                resultTypeTL.set(null);
                if (result instanceof CommandResult && (cmdResult = (CommandResult)result).hasIncomingFiles()) {
                    boolean isAlreadySaved;
                    boolean bl = isAlreadySaved = cmdResult.getNumTimesSaved() > 0;
                    if (!isAlreadySaved) {
                        cmdResult.saveIncomingFiles(null);
                    }
                    Gfsh.println();
                }
            }
            if (result != null && !(result instanceof Result)) {
                this.printAsInfo(result.toString());
            }
        }
        catch (Exception e) {
            this.printAsWarning(e.getMessage());
            this.logToFile(e.getMessage(), e);
        }
    }

    private boolean useExternalViewer(Result result) {
        boolean flag;
        boolean bl = flag = EXTERNAL_RESULT_VIEWER.equals(this.getEnvProperty(ENV_APP_RESULT_VIEWER)) && this.isUnix();
        if (result instanceof CommandResult) {
            CommandResult commandResult = (CommandResult)result;
            resultTypeTL.set(commandResult.getType().equals("info"));
            return flag && !commandResult.getType().equals("info");
        }
        return false;
    }

    private boolean isUnix() {
        return OS.indexOf("win") < 0;
    }

    private void write(String message, boolean isError) {
        if (isError) {
            this.printAsWarning(message);
        } else {
            Gfsh.println(message);
        }
    }

    protected ConsoleReader createConsoleReader() {
        ConsoleReader consoleReader = super.createConsoleReader();
        consoleReader.setHistory((History)this.gfshHistory);
        this.terminal = consoleReader.getTerminal();
        return consoleReader;
    }

    protected void logCommandToOutput(String processedLine) {
        String originalString = this.expandedPropCommandsMap.get(processedLine);
        if (originalString != null) {
            super.logCommandToOutput(GfshHistory.redact(originalString));
            super.logCommandToOutput(GfshHistory.redact("// Post substitution"));
            super.logCommandToOutput(GfshHistory.redact("//" + processedLine));
        } else {
            super.logCommandToOutput(GfshHistory.redact(processedLine));
        }
    }

    public String versionInfo() {
        return this.getVersion();
    }

    public int getTerminalHeight() {
        return this.terminal != null ? this.terminal.getHeight() : 100;
    }

    public int getTerminalWidth() {
        if (this.terminal != null) {
            return this.terminal.getWidth();
        }
        Map<String, String> env = System.getenv();
        String columnsFromEnv = env.get("COLUMNS");
        if (columnsFromEnv != null) {
            return Integer.parseInt(columnsFromEnv);
        }
        return 100;
    }

    public int getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public void setLastExecutionStatus(int lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(lastExecutionStatus));
    }

    public void printAsInfo(String message) {
        if (this.isHeadlessMode) {
            Gfsh.println(message);
        } else {
            this.logger.info(message);
        }
    }

    public void printAsWarning(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            this.logger.warning(message);
        }
    }

    public void printAsSevere(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            this.logger.severe(message);
        }
    }

    public void logInfo(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.INFO, message, t);
        } else {
            this.logger.info(message);
        }
        if (this.gfshFileLogger.infoEnabled()) {
            this.gfshFileLogger.info(message, t);
        }
    }

    public void logWarning(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.WARNING, message, t);
        } else {
            this.logger.warning(message);
        }
        if (this.gfshFileLogger.warningEnabled()) {
            this.gfshFileLogger.warning(message, t);
        }
    }

    public void logSevere(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.SEVERE, message, t);
        } else {
            this.logger.severe(message);
        }
        if (this.gfshFileLogger.severeEnabled()) {
            this.gfshFileLogger.severe(message, t);
        }
    }

    public boolean logToFile(String message, Throwable t) {
        boolean loggedMessage = false;
        if (this.gfshFileLogger != null) {
            this.gfshFileLogger.info(message, t);
            loggedMessage = true;
        }
        return loggedMessage;
    }

    public Result executeScript(File scriptFile, boolean quiet, boolean continueOnError) {
        Result result = null;
        String initialIsQuiet = this.getEnvProperty(ENV_APP_QUIET_EXECUTION);
        try {
            BufferedReader reader;
            this.isScriptRunning = true;
            if (scriptFile == null) {
                throw new IllegalArgumentException("Given script file is null.");
            }
            if (!scriptFile.exists()) {
                throw new IllegalArgumentException("Given script file does not exist.");
            }
            if (scriptFile.exists() && scriptFile.isDirectory()) {
                throw new IllegalArgumentException(scriptFile.getPath() + " is a directory.");
            }
            ScriptExecutionDetails scriptInfo = new ScriptExecutionDetails(scriptFile.getPath());
            if (scriptFile.exists()) {
                this.setEnvProperty(ENV_APP_QUIET_EXECUTION, String.valueOf(quiet));
                this.supressScriptCmdOutput = quiet;
                reader = new BufferedReader(new FileReader(scriptFile));
                String lineRead = "";
                StringBuilder linesBuffer = new StringBuilder();
                String linesBufferString = "";
                int commandSrNum = 0;
                CommentSkipHelper commentSkipper = new CommentSkipHelper();
                block5: while (this.exitShellRequest == null && (lineRead = reader.readLine()) != null) {
                    String lineWithoutComments;
                    if (linesBuffer == null) {
                        linesBuffer = new StringBuilder();
                    }
                    if ((lineWithoutComments = commentSkipper.skipComments(lineRead)) == null || lineWithoutComments.isEmpty()) continue;
                    if (linesBuffer.length() != 0) {
                        linesBuffer.append(" ");
                    }
                    linesBuffer.append(lineWithoutComments);
                    linesBufferString = linesBuffer.toString();
                    if (!linesBufferString.endsWith("\\")) {
                        List<String> commandList = MultiCommandHelper.getMultipleCommands(linesBufferString);
                        for (String cmdLet : commandList) {
                            if (cmdLet.isEmpty()) continue;
                            String redactedCmdLet = ArgumentRedactor.redact(cmdLet);
                            Gfsh.println(++commandSrNum + ". Executing - " + redactedCmdLet);
                            Gfsh.println();
                            boolean executeSuccess = this.executeScriptLine(cmdLet);
                            if (!executeSuccess) {
                                this.setLastExecutionStatus(-1);
                            }
                            scriptInfo.addCommandAndStatus(cmdLet, this.getLastExecutionStatus() == -1 || this.getLastExecutionStatus() == -2 ? "FAILED" : "PASSED");
                            if (this.getLastExecutionStatus() != -1 && this.getLastExecutionStatus() != -2 || continueOnError) continue;
                            break block5;
                        }
                        linesBuffer = null;
                        linesBufferString = null;
                        continue;
                    }
                    linesBuffer.deleteCharAt(linesBuffer.length() - 1);
                }
            } else {
                throw new CommandProcessingException(scriptFile.getPath() + " doesn't exist.", CommandProcessingException.ARGUMENT_INVALID, scriptFile);
            }
            reader.close();
            result = scriptInfo.getResult();
            scriptInfo.logScriptExecutionInfo(this.gfshFileLogger, result);
            if (quiet) {
                result = ResultBuilder.createInfoResult("");
            }
        }
        catch (IOException e) {
            throw new CommandProcessingException("Error while reading file " + scriptFile, CommandProcessingException.RESOURCE_ACCESS_ERROR, e);
        }
        finally {
            this.setEnvProperty(ENV_APP_QUIET_EXECUTION, initialIsQuiet);
            this.isScriptRunning = false;
        }
        return result;
    }

    public String setEnvProperty(String propertyName, String propertyValue) {
        if (propertyName == null || propertyValue == null) {
            throw new IllegalArgumentException("Environment Property name and/or value can not be set to null.");
        }
        if (propertyName.startsWith("SYS") || this.readonlyAppEnv.contains(propertyName)) {
            throw new IllegalArgumentException("The Property " + propertyName + " can not be modified.");
        }
        return this.env.put(propertyName, propertyValue);
    }

    public String getEnvProperty(String propertyName) {
        return this.env.get(propertyName);
    }

    public Map<String, String> getEnv() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.putAll(this.env);
        return map;
    }

    public void setPromptPath(String currentContext) {
        super.setPromptPath(currentContext);
    }

    public boolean isQuietMode() {
        return Boolean.parseBoolean(this.env.get(ENV_APP_QUIET_EXECUTION));
    }

    public void promptLoop() {
        String line = null;
        String prompt = this.getPromptText();
        try {
            this.gfshHistory.setAutoFlush(false);
            while (this.exitShellRequest == null && (line = Gfsh.readLine(this.reader, prompt)) != null) {
                if (!line.endsWith("\\")) {
                    List<String> commandList = MultiCommandHelper.getMultipleCommands(line);
                    for (String cmdLet : commandList) {
                        String trimmedCommand = cmdLet.trim();
                        if (trimmedCommand.isEmpty()) continue;
                        this.executeCommand(cmdLet);
                    }
                    prompt = this.getPromptText();
                    continue;
                }
                prompt = this.getDefaultSecondaryPrompt();
                this.reader.getCursorBuffer().cursor = 0;
                this.reader.getCursorBuffer().write((CharSequence)(Gfsh.removeBackslash(line) + LINE_SEPARATOR));
            }
            if (line == null) {
                this.exitShellRequest = ExitShellRequest.NORMAL_EXIT;
                this.gfshFileLogger.info("Exiting gfsh, it seems Ctrl-D was pressed.");
            }
        }
        catch (IOException e) {
            this.logSevere(e.getMessage(), e);
        }
        Gfsh.println((line == null ? LINE_SEPARATOR : "") + "Exiting... ");
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
    }

    String getDefaultSecondaryPrompt() {
        return this.ansiHandler.decorateString(DEFAULT_SECONDARY_PROMPT, ANSIHandler.ANSIStyle.YELLOW);
    }

    public boolean isConnectedAndReady() {
        return this.operationInvoker != null && this.operationInvoker.isConnected() && this.operationInvoker.isReady();
    }

    public static boolean isCurrentInstanceConnectedAndReady() {
        return Gfsh.getCurrentInstance() != null && Gfsh.getCurrentInstance().isConnectedAndReady();
    }

    public OperationInvoker getOperationInvoker() {
        return this.operationInvoker;
    }

    public void setOperationInvoker(OperationInvoker operationInvoker) {
        this.operationInvoker = operationInvoker;
    }

    public GfshConfig getGfshConfig() {
        return this.gfshConfig;
    }

    protected String getHistoryFileName() {
        return this.gfshConfig.getHistoryFileName();
    }

    public void clearHistory() {
        this.gfshHistory.clear();
        if (!this.gfshConfig.deleteHistoryFile()) {
            this.printAsWarning("Gfsh history file is not deleted");
        }
    }

    public String getLogFilePath() {
        return this.gfshConfig.getLogFilePath();
    }

    public boolean isLoggingEnabled() {
        return this.gfshConfig.isLoggingEnabled();
    }

    protected String getPromptText() {
        int clusterId;
        String defaultPrompt = this.gfshConfig.getDefaultPrompt();
        String contextPath = "";
        String clusterString = "";
        if (this.getOperationInvoker() != null && this.isConnectedAndReady() && (clusterId = this.getOperationInvoker().getClusterId()) != -1) {
            clusterString = "Cluster-" + clusterId + " ";
        }
        defaultPrompt = MessageFormat.format(defaultPrompt, clusterString, contextPath);
        return this.ansiHandler.decorateString(defaultPrompt, ANSIHandler.ANSIStyle.YELLOW);
    }

    public void notifyDisconnect(String endPoints) {
        String message = CliStrings.format("No longer connected to {0}.", new Object[]{endPoints});
        this.printAsSevere(LINE_SEPARATOR + message);
        if (this.gfshFileLogger.severeEnabled()) {
            this.gfshFileLogger.severe(message);
        }
        this.setPromptPath("");
    }

    public boolean getDebug() {
        return this.debugON;
    }

    public void setDebug(boolean flag) {
        this.debugON = flag;
    }

    public boolean isHeadlessMode() {
        return this.isHeadlessMode;
    }

    public GfshHistory getGfshHistory() {
        return this.gfshHistory;
    }

    private String expandProperties(String input) {
        String output = input;
        Scanner s = new Scanner(output);
        String foundInLine = null;
        while ((foundInLine = s.findInLine("(\\$[\\{]\\w+[\\}])")) != null) {
            String envProperty = this.getEnvProperty(Gfsh.extractKey(foundInLine));
            envProperty = envProperty != null ? envProperty : "";
            output = output.replace(foundInLine, envProperty);
        }
        return output;
    }

    static {
        resultTypeTL = new ThreadLocal();
        OS = System.getProperty("os.name").toLowerCase();
    }
}

