/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.Collection;
import java.util.List;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.CliJsonSerializable;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ObjectResultData;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class ResultBuilder {
    public static final int CODE_SHELLCLIENT_ABORT_OP = 110;
    public static final int ERRORCODE_DEFAULT = 400;
    public static final int ERRORCODE_CONNECTION_ERROR = 405;
    public static final int ERRORCODE_SHELLCLIENT_ERROR = 410;
    public static final int ERRORCODE_UNAUTHORIZED = 415;
    public static final int ERRORCODE_PARSING_ERROR = 501;
    public static final int ERRORCODE_GEODE_ERROR = 505;
    public static final int ERRORCODE_BADRESPONSE_ERROR = 510;
    public static final int ERRORCODE_BADCONFIG_ERROR = 515;
    public static final int ERRORCODE_USER_ERROR = 520;
    public static final Result ERROR_RESULT_DEFAULT = ResultBuilder.createErrorResult(400, "Error occurred while executing command.");

    public static Result createConnectionErrorResult(String message) {
        String errorMessage = message != null ? message : "Connection Error occurred.";
        return ResultBuilder.createErrorResult(405, errorMessage);
    }

    public static Result createShellClientErrorResult(String message) {
        return ResultBuilder.createErrorResult(410, message);
    }

    public static Result createShellClientAbortOperationResult(String message) {
        return ResultBuilder.createErrorResult(110, message);
    }

    public static Result createParsingErrorResult(String message) {
        return ResultBuilder.createErrorResult(501, "Could not parse command string. " + message);
    }

    public static Result createBadConfigurationErrorResult(String message) {
        return ResultBuilder.createErrorResult(515, "Configuration error. " + message);
    }

    public static Result createGemFireErrorResult(String message) {
        return ResultBuilder.createErrorResult(505, "Could not process command due to error. " + message);
    }

    public static Result createGemFireUnAuthorizedErrorResult(String message) {
        return ResultBuilder.createErrorResult(415, message);
    }

    public static Result createUserErrorResult(String message) {
        return ResultBuilder.createErrorResult(520, message);
    }

    public static Result createBadResponseErrorResult(String message) {
        return ResultBuilder.createErrorResult(510, "Could not read command response. " + message);
    }

    private static Result createErrorResult(int errorCode, String message) {
        ErrorResultData errorResultData = new ErrorResultData();
        errorResultData.setErrorCode(errorCode);
        errorResultData.addLine(message);
        return ResultBuilder.buildResult(errorResultData);
    }

    public static Result createInfoResult(String message) {
        InfoResultData infoResultData = new InfoResultData();
        infoResultData.addLine(message);
        return ResultBuilder.buildResult(infoResultData);
    }

    public static TabularResultData createTabularResultData() {
        return new TabularResultData();
    }

    public static CompositeResultData createCompositeResultData() {
        return new CompositeResultData();
    }

    public static <T extends CliJsonSerializable> ObjectResultData<T> createObjectResultData() {
        return new ObjectResultData();
    }

    public static InfoResultData createInfoResultData() {
        return new InfoResultData();
    }

    public static ErrorResultData createErrorResultData() {
        return new ErrorResultData();
    }

    public static Result buildResult(ResultData resultData) {
        return new CommandResult(resultData);
    }

    public static Result fromJson(GfJsonObject gfJsonObject) {
        return ResultBuilder.fromJson(gfJsonObject.toString());
    }

    public static Result fromJson(String json) {
        Result result;
        try {
            AbstractResultData resultData;
            GfJsonObject jsonObject = new GfJsonObject(json);
            String contentType = jsonObject.getString("contentType");
            GfJsonObject data = jsonObject.getJSONObject("data");
            if ("table".equals(contentType)) {
                resultData = new TabularResultData(data);
            } else if ("info".equals(contentType)) {
                resultData = new InfoResultData(data);
            } else if ("error".equals(contentType)) {
                resultData = new ErrorResultData(data);
            } else if ("composite".equals(contentType)) {
                resultData = new CompositeResultData(data);
            } else if ("object".equals(contentType)) {
                resultData = new ObjectResultData(data);
            } else {
                ErrorResultData errorResultData = new ErrorResultData();
                errorResultData.addLine("Can not detect result type, unknown response format: " + json);
                resultData = errorResultData;
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (GfJsonException e) {
            result = ResultBuilder.createBadResponseErrorResult(json);
        }
        return result;
    }

    public static String resultAsString(Result result) {
        StringBuilder builder = new StringBuilder();
        if (result != null) {
            while (result.hasNextLine()) {
                builder.append(result.nextLine());
            }
        }
        return builder.toString();
    }

    static ResultData getReadOnlyResultData(ResultData resultData) {
        AbstractResultData wrapperResultData;
        String contentType = resultData.getType();
        if ("table".equals(contentType)) {
            wrapperResultData = new TabularResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public TabularResultData accumulate(String accumulateFor, Object value) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("info".equals(contentType)) {
            wrapperResultData = new InfoResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData addLine(String line) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("error".equals(contentType)) {
            wrapperResultData = new ErrorResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData addLine(String line) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData setErrorCode(int errorCode) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("composite".equals(contentType)) {
            wrapperResultData = new CompositeResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData.SectionResultData addSection() {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData.SectionResultData addSection(String keyToRetrieve) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData addSeparator(char buildSeparatorFrom) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("object".equals(contentType)) {
            final ObjectResultData wrapped = (ObjectResultData)resultData;
            wrapperResultData = new ObjectResultData<CliJsonSerializable>(){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ObjectResultData<CliJsonSerializable> addCollection(Collection<CliJsonSerializable> infoBeans) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ObjectResultData<CliJsonSerializable> addObject(CliJsonSerializable infoBean) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public List<CliJsonSerializable> getAllObjects() {
                    return wrapped.getAllObjects();
                }
            };
        } else {
            ErrorResultData errorResultData = new ErrorResultData();
            errorResultData.addLine("Can not detect result type, unknown result data format for: " + resultData);
            wrapperResultData = errorResultData;
        }
        return wrapperResultData;
    }
}

