/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class RegionFunctionArgs
implements Serializable {
    private static final long serialVersionUID = -5158224572470173267L;
    private final String regionPath;
    private final RegionShortcut regionShortcut;
    private final String useAttributesFrom;
    private final Boolean skipIfExists;
    private final String keyConstraint;
    private final String valueConstraint;
    private Boolean statisticsEnabled;
    private final boolean isSetStatisticsEnabled;
    private final ExpirationAttrs entryExpirationIdleTime;
    private final ExpirationAttrs entryExpirationTTL;
    private final ExpirationAttrs regionExpirationIdleTime;
    private final ExpirationAttrs regionExpirationTTL;
    private final String diskStore;
    private Boolean diskSynchronous;
    private final boolean isSetDiskSynchronous;
    private Boolean enableAsyncConflation;
    private final boolean isSetEnableAsyncConflation;
    private Boolean enableSubscriptionConflation;
    private final boolean isSetEnableSubscriptionConflation;
    private final Set<String> cacheListeners;
    private final String cacheLoader;
    private final String cacheWriter;
    private final Set<String> asyncEventQueueIds;
    private final Set<String> gatewaySenderIds;
    private Boolean concurrencyChecksEnabled;
    private final boolean isSetConcurrencyChecksEnabled;
    private Boolean cloningEnabled;
    private final boolean isSetCloningEnabled;
    private Boolean mcastEnabled;
    private final boolean isSetMcastEnabled;
    private Integer concurrencyLevel;
    private final boolean isSetConcurrencyLevel;
    private final PartitionArgs partitionArgs;
    private final Integer evictionMax;
    private String compressor;
    private final boolean isSetCompressor;
    private Boolean offHeap;
    private final boolean isSetOffHeap;
    private RegionAttributes<?, ?> regionAttributes;
    private final boolean isPartitionResolver;
    private String partitionResolver;

    public RegionFunctionArgs(String regionPath, RegionShortcut regionShortcut, String useAttributesFrom, boolean skipIfExists, String keyConstraint, String valueConstraint, Boolean statisticsEnabled, ExpirationAttrs entryExpirationIdleTime, ExpirationAttrs entryExpirationTTL, ExpirationAttrs regionExpirationIdleTime, ExpirationAttrs regionExpirationTTL, String diskStore, Boolean diskSynchronous, Boolean enableAsyncConflation, Boolean enableSubscriptionConflation, String[] cacheListeners, String cacheLoader, String cacheWriter, String[] asyncEventQueueIds, String[] gatewaySenderIds, Boolean concurrencyChecksEnabled, Boolean cloningEnabled, Integer concurrencyLevel, String prColocatedWith, Integer prLocalMaxMemory, Long prRecoveryDelay, Integer prRedundantCopies, Long prStartupRecoveryDelay, Long prTotalMaxMemory, Integer prTotalNumBuckets, Integer evictionMax, String compressor, Boolean offHeap, Boolean mcastEnabled, String partitionResolver) {
        this.regionPath = regionPath;
        this.regionShortcut = regionShortcut;
        this.useAttributesFrom = useAttributesFrom;
        this.skipIfExists = skipIfExists;
        this.keyConstraint = keyConstraint;
        this.valueConstraint = valueConstraint;
        this.evictionMax = evictionMax;
        boolean bl = this.isSetStatisticsEnabled = statisticsEnabled != null;
        if (this.isSetStatisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }
        this.entryExpirationIdleTime = entryExpirationIdleTime;
        this.entryExpirationTTL = entryExpirationTTL;
        this.regionExpirationIdleTime = regionExpirationIdleTime;
        this.regionExpirationTTL = regionExpirationTTL;
        this.diskStore = diskStore;
        boolean bl2 = this.isSetDiskSynchronous = diskSynchronous != null;
        if (this.isSetDiskSynchronous) {
            this.diskSynchronous = diskSynchronous;
        }
        boolean bl3 = this.isSetEnableAsyncConflation = enableAsyncConflation != null;
        if (this.isSetEnableAsyncConflation) {
            this.enableAsyncConflation = enableAsyncConflation;
        }
        boolean bl4 = this.isSetEnableSubscriptionConflation = enableSubscriptionConflation != null;
        if (this.isSetEnableSubscriptionConflation) {
            this.enableSubscriptionConflation = enableSubscriptionConflation;
        }
        if (cacheListeners != null) {
            this.cacheListeners = new LinkedHashSet<String>();
            this.cacheListeners.addAll(Arrays.asList(cacheListeners));
        } else {
            this.cacheListeners = null;
        }
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
        if (asyncEventQueueIds != null) {
            this.asyncEventQueueIds = new LinkedHashSet<String>();
            this.asyncEventQueueIds.addAll(Arrays.asList(asyncEventQueueIds));
        } else {
            this.asyncEventQueueIds = null;
        }
        if (gatewaySenderIds != null) {
            this.gatewaySenderIds = new LinkedHashSet<String>();
            this.gatewaySenderIds.addAll(Arrays.asList(gatewaySenderIds));
        } else {
            this.gatewaySenderIds = null;
        }
        boolean bl5 = this.isSetConcurrencyChecksEnabled = concurrencyChecksEnabled != null;
        if (this.isSetConcurrencyChecksEnabled) {
            this.concurrencyChecksEnabled = concurrencyChecksEnabled;
        }
        boolean bl6 = this.isSetCloningEnabled = cloningEnabled != null;
        if (this.isSetCloningEnabled) {
            this.cloningEnabled = cloningEnabled;
        }
        boolean bl7 = this.isSetMcastEnabled = mcastEnabled != null;
        if (this.isSetMcastEnabled) {
            this.mcastEnabled = mcastEnabled;
        }
        boolean bl8 = this.isSetConcurrencyLevel = concurrencyLevel != null;
        if (this.isSetConcurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
        }
        this.partitionArgs = new PartitionArgs(prColocatedWith, prLocalMaxMemory, prRecoveryDelay, prRedundantCopies, prStartupRecoveryDelay, prTotalMaxMemory, prTotalNumBuckets, partitionResolver);
        boolean bl9 = this.isSetCompressor = compressor != null;
        if (this.isSetCompressor) {
            this.compressor = compressor;
        }
        boolean bl10 = this.isSetOffHeap = offHeap != null;
        if (this.isSetOffHeap) {
            this.offHeap = offHeap;
        }
        boolean bl11 = this.isPartitionResolver = partitionResolver != null;
        if (this.isPartitionResolver) {
            this.partitionResolver = partitionResolver;
        }
    }

    public RegionFunctionArgs(String regionPath, String useAttributesFrom, boolean skipIfExists, String keyConstraint, String valueConstraint, Boolean statisticsEnabled, ExpirationAttrs entryExpirationIdleTime, ExpirationAttrs entryExpirationTTL, ExpirationAttrs regionExpirationIdleTime, ExpirationAttrs regionExpirationTTL, String diskStore, Boolean diskSynchronous, Boolean enableAsyncConflation, Boolean enableSubscriptionConflation, String[] cacheListeners, String cacheLoader, String cacheWriter, String[] asyncEventQueueIds, String[] gatewaySenderIds, Boolean concurrencyChecksEnabled, Boolean cloningEnabled, Integer concurrencyLevel, String prColocatedWith, Integer prLocalMaxMemory, Long prRecoveryDelay, Integer prRedundantCopies, Long prStartupRecoveryDelay, Long prTotalMaxMemory, Integer prTotalNumBuckets, Boolean offHeap, Boolean mcastEnabled, RegionAttributes<?, ?> regionAttributes, String partitionResolver) {
        this(regionPath, null, useAttributesFrom, skipIfExists, keyConstraint, valueConstraint, statisticsEnabled, entryExpirationIdleTime, entryExpirationTTL, regionExpirationIdleTime, regionExpirationTTL, diskStore, diskSynchronous, enableAsyncConflation, enableSubscriptionConflation, cacheListeners, cacheLoader, cacheWriter, asyncEventQueueIds, gatewaySenderIds, concurrencyChecksEnabled, cloningEnabled, concurrencyLevel, prColocatedWith, prLocalMaxMemory, prRecoveryDelay, prRedundantCopies, prStartupRecoveryDelay, prTotalMaxMemory, prTotalNumBuckets, null, null, offHeap, mcastEnabled, partitionResolver);
        this.regionAttributes = regionAttributes;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public RegionShortcut getRegionShortcut() {
        return this.regionShortcut;
    }

    public String getUseAttributesFrom() {
        return this.useAttributesFrom;
    }

    public Boolean isSetUseAttributesFrom() {
        return this.regionShortcut == null && this.useAttributesFrom != null && this.regionAttributes != null;
    }

    public Boolean isSkipIfExists() {
        return this.skipIfExists;
    }

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    public Boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public Boolean isSetStatisticsEnabled() {
        return this.isSetStatisticsEnabled;
    }

    public ExpirationAttrs getEntryExpirationIdleTime() {
        return this.entryExpirationIdleTime;
    }

    public ExpirationAttrs getEntryExpirationTTL() {
        return this.entryExpirationTTL;
    }

    public ExpirationAttrs getRegionExpirationIdleTime() {
        return this.regionExpirationIdleTime;
    }

    public ExpirationAttrs getRegionExpirationTTL() {
        return this.regionExpirationTTL;
    }

    public String getDiskStore() {
        return this.diskStore;
    }

    public Boolean isDiskSynchronous() {
        return this.diskSynchronous;
    }

    public Boolean isSetDiskSynchronous() {
        return this.isSetDiskSynchronous;
    }

    public Boolean isOffHeap() {
        return this.offHeap;
    }

    public Boolean isSetOffHeap() {
        return this.isSetOffHeap;
    }

    public Boolean isEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    public Boolean isSetEnableAsyncConflation() {
        return this.isSetEnableAsyncConflation;
    }

    public Boolean isEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    public Boolean isSetEnableSubscriptionConflation() {
        return this.isSetEnableSubscriptionConflation;
    }

    public Set<String> getCacheListeners() {
        if (this.cacheListeners == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.cacheListeners);
    }

    public String getCacheLoader() {
        return this.cacheLoader;
    }

    public String getCacheWriter() {
        return this.cacheWriter;
    }

    public Set<String> getAsyncEventQueueIds() {
        if (this.asyncEventQueueIds == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.asyncEventQueueIds);
    }

    public Set<String> getGatewaySenderIds() {
        if (this.gatewaySenderIds == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.gatewaySenderIds);
    }

    public String getPartitionResolver() {
        return this.partitionResolver;
    }

    public Boolean isPartitionResolverSet() {
        return this.isPartitionResolver;
    }

    public Boolean isConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public Boolean isSetConcurrencyChecksEnabled() {
        return this.isSetConcurrencyChecksEnabled;
    }

    public Boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public Boolean isSetCloningEnabled() {
        return this.isSetCloningEnabled;
    }

    public Boolean isMcastEnabled() {
        return this.mcastEnabled;
    }

    public Boolean isSetMcastEnabled() {
        return this.isSetMcastEnabled;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Boolean isSetConcurrencyLevel() {
        return this.isSetConcurrencyLevel;
    }

    public boolean withPartitioning() {
        return this.hasPartitionAttributes() || this.regionShortcut != null && this.regionShortcut.name().startsWith("PARTITION");
    }

    public boolean hasPartitionAttributes() {
        return this.partitionArgs != null && this.partitionArgs.hasPartitionAttributes() != false;
    }

    public PartitionArgs getPartitionArgs() {
        return this.partitionArgs;
    }

    public Integer getEvictionMax() {
        return this.evictionMax;
    }

    public String getCompressor() {
        return this.compressor;
    }

    public boolean isSetCompressor() {
        return this.isSetCompressor;
    }

    public <K, V> RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public static class PartitionArgs
    implements Serializable {
        private static final long serialVersionUID = 5907052187323280919L;
        private final String prColocatedWith;
        private int prLocalMaxMemory;
        private final boolean isSetPRLocalMaxMemory;
        private long prRecoveryDelay;
        private final boolean isSetPRRecoveryDelay;
        private int prRedundantCopies;
        private final boolean isSetPRRedundantCopies;
        private long prStartupRecoveryDelay;
        private final boolean isSetPRStartupRecoveryDelay;
        private long prTotalMaxMemory;
        private final boolean isSetPRTotalMaxMemory;
        private int prTotalNumBuckets;
        private final boolean isSetPRTotalNumBuckets;
        private final boolean isPartitionResolver;
        private String partitionResolver;
        private boolean hasPartitionAttributes;
        private final Set<String> userSpecifiedPartitionAttributes = new HashSet<String>();

        public PartitionArgs(String prColocatedWith, Integer prLocalMaxMemory, Long prRecoveryDelay, Integer prRedundantCopies, Long prStartupRecoveryDelay, Long prTotalMaxMemory, Integer prTotalNumBuckets, String partitionResolver) {
            this.prColocatedWith = prColocatedWith;
            if (this.prColocatedWith != null) {
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("colocated-with");
            }
            boolean bl = this.isSetPRLocalMaxMemory = prLocalMaxMemory != null;
            if (this.isSetPRLocalMaxMemory) {
                this.prLocalMaxMemory = prLocalMaxMemory;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("local-max-memory");
            }
            boolean bl2 = this.isSetPRRecoveryDelay = prRecoveryDelay != null;
            if (this.isSetPRRecoveryDelay) {
                this.prRecoveryDelay = prRecoveryDelay;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("recovery-delay");
            }
            boolean bl3 = this.isSetPRRedundantCopies = prRedundantCopies != null;
            if (this.isSetPRRedundantCopies) {
                this.prRedundantCopies = prRedundantCopies;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("redundant-copies");
            }
            boolean bl4 = this.isSetPRStartupRecoveryDelay = prStartupRecoveryDelay != null;
            if (this.isSetPRStartupRecoveryDelay) {
                this.prStartupRecoveryDelay = prStartupRecoveryDelay;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("startup-recovery-delay");
            }
            boolean bl5 = this.isSetPRTotalMaxMemory = prTotalMaxMemory != null;
            if (this.isSetPRTotalMaxMemory) {
                this.prTotalMaxMemory = prTotalMaxMemory;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("total-max-memory");
            }
            boolean bl6 = this.isSetPRTotalNumBuckets = prTotalNumBuckets != null;
            if (this.isSetPRTotalNumBuckets) {
                this.prTotalNumBuckets = prTotalNumBuckets;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("total-num-buckets");
            }
            boolean bl7 = this.isPartitionResolver = partitionResolver != null;
            if (this.isPartitionResolver) {
                this.partitionResolver = partitionResolver;
                this.hasPartitionAttributes = true;
                this.userSpecifiedPartitionAttributes.add("partition-resolver");
            }
        }

        public Boolean hasPartitionAttributes() {
            return this.hasPartitionAttributes;
        }

        public String getUserSpecifiedPartitionAttributes() {
            return CliUtil.collectionToString(this.userSpecifiedPartitionAttributes, -1);
        }

        public String getPrColocatedWith() {
            return this.prColocatedWith;
        }

        public Integer getPrLocalMaxMemory() {
            return this.prLocalMaxMemory;
        }

        public Boolean isSetPRLocalMaxMemory() {
            return this.isSetPRLocalMaxMemory;
        }

        public Long getPrRecoveryDelay() {
            return this.prRecoveryDelay;
        }

        public Boolean isSetPRRecoveryDelay() {
            return this.isSetPRRecoveryDelay;
        }

        public Integer getPrRedundantCopies() {
            return this.prRedundantCopies;
        }

        public Boolean isSetPRRedundantCopies() {
            return this.isSetPRRedundantCopies;
        }

        public Long getPrStartupRecoveryDelay() {
            return this.prStartupRecoveryDelay;
        }

        public Boolean isSetPRStartupRecoveryDelay() {
            return this.isSetPRStartupRecoveryDelay;
        }

        public Long getPrTotalMaxMemory() {
            return this.prTotalMaxMemory;
        }

        public Boolean isSetPRTotalMaxMemory() {
            return this.isSetPRTotalMaxMemory;
        }

        public Integer getPrTotalNumBuckets() {
            return this.prTotalNumBuckets;
        }

        public Boolean isSetPRTotalNumBuckets() {
            return this.isSetPRTotalNumBuckets;
        }
    }

    public static class ExpirationAttrs
    implements Serializable {
        private static final long serialVersionUID = 1474255033398008062L;
        private ExpirationFor type;
        private Integer time;
        private ExpirationAction action;

        public ExpirationAttrs(ExpirationFor type, Integer time, String action) {
            this.type = type;
            this.time = time;
            if (action != null) {
                this.action = ExpirationAttrs.getExpirationAction(action);
            }
        }

        public ExpirationAttributes convertToExpirationAttributes() {
            ExpirationAttributes expirationAttr = null;
            expirationAttr = this.action != null ? new ExpirationAttributes(this.time, this.action) : new ExpirationAttributes(this.time);
            return expirationAttr;
        }

        public ExpirationFor getType() {
            return this.type;
        }

        public Integer getTime() {
            return this.time;
        }

        public ExpirationAction getAction() {
            return this.action;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpirationAttrs.class.getSimpleName() + " [type=");
            builder.append((Object)this.type);
            builder.append(", time=");
            builder.append(this.time);
            builder.append(", action=");
            builder.append(this.action);
            builder.append("]");
            return builder.toString();
        }

        private static ExpirationAction getExpirationAction(String action) {
            if (action == null) {
                return ExpirationAttributes.DEFAULT.getAction();
            }
            if ((action = action.replace('-', '_')).equalsIgnoreCase(ExpirationAction.DESTROY.toString())) {
                return ExpirationAction.DESTROY;
            }
            if (action.equalsIgnoreCase(ExpirationAction.INVALIDATE.toString())) {
                return ExpirationAction.INVALIDATE;
            }
            if (action.equalsIgnoreCase(ExpirationAction.LOCAL_DESTROY.toString())) {
                return ExpirationAction.LOCAL_DESTROY;
            }
            if (action.equalsIgnoreCase(ExpirationAction.LOCAL_INVALIDATE.toString())) {
                return ExpirationAction.LOCAL_INVALIDATE;
            }
            throw new IllegalArgumentException(CliStrings.format("Expiration action \"{0}\" is not valid.", new Object[]{action}));
        }

        public static enum ExpirationFor {
            REGION_IDLE,
            REGION_TTL,
            ENTRY_IDLE,
            ENTRY_TTL;

        }
    }
}

