/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class ImportDataFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        Object[] args = (Object[])context.getArguments();
        String regionName = (String)args[0];
        String importFileName = (String)args[1];
        boolean invokeCallbacks = false;
        if (args.length > 2) {
            invokeCallbacks = (Boolean)args[2];
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(regionName);
            String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
            if (region == null) {
                throw new IllegalArgumentException(CliStrings.format("Region : {0} not found", (Object)regionName));
            }
            RegionSnapshotService snapshotService = region.getSnapshotService();
            SnapshotOptions options = snapshotService.createOptions();
            options.invokeCallbacks(invokeCallbacks);
            File importFile = new File(importFileName);
            snapshotService.load(new File(importFileName), SnapshotOptions.SnapshotFormat.GEMFIRE, options);
            String successMessage = CliStrings.format("Data imported from file : {0} on host : {1} to region : {2}", importFile.getCanonicalPath(), hostName, regionName);
            context.getResultSender().lastResult(successMessage);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ImportDataFunction.class.getName();
    }
}

