/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverCreateFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewayReceiverCreateFunction.class.getName();
    public static GatewayReceiverCreateFunction INSTANCE = new GatewayReceiverCreateFunction();

    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = CacheFactory.getAnyInstance();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        GatewayReceiverFunctionArgs gatewayReceiverCreateArgs = (GatewayReceiverFunctionArgs)context.getArguments();
        try {
            GatewayReceiver createdGatewayReceiver = GatewayReceiverCreateFunction.createGatewayReceiver(cache, gatewayReceiverCreateArgs);
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (gatewayReceiverCreateArgs.getStartPort() != null) {
                attributes.put("start-port", gatewayReceiverCreateArgs.getStartPort().toString());
            }
            if (gatewayReceiverCreateArgs.getEndPort() != null) {
                attributes.put("end-port", gatewayReceiverCreateArgs.getEndPort().toString());
            }
            if (gatewayReceiverCreateArgs.getBindAddress() != null) {
                attributes.put("bind-address", gatewayReceiverCreateArgs.getBindAddress());
            }
            XmlEntity xmlEntity = XmlEntity.builder().withType("gateway-receiver").withAttributes(attributes).build();
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("GatewayReceiver created on member \"{0}\" and will listen on the port \"{1}\"", memberNameOrId, createdGatewayReceiver.getPort())));
        }
        catch (IllegalStateException e) {
            resultSender.lastResult(this.handleException(memberNameOrId, e.getMessage(), e));
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(e);
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception e) {
        if (e != null && logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (exceptionMsg != null) {
            return new CliFunctionResult(memberNameOrId, false, exceptionMsg);
        }
        return new CliFunctionResult(memberNameOrId);
    }

    private static GatewayReceiver createGatewayReceiver(Cache cache, GatewayReceiverFunctionArgs gatewayReceiverCreateArgs) {
        String[] gatewayTransportFilters;
        Boolean manualStart;
        Integer socketBufferSize;
        Integer maxTimeBetweenPings;
        String bindAddress;
        Integer endPort;
        GatewayReceiverFactory gatewayReceiverFactory = cache.createGatewayReceiverFactory();
        Integer startPort = gatewayReceiverCreateArgs.getStartPort();
        if (startPort != null) {
            gatewayReceiverFactory.setStartPort(startPort);
        }
        if ((endPort = gatewayReceiverCreateArgs.getEndPort()) != null) {
            gatewayReceiverFactory.setEndPort(endPort);
        }
        if ((bindAddress = gatewayReceiverCreateArgs.getBindAddress()) != null) {
            gatewayReceiverFactory.setBindAddress(bindAddress);
        }
        if ((maxTimeBetweenPings = gatewayReceiverCreateArgs.getMaximumTimeBetweenPings()) != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(maxTimeBetweenPings);
        }
        if ((socketBufferSize = gatewayReceiverCreateArgs.getSocketBufferSize()) != null) {
            gatewayReceiverFactory.setSocketBufferSize(socketBufferSize);
        }
        if ((manualStart = gatewayReceiverCreateArgs.isManualStart()) != null) {
            gatewayReceiverFactory.setManualStart(manualStart);
        }
        if ((gatewayTransportFilters = gatewayReceiverCreateArgs.getGatewayTransportFilters()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                Class gatewayTransportFilterKlass = GatewayReceiverCreateFunction.forName(gatewayTransportFilter, "gateway-transport-filter");
                gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)GatewayReceiverCreateFunction.newInstance(gatewayTransportFilterKlass, "gateway-transport-filter"));
            }
        }
        return gatewayReceiverFactory.create();
    }

    private static Class forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static Object newInstance(Class klass, String neededFor) {
        Object instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return ID;
    }
}

