/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class FetchRegionAttributesFunction
extends FunctionAdapter {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 4366812590788342070L;
    private static final String ID = FetchRegionAttributesFunction.class.getName();
    public static FetchRegionAttributesFunction INSTANCE = new FetchRegionAttributesFunction();

    @Override
    public boolean isHA() {
        return false;
    }

    public void execute(FunctionContext context) {
        try {
            String regionPath = (String)context.getArguments();
            if (regionPath == null) {
                throw new IllegalArgumentException("Specify a valid name");
            }
            FetchRegionAttributesFunctionResult result = FetchRegionAttributesFunction.getRegionAttributes(regionPath);
            context.getResultSender().lastResult(result);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            context.getResultSender().lastResult(e);
        }
    }

    public static <K, V> FetchRegionAttributesFunctionResult<K, V> getRegionAttributes(String regionPath) {
        Cache cache = CacheFactory.getAnyInstance();
        Region foundRegion = cache.getRegion(regionPath);
        if (foundRegion == null) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", regionPath));
        }
        AttributesFactory afactory = new AttributesFactory(foundRegion.getAttributes());
        FetchRegionAttributesFunctionResult result = new FetchRegionAttributesFunctionResult(afactory);
        return result;
    }

    @Override
    public String getId() {
        return ID;
    }

    public static class FetchRegionAttributesFunctionResult<K, V>
    implements Serializable {
        private static final long serialVersionUID = -3970828263897978845L;
        private RegionAttributes<K, V> regionAttributes;
        private String[] cacheListenerClasses;
        private String cacheLoaderClass;
        private String cacheWriterClass;

        public FetchRegionAttributesFunctionResult(AttributesFactory<K, V> afactory) {
            CacheWriter<K, V> cacheWriter;
            CacheLoader<K, V> cacheLoader;
            this.regionAttributes = afactory.create();
            CacheListener<K, V>[] cacheListeners = this.regionAttributes.getCacheListeners();
            if (cacheListeners != null && cacheListeners.length != 0) {
                this.cacheListenerClasses = new String[cacheListeners.length];
                for (int i = 0; i < cacheListeners.length; ++i) {
                    this.cacheListenerClasses[i] = cacheListeners[i].getClass().getName();
                }
                afactory.initCacheListeners(null);
            }
            if ((cacheLoader = this.regionAttributes.getCacheLoader()) != null) {
                this.cacheLoaderClass = cacheLoader.getClass().getName();
                afactory.setCacheLoader(null);
            }
            if ((cacheWriter = this.regionAttributes.getCacheWriter()) != null) {
                this.cacheWriterClass = cacheWriter.getClass().getName();
                afactory.setCacheWriter(null);
            }
            this.regionAttributes = afactory.create();
        }

        public RegionAttributes<K, V> getRegionAttributes() {
            return this.regionAttributes;
        }

        public String[] getCacheListenerClasses() {
            return this.cacheListenerClasses;
        }

        public String getCacheLoaderClass() {
            return this.cacheLoaderClass;
        }

        public String getCacheWriterClass() {
            return this.cacheWriterClass;
        }
    }
}

