/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class GatewayReceiverIdsConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return false;
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "geode.converter.gateway.receiverid".equals(optionContext)) {
            Set<String> gatewaySenderIds = this.getGatewayRecieverIds();
            for (String gatewaySenderId : gatewaySenderIds) {
                completions.add(new Completion(gatewaySenderId));
            }
        }
        return !completions.isEmpty();
    }

    public Set<String> getGatewayRecieverIds() {
        AbstractSet gatewayRecieverIds = new HashSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            String[] gatewaySenderIdArray = (String[])gfsh.getOperationInvoker().invoke("GemFire:service=System,type=Distributed", "listGatewayReceivers", new Object[0], new String[0]);
            gatewayRecieverIds = new TreeSet<String>(Arrays.asList(gatewaySenderIdArray));
        }
        return gatewayRecieverIds;
    }
}

