/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javax.management.ObjectName;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartPulseCommand
implements GfshCommand {
    @CliCommand(value={"start pulse"}, help="Open a new window in the default Web browser with the URL for the Pulse application.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startPulse(@CliOption(key={"url"}, unspecifiedDefaultValue="http://localhost:7070/pulse", help="URL of the Pulse Web application.") String url) {
        try {
            if (StringUtils.isNotBlank((String)url)) {
                this.browse(URI.create(url));
                return ResultBuilder.createInfoResult("Launched Geode Pulse");
            }
            if (this.isConnectedAndReady()) {
                ObjectName managerObjectName;
                OperationInvoker operationInvoker = this.getGfsh().getOperationInvoker();
                String pulseURL = (String)operationInvoker.getAttribute((managerObjectName = (ObjectName)operationInvoker.getAttribute("GemFire:service=System,type=Distributed", "ManagerObjectName")).toString(), "PulseURL");
                if (StringUtils.isNotBlank((String)pulseURL)) {
                    this.browse(URI.create(pulseURL));
                    return ResultBuilder.createInfoResult("Launched Geode Pulse with URL: " + pulseURL);
                }
                String pulseMessage = (String)operationInvoker.getAttribute(managerObjectName.toString(), "StatusMessage");
                return StringUtils.isNotBlank((String)pulseMessage) ? ResultBuilder.createGemFireErrorResult(pulseMessage) : ResultBuilder.createGemFireErrorResult("Could not find the URL for Geode Pulse.");
            }
            return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected for launching {0}", (Object)"GemFire Pulse"));
        }
        catch (Exception e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching Geode Pulse - %1$s", this.toString(t, false)));
        }
    }

    private void browse(URI uri) throws IOException {
        Assert.assertState(Desktop.isDesktopSupported(), String.format("Running desktop applications is not supported on %1$s.", System.getProperty("os.name")), new Object[0]);
        Desktop.getDesktop().browse(uri);
    }
}

