/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.converters.ConnectionEndpointConverter;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.cli.util.JdkTool;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartJConsoleCommand
implements GfshCommand {
    @CliCommand(value={"start jconsole"}, help="Start the JDK's JConsole tool in a separate process. JConsole will be launched, but connecting to Geode must be done manually.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startJConsole(@CliOption(key={"interval"}, unspecifiedDefaultValue="4", help="Update internal (in seconds). This parameter is passed as -interval to JConsole.") int interval, @CliOption(key={"notile"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to initially tile windows for two or more connections. This parameter is passed as -notile to JConsole.") boolean notile, @CliOption(key={"pluginpath"}, help="Directories or JAR files which are searched for JConsole plugins. The path should contain a provider-configuration file named:\n    META-INF/services/com.sun.tools.jconsole.JConsolePlugin\ncontaining one line for each plugin specifying the fully qualified class name of the class implementing the com.sun.tools.jconsole.JConsolePlugin class.") String pluginpath, @CliOption(key={"version"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display the JConsole version information. This parameter is passed as -version to JConsole.") boolean version, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Arguments passed to the JVM on which JConsole will run.") String[] jvmArgs) {
        try {
            Object[] jconsoleCommandLine = this.createJConsoleCommandLine(null, interval, notile, pluginpath, version, jvmArgs);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("JConsole command-line ($1%s)", Arrays.toString(jconsoleCommandLine)));
            }
            Process jconsoleProcess = Runtime.getRuntime().exec((String[])jconsoleCommandLine);
            StringBuilder message = new StringBuilder();
            if (version) {
                jconsoleProcess.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(jconsoleProcess.getErrorStream()));
                String line = reader.readLine();
                while (line != null) {
                    message.append(line);
                    message.append(StringUtils.LINE_SEPARATOR);
                    line = reader.readLine();
                }
                IOUtils.close(reader);
            } else {
                this.getGfsh().printAsInfo("Launched JConsole");
                String jconsoleProcessOutput = ProcessStreamReader.waitAndCaptureProcessStandardErrorStream(jconsoleProcess);
                if (StringUtils.isNotBlank((String)jconsoleProcessOutput)) {
                    message.append(StringUtils.LINE_SEPARATOR);
                    message.append(jconsoleProcessOutput);
                }
            }
            return ResultBuilder.createInfoResult(message.toString());
        }
        catch (IllegalArgumentException | IllegalStateException | GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IOException e) {
            return ResultBuilder.createShellClientErrorResult("An IO error occurred while launching JConsole.\nPlease ensure that JAVA_HOME is set to the JDK installation or the JDK bin directory is in the system PATH.");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching JConsole = %1$s", this.toString(t, false)));
        }
    }

    protected String[] createJConsoleCommandLine(String member, int interval, boolean notile, String pluginpath, boolean version, String[] jvmArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(JdkTool.getJConsolePathname());
        if (version) {
            commandLine.add("-version");
        } else {
            String jmxServiceUrl;
            commandLine.add("-interval=" + interval);
            if (notile) {
                commandLine.add("-notile");
            }
            if (StringUtils.isNotBlank((String)pluginpath)) {
                commandLine.add("-pluginpath " + pluginpath);
            }
            if (jvmArgs != null) {
                for (String arg : jvmArgs) {
                    commandLine.add("-J" + arg);
                }
            }
            if (StringUtils.isNotBlank((String)(jmxServiceUrl = this.getJmxServiceUrlAsString(member)))) {
                commandLine.add(jmxServiceUrl);
            }
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    protected String getJmxServiceUrlAsString(String member) {
        if (StringUtils.isNotBlank((String)member)) {
            ConnectionEndpointConverter converter = new ConnectionEndpointConverter();
            try {
                Object connectionEndpoint = converter.convertFromText(member, (Class)ConnectionEndpoint.class, (String)null);
                String hostAndPort = ((ConnectionEndpoint)connectionEndpoint).getHost() + ":" + ((ConnectionEndpoint)connectionEndpoint).getPort();
                return String.format("service:jmx:rmi://%s/jndi/rmi://%s/jmxrmi", hostAndPort, hostAndPort);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Connecting by the Geode member's name or ID is not currently supported.\nPlease specify the member as '<hostname|IP>[PORT].");
            }
        }
        if (this.isConnectedAndReady() && this.getGfsh().getOperationInvoker() instanceof JmxOperationInvoker) {
            JmxOperationInvoker jmxOperationInvoker = (JmxOperationInvoker)this.getGfsh().getOperationInvoker();
            return ObjectUtils.toString(jmxOperationInvoker.getJmxServiceUrl());
        }
        return null;
    }
}

