/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.DataCommands;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class QueryCommand
implements GfshCommand {
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"query"}, help="Run the specified OQL query as a single quoted string and display the results in one or more pages. Limit will default to the value stored in the \"APP_FETCH_SIZE\" variable. Page size will default to the value stored in the \"APP_COLLECTION_LIMIT\" variable.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.QueryInterceptor")
    public Result query(@CliOption(key={"query"}, help="The OQL string.", mandatory=true) String query, @CliOption(key={"file"}, help="File in which to output the results.", optionContext="geode.converter.file") File outputFile, @CliOption(key={"interactive"}, unspecifiedDefaultValue="false", help="Whether or not this query is interactive. If false then all results will be displayed at once.") boolean interactive) {
        DataCommandResult dataResult = this.select(query);
        CompositeResultData rd = dataResult.toSelectCommandResult();
        return ResultBuilder.buildResult(rd);
    }

    private DataCommandResult select(String query) {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (StringUtils.isEmpty((String)query)) {
            DataCommandResult dataResult = DataCommandResult.createSelectInfoResult(null, null, -1, null, "Query is either empty or Null", false);
            return dataResult;
        }
        Object[] array = DataCommands.replaceGfshEnvVar(query, CommandExecutionContext.getShellEnv());
        query = (String)array[1];
        boolean limitAdded = false;
        if (!StringUtils.containsIgnoreCase((String)query, (String)" limit") && !StringUtils.containsIgnoreCase((String)query, (String)" count(")) {
            query = query + " limit " + CommandExecutionContext.getShellFetchSize();
            limitAdded = true;
        }
        QCompiler compiler = new QCompiler();
        try {
            CompiledValue compiledQuery = compiler.compileQuery(query);
            HashSet regions = new HashSet();
            compiledQuery.getRegionsInQuery(regions, null);
            for (String region : regions) {
                SecurityService.getSecurityService().authorizeRegionRead(region);
            }
            Set<String> regionsInQuery = Collections.unmodifiableSet(regions);
            if (regionsInQuery.size() > 0) {
                Set<DistributedMember> members = DataCommands.getQueryRegionsAssociatedMembers(regionsInQuery, cache, false);
                if (members != null && members.size() > 0) {
                    DataCommandFunction function = new DataCommandFunction();
                    DataCommandRequest request = new DataCommandRequest();
                    request.setCommand("query");
                    request.setQuery(query);
                    Subject subject = SecurityService.getSecurityService().getSubject();
                    if (subject != null) {
                        request.setPrincipal(subject.getPrincipal());
                    }
                    DataCommandResult dataResult = DataCommands.callFunctionForRegion(request, function, members);
                    dataResult.setInputQuery(query);
                    if (limitAdded) {
                        dataResult.setLimit(CommandExecutionContext.getShellFetchSize());
                    }
                    return dataResult;
                }
                return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Cannot find regions <{0}> in any of the members", (Object)regionsInQuery.toString()), false);
            }
            return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)"Region mentioned in query probably missing /"), false);
        }
        catch (QueryInvalidException qe) {
            logger.error("{} Failed Error {}", (Object)query, (Object)qe.getMessage(), (Object)qe);
            return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)qe.getMessage()), false);
        }
    }
}

