/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.deadlock.DeadlockDetector;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyGraph;
import org.apache.geode.distributed.internal.deadlock.GemFireDeadlockDetector;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.JVMMetrics;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.StackTracesPerMember;
import org.apache.geode.management.internal.cli.functions.ChangeLogLevelFunction;
import org.apache.geode.management.internal.cli.functions.GarbageCollectionFunction;
import org.apache.geode.management.internal.cli.functions.GetStackTracesFunction;
import org.apache.geode.management.internal.cli.functions.NetstatFunction;
import org.apache.geode.management.internal.cli.functions.ShutDownFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class MiscellaneousCommands
implements GfshCommand {
    public static final String NETSTAT_FILE_REQUIRED_EXTENSION = ".txt";
    public static final String DEFAULT_TIME_OUT = "10";
    private static final Logger logger = LogService.getLogger();
    private final GetStackTracesFunction getStackTracesFunction = new GetStackTracesFunction();

    public void shutdownNode(long timeout, final Set<DistributedMember> includeMembers) throws TimeoutException, InterruptedException, ExecutionException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            final ShutDownFunction shutDownFunction = new ShutDownFunction();
            logger.info("Gfsh executing shutdown on members " + includeMembers);
            Callable<String> shutdownNodes = new Callable<String>(){

                @Override
                public String call() {
                    try {
                        Execution execution = FunctionService.onMembers(includeMembers);
                        execution.execute(shutDownFunction);
                    }
                    catch (FunctionException functionException) {
                        // empty catch block
                    }
                    return "SUCCESS";
                }
            };
            Future<String> result = exec.submit(shutdownNodes);
            result.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            logger.error("TimeoutException in shutting down members." + includeMembers);
            throw te;
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException in shutting down members." + includeMembers);
            throw e;
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException in shutting down members." + includeMembers);
            throw e;
        }
        finally {
            exec.shutdownNow();
        }
    }

    @CliCommand(value={"shutdown"}, help="Stop all members.")
    @CliMetaData(relatedTopic={"Lifecycle"}, interceptor="org.apache.geode.management.internal.cli.commands.MiscellaneousCommands$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result shutdown(@CliOption(key={"time-out"}, unspecifiedDefaultValue="10", help="Time to wait (in seconds) for a graceful shutdown. Should be at least 10 sec") int userSpecifiedTimeout, @CliOption(key={"include-locators"}, unspecifiedDefaultValue="false", help="To shutdown locators specify this option as true. Default is false") boolean shutdownLocators) {
        try {
            if (userSpecifiedTimeout < Integer.parseInt(DEFAULT_TIME_OUT)) {
                return ResultBuilder.createInfoResult("time-out should not be less than 10 sec.");
            }
            long timeout = userSpecifiedTimeout * 1000;
            InternalCache cache = this.getCache();
            int numDataNodes = CliUtil.getAllNormalMembers(cache).size();
            Set<DistributedMember> locators = CliUtil.getAllMembers(cache);
            Set<DistributedMember> dataNodes = CliUtil.getAllNormalMembers(cache);
            locators.removeAll(dataNodes);
            if (!shutdownLocators && numDataNodes == 0) {
                return ResultBuilder.createInfoResult("No data node found for stopping. Please specify --shutdown-locators option if you want locators to be stopped");
            }
            String managerName = cache.getJmxManagerAdvisor().getDistributionManager().getId().getId();
            DistributedMember manager = CliUtil.getDistributedMemberByNameOrId(managerName);
            dataNodes.remove(manager);
            long timeElapsed = this.shutDownNodeWithTimeOut(timeout, dataNodes);
            timeout -= timeElapsed;
            if (shutdownLocators) {
                if (manager == null) {
                    return ResultBuilder.createUserErrorResult("Could not locate Manager.");
                }
                if (locators.contains(manager)) {
                    locators.remove(manager);
                }
                for (DistributedMember locator : locators) {
                    HashSet<DistributedMember> lsSet = new HashSet<DistributedMember>();
                    lsSet.add(locator);
                    long elapsedTime = this.shutDownNodeWithTimeOut(timeout, lsSet);
                    timeout -= elapsedTime;
                }
            }
            if (locators.contains(manager) && !shutdownLocators) {
                return ResultBuilder.createInfoResult("Shutdown is triggered");
            }
            HashSet<DistributedMember> mgrSet = new HashSet<DistributedMember>();
            mgrSet.add(manager);
            this.shutDownNodeWithTimeOut(timeout, mgrSet);
        }
        catch (TimeoutException tex) {
            return ResultBuilder.createInfoResult("Shutdown command timedout. Please manually check node status");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ResultBuilder.createUserErrorResult(ex.getMessage());
        }
        return ResultBuilder.createInfoResult("Shutdown is triggered");
    }

    private long shutDownNodeWithTimeOut(long timeout, Set<DistributedMember> nodesToBeStopped) throws TimeoutException, InterruptedException, ExecutionException {
        long shutDownTimeStart = System.currentTimeMillis();
        this.shutdownNode(timeout, nodesToBeStopped);
        long shutDownTimeEnd = System.currentTimeMillis();
        long timeElapsed = shutDownTimeEnd - shutDownTimeStart;
        if (timeElapsed > timeout || Boolean.getBoolean("ThrowTimeoutException")) {
            throw new TimeoutException();
        }
        return timeElapsed;
    }

    @CliCommand(value={"gc"}, help="Force GC (Garbage Collection) on a member or members. The default is for garbage collection to occur on all caching members.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result gc(@CliOption(key={"group"}, unspecifiedDefaultValue="__NULL__", help="Group(s) of members on which garbage collection will be done.") String[] groups, @CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Name/Id of the member on which garbage collection will be done.") String memberId) {
        InternalCache cache = this.getCache();
        Result result = null;
        CompositeResultData gcResultTable = ResultBuilder.createCompositeResultData();
        TabularResultData resultTable = gcResultTable.addSection().addTable("Table1");
        String headerText = "GC Summary";
        resultTable.setHeader(headerText);
        HashSet<DistributedMember> dsMembers = new HashSet();
        if (memberId != null && memberId.length() > 0) {
            DistributedMember member = CliUtil.getDistributedMemberByNameOrId(memberId);
            if (member == null) {
                return ResultBuilder.createGemFireErrorResult(memberId + "Member not found");
            }
            dsMembers.add(member);
            result = this.executeAndBuildResult(resultTable, dsMembers);
        } else if (groups != null && groups.length > 0) {
            for (String group : groups) {
                dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
            result = this.executeAndBuildResult(resultTable, dsMembers);
        } else {
            dsMembers = CliUtil.getAllNormalMembers(cache);
            result = this.executeAndBuildResult(resultTable, dsMembers);
        }
        return result;
    }

    Result executeAndBuildResult(TabularResultData resultTable, Set<DistributedMember> dsMembers) {
        try {
            List resultList = null;
            GarbageCollectionFunction garbageCollectionFunction = new GarbageCollectionFunction();
            resultList = (List)CliUtil.executeFunction((Function)garbageCollectionFunction, null, dsMembers).getResult();
            for (int i = 0; i < resultList.size(); ++i) {
                Object object = resultList.get(i);
                if (object instanceof Exception) {
                    LogWrapper.getInstance().fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                    continue;
                }
                if (object instanceof Throwable) {
                    LogWrapper.getInstance().fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                    continue;
                }
                if (object != null) {
                    if (object instanceof String) {
                        return ResultBuilder.createUserErrorResult((String)object);
                    }
                    Map resultMap = (Map)object;
                    this.toTabularResultData(resultTable, (String)resultMap.get("MemberId"), (String)resultMap.get("HeapSizeBeforeGC"), (String)resultMap.get("HeapSizeAfterGC"), (String)resultMap.get("TimeSpentInGC"));
                    continue;
                }
                LogWrapper.getInstance().fine("ResultMap was null ");
            }
        }
        catch (Exception e) {
            String stack = CliUtil.stackTraceAsString(e);
            LogWrapper.getInstance().info("GC exception is " + stack);
            return ResultBuilder.createGemFireErrorResult(e.getMessage() + ": " + stack);
        }
        return ResultBuilder.buildResult(resultTable);
    }

    protected void toTabularResultData(TabularResultData table, String memberId, String heapSizeBefore, String heapSizeAfter, String timeTaken) {
        table.accumulate("Member ID/Name", memberId);
        table.accumulate("HeapSize (MB) Before GC", heapSizeBefore);
        table.accumulate("HeapSize(MB) After GC", heapSizeAfter);
        table.accumulate("Time Taken for GC in ms", timeTaken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"netstat"}, help="Report network information and statistics via the \"netstat\" operating system command.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result netstat(@CliOption(key={"member"}, mandatory=false, unspecifiedDefaultValue="__NULL__", optionContext="geode.converter.all.member.idOrName", help="Name/Id of the member(s) on which to run the netstat command.") String[] members, @CliOption(key={"group"}, mandatory=false, unspecifiedDefaultValue="__NULL__", optionContext="geode.converter.member.groups", help="Group of members on which to run the netstat command.") String group, @CliOption(key={"file"}, unspecifiedDefaultValue="__NULL__", help="Text file to which output from the netstat command will be written. A \".txt\" extention will be added if it's not already a part of the specified name.") String saveAs, @CliOption(key={"with-lsof"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether lsof (list open files) command output should also be displayed. Not applicable for \"Microsoft Windows(TM)\" hosts.") boolean withlsof) {
        Result result = null;
        HashMap<String, DistributedMember> hostMemberMap = new HashMap<String, DistributedMember>();
        HashMap<String, List<String>> hostMemberListMap = new HashMap<String, List<String>>();
        try {
            if (members != null && members.length > 0 && group != null) {
                throw new IllegalArgumentException("Only one of --group or --member should be specified.");
            }
            StringBuilder resultInfo = new StringBuilder();
            InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
            if (members != null) {
                HashSet<Object> notFoundMembers = new HashSet<Object>();
                for (String memberIdOrName : members) {
                    Set<DistributedMember> membersToExecuteOn = CliUtil.getAllMembers(system);
                    boolean memberFound = false;
                    for (DistributedMember distributedMember : membersToExecuteOn) {
                        String memberName = distributedMember.getName();
                        String memberId = distributedMember.getId();
                        if (!memberName.equals(memberIdOrName) && !memberId.equals(memberIdOrName)) continue;
                        this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                        memberFound = true;
                        break;
                    }
                    if (memberFound) continue;
                    notFoundMembers.add(memberIdOrName);
                }
                if (!notFoundMembers.isEmpty()) {
                    throw new IllegalArgumentException(CliStrings.format("Could not find member(s) with Id(s) or name(s): {0}.", new Object[]{CliUtil.collectionToString(notFoundMembers, -1)}));
                }
            } else {
                Set<DistributedMember> membersToExecuteOn = null;
                membersToExecuteOn = group != null ? system.getGroupMembers(group) : CliUtil.getAllMembers(system);
                for (DistributedMember distributedMember : membersToExecuteOn) {
                    String memberName = distributedMember.getName();
                    String memberId = distributedMember.getId();
                    String memberIdOrName = memberName != null && !memberName.isEmpty() ? memberName : memberId;
                    this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                }
            }
            String lineSeparatorToUse = null;
            lineSeparatorToUse = CommandExecutionContext.getShellLineSeparator();
            if (lineSeparatorToUse == null) {
                lineSeparatorToUse = GfshParser.LINE_SEPARATOR;
            }
            NetstatFunction.NetstatFunctionArgument nfa = new NetstatFunction.NetstatFunctionArgument(lineSeparatorToUse, withlsof);
            if (!hostMemberMap.isEmpty()) {
                HashSet<DistributedMember> membersToExecuteOn = new HashSet<DistributedMember>(hostMemberMap.values());
                ResultCollector<?, ?> netstatResult = CliUtil.executeFunction((Function)NetstatFunction.INSTANCE, (Object)nfa, membersToExecuteOn);
                List resultList = (List)netstatResult.getResult();
                for (int i = 0; i < resultList.size(); ++i) {
                    NetstatFunction.NetstatFunctionResult netstatFunctionResult = (NetstatFunction.NetstatFunctionResult)resultList.get(i);
                    CliUtil.DeflaterInflaterData deflaterInflaterData = netstatFunctionResult.getCompressedBytes();
                    try {
                        String remoteHost = netstatFunctionResult.getHost();
                        List membersList = (List)hostMemberListMap.get(remoteHost);
                        resultInfo.append(MessageFormat.format(netstatFunctionResult.getHeaderInfo(), CliUtil.collectionToString(membersList, 120)));
                        CliUtil.DeflaterInflaterData uncompressedBytes = CliUtil.uncompressBytes(deflaterInflaterData.getData(), deflaterInflaterData.getDataLength());
                        resultInfo.append(new String(uncompressedBytes.getData()));
                        continue;
                    }
                    catch (DataFormatException e) {
                        resultInfo.append("Error in some data. Reason : " + e.getMessage());
                    }
                }
            }
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            if (saveAs != null && !saveAs.isEmpty()) {
                String saveToFile = saveAs;
                if (!saveAs.endsWith(NETSTAT_FILE_REQUIRED_EXTENSION)) {
                    saveToFile = saveAs + NETSTAT_FILE_REQUIRED_EXTENSION;
                }
                resultData.addAsFile(saveToFile, resultInfo.toString(), "Saved netstat output in the file {0}.", false);
            } else {
                resultData.addLine(resultInfo.toString());
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}));
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}), e);
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}));
        }
        finally {
            hostMemberMap.clear();
            hostMemberListMap.clear();
        }
        return result;
    }

    private void buildMaps(Map<String, DistributedMember> hostMemberMap, Map<String, List<String>> hostMemberListMap, String memberIdOrName, DistributedMember distributedMember) {
        String host = distributedMember.getHost();
        if (!hostMemberMap.containsKey(host)) {
            hostMemberMap.put(host, distributedMember);
        }
        List<Object> list = null;
        if (!hostMemberListMap.containsKey(host)) {
            list = new ArrayList();
            hostMemberListMap.put(host, list);
        } else {
            list = hostMemberListMap.get(host);
        }
        list.add(memberIdOrName);
    }

    @CliCommand(value={"show dead-locks"}, help="Display any deadlocks in the Geode distributed system.")
    @CliMetaData(shellOnly=false, relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showDeadlock(@CliOption(key={"file"}, help="Name of the file to which dependencies between members will be written.", mandatory=true) String filename) {
        Result result = null;
        try {
            if (!filename.endsWith(NETSTAT_FILE_REQUIRED_EXTENSION)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)NETSTAT_FILE_REQUIRED_EXTENSION));
            }
            InternalCache cache = this.getCache();
            Set<DistributedMember> allMembers = CliUtil.getAllMembers(cache);
            GemFireDeadlockDetector gfeDeadLockDetector = new GemFireDeadlockDetector(allMembers);
            DependencyGraph dependencyGraph = gfeDeadLockDetector.find();
            Collection<Dependency> deadlock = dependencyGraph.findCycle();
            DependencyGraph deepest = null;
            if (deadlock == null && (deepest = dependencyGraph.findLongestCallChain()) != null) {
                deadlock = deepest.getEdges();
            }
            Set dependencies = (Set)dependencyGraph.getEdges();
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            if (deadlock != null) {
                if (deepest != null) {
                    resultData.addLine("No deadlock was detected.  Here is the deepest call chain that could be found");
                } else {
                    resultData.addLine("Deadlock detected.");
                }
                resultData.addLine(DeadlockDetector.prettyFormat(deadlock));
            } else {
                resultData.addLine("No deadlock was detected.");
            }
            resultData.addAsFile(filename, DeadlockDetector.prettyFormat(dependencies), MessageFormat.format("Please view the dependencies between the members in file : {0}", filename), false);
            result = ResultBuilder.buildResult(resultData);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Error : " + e.getMessage());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CliCommand(value={"show log"}, help="Display the log for a member.")
    @CliMetaData(shellOnly=false, relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showLog(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Name/Id of the member whose log file will be displayed.", mandatory=true) String memberNameOrId, @CliOption(key={"lines"}, unspecifiedDefaultValue="0", help="Number of lines from the log file to display. The maximum is 100.", mandatory=false) int numberOfLines) {
        Result result = null;
        try {
            InternalCache cache = this.getCache();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            MemberMXBean bean = null;
            DistributedMember memberToBeInvoked = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            if (memberToBeInvoked != null) {
                String memberId = memberToBeInvoked.getId();
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(memberId)) {
                    bean = service.getMemberMXBean();
                } else {
                    ObjectName objectName = service.getMemberMBeanName(memberToBeInvoked);
                    bean = service.getMBeanProxy(objectName, MemberMXBean.class);
                }
                if (numberOfLines > 100) {
                    numberOfLines = 100;
                }
                if (numberOfLines == 0 || numberOfLines < 0) {
                    numberOfLines = 30;
                }
                InfoResultData resultData = ResultBuilder.createInfoResultData();
                if (bean != null) {
                    String log = bean.showLog(numberOfLines);
                    if (log != null) {
                        resultData.addLine(log);
                        return ResultBuilder.buildResult(resultData);
                    } else {
                        resultData.addLine("There is no log for this member");
                    }
                    return ResultBuilder.buildResult(resultData);
                } else {
                    ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(memberNameOrId + "Member not found");
                    return ResultBuilder.buildResult(errorResultData);
                }
            }
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(memberNameOrId + "Member not found");
            return ResultBuilder.buildResult(errorResultData);
        }
        catch (Exception e) {
            return ResultBuilder.createGemFireErrorResult("Error" + CliUtil.stackTraceAsString(e));
        }
    }

    @CliCommand(value={"export stack-traces"}, help="Export the stack trace for a member or members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportStackTrace(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", help="Export the stack trace for a member or members.") String[] memberNameOrId, @CliOption(key={"group"}, optionContext="geode.converter.all.member.idOrName", help="group") String[] group, @CliOption(key={"file"}, help="Name of the file to which the stack traces will be written.") String fileName, @CliOption(key={"abort-if-file-exists"}, unspecifiedDefaultValue="false", help="Abort the command if already exists at locator directory") boolean failIfFilePresent) {
        Result result = null;
        StringBuffer filePrefix = new StringBuffer("stacktrace");
        if (fileName == null) {
            fileName = filePrefix.append("_").append(System.currentTimeMillis()).toString();
        }
        File outFile = new File(fileName);
        try {
            if (outFile.exists() && failIfFilePresent) {
                return ResultBuilder.createShellClientErrorResult(CliStrings.format("Error occurred while exporting stack-traces, file {0} already present", (Object)outFile.getCanonicalPath()));
            }
            InternalCache cache = this.getCache();
            InternalDistributedSystem ads = cache.getInternalDistributedSystem();
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            HashMap<String, byte[]> dumps = new HashMap<String, byte[]>();
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.getStackTracesFunction, null, targetMembers);
            ArrayList resultList = (ArrayList)rc.getResult();
            for (Object resultObj : resultList) {
                if (!(resultObj instanceof StackTracesPerMember)) continue;
                StackTracesPerMember stackTracePerMember = (StackTracesPerMember)resultObj;
                dumps.put(stackTracePerMember.getMemberNameOrId(), stackTracePerMember.getStackTraces());
            }
            String filePath = this.writeStacksToFile(dumps, fileName);
            resultData.addLine(CliStrings.format("stack-trace(s) exported to file: {0}", (Object)filePath));
            resultData.addLine("On host : " + ads.getDistributedMember().getHost());
            result = ResultBuilder.buildResult(resultData);
        }
        catch (IOException ex) {
            result = ResultBuilder.createGemFireErrorResult("Error occurred while showing stack-traces" + ex.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeStacksToFile(Map<String, byte[]> dumps, String fileName) throws IOException {
        String filePath = null;
        OutputStream os = null;
        PrintWriter ps = null;
        File outputFile = null;
        try {
            outputFile = new File(fileName);
            os = new FileOutputStream(outputFile);
            ps = new PrintWriter(os);
            for (Map.Entry<String, byte[]> entry : dumps.entrySet()) {
                int count;
                ps.append("*** Stack-trace for member " + entry.getKey() + " ***");
                ps.flush();
                GZIPInputStream zipIn = new GZIPInputStream(new ByteArrayInputStream(entry.getValue()));
                BufferedInputStream bin = new BufferedInputStream(zipIn);
                byte[] buffer = new byte[10000];
                while ((count = bin.read(buffer)) != -1) {
                    os.write(buffer, 0, count);
                }
                ps.append('\n');
            }
            ps.flush();
            filePath = outputFile.getCanonicalPath();
        }
        finally {
            os.close();
        }
        return filePath;
    }

    @CliCommand(value={"show metrics"}, help="Display or export metrics for the entire distributed system, a member or a region.")
    @CliMetaData(shellOnly=false, relatedTopic={"Statistics"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showMetrics(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", help="Name/Id of the member whose metrics will be displayed/exported.") String memberNameOrId, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose metrics will be displayed/exported.") String regionName, @CliOption(key={"file"}, help="Name of the file to which metrics will be written.") String export_to_report_to, @CliOption(key={"port"}, help="Port number of the Cache Server whose metrics are to be displayed/exported. This can only be used along with the --member parameter.") String cacheServerPortString, @CliOption(key={"categories"}, help="Categories available based upon the parameters specified are:\n- no parameters specified: cluster, cache, diskstore, query\n- region specified: cluster, region, partition, diskstore, callback, eviction\n- member specified: member, jvm, region, serialization, communication, function, transaction, diskstore, lock, eviction, distribution, offheap\n- member and region specified: region, partition, diskstore, callback, eviction") String[] categories) {
        Result result;
        block16: {
            result = null;
            try {
                if (export_to_report_to != null && !export_to_report_to.isEmpty() && !export_to_report_to.endsWith(".csv")) {
                    return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".csv"));
                }
                if (regionName != null && !regionName.isEmpty()) {
                    if (!org.apache.geode.internal.lang.StringUtils.isBlank((String)cacheServerPortString)) {
                        return ResultBuilder.createUserErrorResult("If the --port parameter is specified, then the --member parameter must also be specified.");
                    }
                    if (!regionName.startsWith("/")) {
                        regionName = "/" + regionName;
                    }
                    if (memberNameOrId == null || memberNameOrId.isEmpty()) {
                        result = ResultBuilder.buildResult(this.getDistributedRegionMetrics(regionName, export_to_report_to, categories));
                    } else {
                        DistributedMember member = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
                        if (member != null) {
                            result = ResultBuilder.buildResult(this.getRegionMetricsFromMember(regionName, member, export_to_report_to, categories));
                        } else {
                            ErrorResultData erd = ResultBuilder.createErrorResultData();
                            erd.addLine(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberNameOrId));
                            result = ResultBuilder.buildResult(erd);
                        }
                    }
                    break block16;
                }
                if (memberNameOrId != null && !memberNameOrId.isEmpty()) {
                    DistributedMember member = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
                    if (member != null) {
                        int cacheServerPort = -1;
                        if (cacheServerPortString != null && !cacheServerPortString.isEmpty()) {
                            try {
                                cacheServerPort = Integer.parseInt(cacheServerPortString);
                            }
                            catch (NumberFormatException nfe) {
                                return ResultBuilder.createUserErrorResult("Invalid port");
                            }
                        }
                        result = ResultBuilder.buildResult(this.getMemberMetrics(member, export_to_report_to, categories, cacheServerPort));
                        break block16;
                    }
                    ErrorResultData erd = ResultBuilder.createErrorResultData();
                    erd.addLine(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberNameOrId));
                    result = ResultBuilder.buildResult(erd);
                    break block16;
                }
                if (!org.apache.geode.internal.lang.StringUtils.isBlank((String)cacheServerPortString)) {
                    return ResultBuilder.createUserErrorResult("If the --port parameter is specified, then the --member parameter must also be specified.");
                }
                result = ResultBuilder.buildResult(this.getSystemWideMetrics(export_to_report_to, categories));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return ResultBuilder.createGemFireErrorResult(CliUtil.stackTraceAsString(e));
            }
        }
        return result;
    }

    private ResultData getSystemWideMetrics(String export_to_report_to, String[] categoriesArr) throws Exception {
        InternalCache cache = this.getCache();
        ManagementService managmentService = ManagementService.getManagementService(cache);
        DistributedSystemMXBean dsMxBean = managmentService.getDistributedSystemMXBean();
        StringBuilder csvBuilder = null;
        if (dsMxBean != null) {
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            Map<String, Boolean> categoriesMap = this.getSystemMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            metricsTable.setHeader("Cluster-wide Metrics");
            if (categoriesMap.get("cluster").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cluster", "totalHeapSize", dsMxBean.getTotalHeapSize(), csvBuilder);
            }
            if (categoriesMap.get("cache").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cache", "totalRegionEntryCount", dsMxBean.getTotalRegionEntryCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalRegionCount", dsMxBean.getTotalRegionCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalMissCount", dsMxBean.getTotalMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalHitCount", dsMxBean.getTotalHitCount(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", dsMxBean.getTotalDiskUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", dsMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", dsMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", dsMxBean.getDiskFlushAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", dsMxBean.getTotalBackupInProgress(), csvBuilder);
            }
            if (categoriesMap.get("query").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", dsMxBean.getActiveCQCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "queryRequestRate", dsMxBean.getQueryRequestRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder.toString(), "Cluster wide metrics exported to {0}.", false);
            }
            return crd;
        }
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)"Distributed System MBean not found");
        return ResultBuilder.createErrorResultData().addLine(errorMessage);
    }

    private ResultData getMemberMetrics(DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr, int cacheServerPort) throws ResultDataException {
        InternalCache cache = this.getCache();
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        ObjectName memberMBeanName = managementService.getMemberMBeanName(distributedMember);
        MemberMXBean memberMxBean = managementService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
        ObjectName csMxBeanName = null;
        CacheServerMXBean csMxBean = null;
        if (memberMxBean != null) {
            if (cacheServerPort != -1 && (csMxBean = managementService.getMBeanInstance(csMxBeanName = managementService.getCacheServerMBeanName(cacheServerPort, distributedMember), CacheServerMXBean.class)) == null) {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                erd.addLine(CliStrings.format("Metrics for the Cache Server with port : {0} and member : {1} not found.\n Please check the port number and the member name/id", cacheServerPort, MBeanJMXAdapter.getMemberNameOrId(distributedMember)));
                return erd;
            }
            JVMMetrics jvmMetrics = memberMxBean.showJVMMetrics();
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Member Metrics");
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getMemberMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("member").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "member", "upTime", memberMxBean.getMemberUpTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cpuUsage", memberMxBean.getCpuUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "currentHeapSize", memberMxBean.getCurrentHeapSize(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "maximumHeapSize", memberMxBean.getMaximumHeapSize(), csvBuilder);
            }
            if (categoriesMap.get("jvm").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "jvm ", "jvmThreads ", jvmMetrics.getTotalThreads(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "fileDescriptorLimit", memberMxBean.getFileDescriptorLimit(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalFileDescriptorOpen", memberMxBean.getTotalFileDescriptorOpen(), csvBuilder);
            }
            if (categoriesMap.get("region").booleanValue()) {
                String[] rootRegionNames;
                this.writeToTableAndCsv(metricsTable, "region ", "totalRegionCount ", memberMxBean.getTotalRegionCount(), csvBuilder);
                String[] regionNames = memberMxBean.listRegions();
                if (regionNames != null) {
                    for (int i = 0; i < regionNames.length; ++i) {
                        if (i == 0) {
                            this.writeToTableAndCsv(metricsTable, "", "listOfRegions", regionNames[i].substring(1), csvBuilder);
                            continue;
                        }
                        this.writeToTableAndCsv(metricsTable, "", "", regionNames[i].substring(1), csvBuilder);
                    }
                }
                if ((rootRegionNames = memberMxBean.getRootRegionNames()) != null) {
                    for (int i = 0; i < rootRegionNames.length; ++i) {
                        if (i == 0) {
                            this.writeToTableAndCsv(metricsTable, "", "rootRegions", rootRegionNames[i], csvBuilder);
                            continue;
                        }
                        this.writeToTableAndCsv(metricsTable, "", "", rootRegionNames[i], csvBuilder);
                    }
                }
                this.writeToTableAndCsv(metricsTable, "", "totalRegionEntryCount", memberMxBean.getTotalRegionEntryCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketCount", memberMxBean.getTotalBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalPrimaryBucketCount", memberMxBean.getTotalPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsAvgLatency", memberMxBean.getGetsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsAvgLatency", memberMxBean.getPutsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", memberMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", memberMxBean.getDestroysRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllAvgLatency", memberMxBean.getPutAllAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalMissCount", memberMxBean.getTotalMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalHitCount", memberMxBean.getTotalHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", memberMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", memberMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheWriterCallsAvgLatency", memberMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", memberMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalLoadsCompleted", memberMxBean.getTotalLoadsCompleted(), csvBuilder);
            }
            if (categoriesMap.get("serialization").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "serialization", "serializationRate", memberMxBean.getSerializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "serializationLatency", memberMxBean.getSerializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationRate", memberMxBean.getDeserializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationLatency", memberMxBean.getDeserializationLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationAvgLatency", memberMxBean.getDeserializationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationAvgLatency", memberMxBean.getPDXDeserializationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationRate", memberMxBean.getPDXDeserializationRate(), csvBuilder);
            }
            if (categoriesMap.get("communication").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "communication", "bytesSentRate", memberMxBean.getBytesSentRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bytesReceivedRate", memberMxBean.getBytesReceivedRate(), csvBuilder);
                String[] connectedGatewayReceivers = memberMxBean.listConnectedGatewayReceivers();
                this.writeToTableAndCsv(metricsTable, "", "connectedGatewayReceivers", connectedGatewayReceivers, csvBuilder);
                String[] connectedGatewaySenders = memberMxBean.listConnectedGatewaySenders();
                this.writeToTableAndCsv(metricsTable, "", "connectedGatewaySenders", connectedGatewaySenders, csvBuilder);
            }
            if (categoriesMap.get("function").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "function", "numRunningFunctions", memberMxBean.getNumRunningFunctions(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "functionExecutionRate", memberMxBean.getFunctionExecutionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numRunningFunctionsHavingResults", memberMxBean.getNumRunningFunctionsHavingResults(), csvBuilder);
            }
            if (categoriesMap.get("transaction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "transaction", "totalTransactionsCount", memberMxBean.getTotalTransactionsCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommitsAvgLatency", memberMxBean.getTransactionCommitsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommittedTotalCount", memberMxBean.getTransactionCommittedTotalCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionRolledBackTotalCount", memberMxBean.getTransactionRolledBackTotalCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommitsRate", memberMxBean.getTransactionCommitsRate(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", memberMxBean.getTotalDiskUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", memberMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", memberMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", memberMxBean.getDiskFlushAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalQueueSize", memberMxBean.getTotalDiskTasksWaiting(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", memberMxBean.getTotalBackupInProgress(), csvBuilder);
            }
            if (categoriesMap.get("lock").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "lock", "lockWaitsInProgress", memberMxBean.getLockWaitsInProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalLockWaitTime", memberMxBean.getTotalLockWaitTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalNumberOfLockService", memberMxBean.getTotalNumberOfLockService(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "requestQueues", memberMxBean.getLockRequestQueues(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", memberMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", memberMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (categoriesMap.get("distribution").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "distribution", "getInitialImagesInProgress", memberMxBean.getInitialImagesInProgres(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getInitialImageTime", memberMxBean.getInitialImageTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getInitialImageKeysReceived", memberMxBean.getInitialImageKeysReceived(), csvBuilder);
            }
            if (categoriesMap.get("offheap").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "offheap", "maxMemory", memberMxBean.getOffHeapMaxMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "freeMemory", memberMxBean.getOffHeapFreeMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "usedMemory", memberMxBean.getOffHeapUsedMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "objects", memberMxBean.getOffHeapObjects(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "fragmentation", memberMxBean.getOffHeapFragmentation(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "compactionTime", memberMxBean.getOffHeapCompactionTime(), csvBuilder);
            }
            if (csMxBean != null) {
                this.writeToTableAndCsv(metricsTable, "cache-server", "clientConnectionCount", csMxBean.getClientConnectionCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hostnameForClients", csMxBean.getHostNameForClients(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getRequestAvgLatency", csMxBean.getGetRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRequestAvgLatency", csMxBean.getPutRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalConnectionsTimedOut", csMxBean.getTotalConnectionsTimedOut(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "threadQueueSize", csMxBean.getPutRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "connectionThreads", csMxBean.getConnectionThreads(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "connectionLoad", csMxBean.getConnectionLoad(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "loadPerConnection", csMxBean.getLoadPerConnection(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "queueLoad", csMxBean.getQueueLoad(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "loadPerQueue", csMxBean.getLoadPerQueue(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getRequestRate", csMxBean.getGetRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRequestRate", csMxBean.getPutRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "notification", "numClientNotificationRequests", csMxBean.getNumClientNotificationRequests(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "clientNotificationRate", csMxBean.getClientNotificationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "clientNotificationAvgLatency", csMxBean.getClientNotificationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", csMxBean.getActiveCQCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "query", "queryRequestRate", csMxBean.getQueryRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "indexCount", csMxBean.getIndexCount(), csvBuilder);
                String[] indexList = csMxBean.getIndexList();
                this.writeToTableAndCsv(metricsTable, "", "index list", indexList, csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalIndexMaintenanceTime", csMxBean.getTotalIndexMaintenanceTime(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder.toString(), "Member metrics exported to {0}.", false);
            }
            return crd;
        }
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Member MBean for " + MBeanJMXAdapter.getMemberNameOrId(distributedMember) + " not found"));
        return ResultBuilder.createErrorResultData().addLine(errorMessage);
    }

    private ResultData getDistributedRegionMetrics(String regionName, String export_to_report_to, String[] categoriesArr) throws ResultDataException {
        InternalCache cache = this.getCache();
        ManagementService managementService = ManagementService.getManagementService(cache);
        DistributedRegionMXBean regionMxBean = managementService.getDistributedRegionMXBean(regionName);
        if (regionMxBean != null) {
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Cluster-wide Region Metrics");
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getSystemRegionMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("cluster").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cluster", "member count", regionMxBean.getMemberCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "region entry count", regionMxBean.getSystemRegionEntryCount(), csvBuilder);
            }
            if (categoriesMap.get("region").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
            }
            if (categoriesMap.get("partition").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "averageBucketSize", regionMxBean.getAvgBucketSize(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", regionMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
            }
            if (categoriesMap.get("callback").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder.toString(), "Aggregate Region Metrics exported to {0}.", false);
            }
            return crd;
        }
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Distributed Region MBean for " + regionName + " not found"));
        erd.addLine(errorMessage);
        return erd;
    }

    private ResultData getRegionMetricsFromMember(String regionName, DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr) throws ResultDataException {
        ObjectName regionMBeanName;
        InternalCache cache = this.getCache();
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        RegionMXBean regionMxBean = managementService.getMBeanInstance(regionMBeanName = managementService.getRegionMBeanName(distributedMember, regionName), RegionMXBean.class);
        if (regionMxBean != null) {
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Metrics for region:" + regionName + " On Member " + MBeanJMXAdapter.getMemberNameOrId(distributedMember));
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getRegionMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("region").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
            }
            if (categoriesMap.get("partition").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "configuredRedundancy", regionMxBean.getConfiguredRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "actualRedundancy", regionMxBean.getActualRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", "" + regionMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
            }
            if (categoriesMap.get("callback").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder.toString(), "Region Metrics exported to {0}.", false);
            }
            return crd;
        }
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Region MBean for " + regionName + " on member " + MBeanJMXAdapter.getMemberNameOrId(distributedMember) + " not found"));
        erd.addLine(errorMessage);
        return erd;
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, long metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, double metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private Set<String> createSet(String[] categories) {
        HashSet<String> categoriesSet = new HashSet<String>();
        for (String category : categories) {
            categoriesSet.add(category);
        }
        return categoriesSet;
    }

    private Map<String, Boolean> getSystemMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("cluster", true);
        categories.put("cache", true);
        categories.put("diskstore", true);
        categories.put("query", true);
        return categories;
    }

    private Map<String, Boolean> getRegionMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("region", true);
        categories.put("partition", true);
        categories.put("diskstore", true);
        categories.put("callback", true);
        categories.put("gatewayreceiver", true);
        categories.put("distribution", true);
        categories.put("query", true);
        categories.put("eviction", true);
        return categories;
    }

    private Map<String, Boolean> getSystemRegionMetricsCategories() {
        Map<String, Boolean> categories = this.getRegionMetricsCategories();
        categories.put("cluster", true);
        return categories;
    }

    private Map<String, Boolean> getMemberMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("member", true);
        categories.put("jvm", true);
        categories.put("region", true);
        categories.put("serialization", true);
        categories.put("communication", true);
        categories.put("function", true);
        categories.put("transaction", true);
        categories.put("diskstore", true);
        categories.put("lock", true);
        categories.put("eviction", true);
        categories.put("distribution", true);
        categories.put("offheap", true);
        return categories;
    }

    private String formatNames(String[] names, int startIndex) {
        StringBuilder sb = new StringBuilder();
        if (names != null) {
            for (String name : names) {
                sb.append(name.substring(startIndex));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, String[] metricValue, StringBuilder csvBuilder) {
        if (metricValue != null) {
            for (int i = 0; i < metricValue.length; ++i) {
                if (i == 0) {
                    this.writeToTableAndCsv(metricsTable, type, metricName, metricValue[i], csvBuilder);
                    continue;
                }
                this.writeToTableAndCsv(metricsTable, "", "", metricValue[i], csvBuilder);
            }
        }
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, String metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    @CliCommand(value={"change loglevel"}, help="This command changes log-level run time on specified servers.")
    @CliMetaData(relatedTopic={"Logs"}, interceptor="org.apache.geode.management.internal.cli.commands.MiscellaneousCommands$ChangeLogLevelInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.WRITE)
    public Result changeLogLevel(@CliOption(key={"members"}, help="Name/Id of the member to change the log-level") String[] memberIds, @CliOption(key={"groups"}, unspecifiedDefaultValue="", help="Groups of members to change the log-level") String[] grps, @CliOption(key={"loglevel"}, optionContext="geode.converter.log.levels:disable-string-converter", mandatory=true, unspecifiedDefaultValue="", help="Log level to change to") String logLevel) {
        try {
            if (!(memberIds != null && memberIds.length != 0 || grps != null && grps.length != 0)) {
                return ResultBuilder.createUserErrorResult("Specify one of group or member");
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            LogWriter logger = cache.getLogger();
            HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
            Set<DistributedMember> ds = CliUtil.getAllMembers(cache);
            if (grps != null && grps.length > 0) {
                for (String grp : grps) {
                    dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
                }
            }
            if (memberIds != null && memberIds.length > 0) {
                block5: for (String member : memberIds) {
                    for (DistributedMember mem : ds) {
                        if (mem.getName() == null || !mem.getName().equals(member) && !mem.getId().equals(member)) continue;
                        dsMembers.add(mem);
                        continue block5;
                    }
                }
            }
            if (dsMembers.size() == 0) {
                return ResultBuilder.createGemFireErrorResult("No members were observed for changing log-level.");
            }
            ChangeLogLevelFunction logFunction = new ChangeLogLevelFunction();
            FunctionService.registerFunction(logFunction);
            Object[] functionArgs = new Object[]{logLevel};
            CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = compositeResultData.addSection("section");
            TabularResultData resultTable = section.addTable("ChangeLogLevel");
            resultTable = resultTable.setHeader("Summary");
            Execution execution = FunctionService.onMembers(dsMembers).setArguments(functionArgs);
            if (execution == null) {
                return ResultBuilder.createUserErrorResult("Cannot execute change log-level.");
            }
            List resultList = (List)execution.execute(logFunction).getResult();
            for (Object object : resultList) {
                try {
                    if (object instanceof Throwable) {
                        logger.warning("Exception in ChangeLogLevelFunction " + ((Throwable)object).getMessage(), (Throwable)object);
                        continue;
                    }
                    if (object == null) continue;
                    Map resultMap = (Map)object;
                    Map.Entry entry = resultMap.entrySet().iterator().next();
                    if (((String)entry.getValue()).contains("ChangeLogLevelFunction exception")) {
                        resultTable.accumulate("Member", entry.getKey());
                        resultTable.accumulate("Changed log-level", "false");
                        continue;
                    }
                    resultTable.accumulate("Member", entry.getKey());
                    resultTable.accumulate("Changed log-level", "true");
                }
                catch (Exception ex) {
                    LogWrapper.getInstance().warning("change log level command exception " + ex);
                }
            }
            Result result = ResultBuilder.buildResult(compositeResultData);
            logger.info("change log-level command result=" + result);
            return result;
        }
        catch (Exception ex) {
            GemFireCacheImpl.getInstance().getLogger().error("GFSH Changeloglevel exception: " + ex);
            return ResultBuilder.createUserErrorResult(ex.getMessage());
        }
    }

    @CliAvailabilityIndicator(value={"shutdown", "gc", "show dead-locks", "show metrics", "show log", "export stack-traces", "netstat", "export logs", "change loglevel"})
    public boolean shutdownCommandAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    private Set<String> getSetDifference(Set<String> set1, Set<String> set2) {
        HashSet<String> setDifference = new HashSet<String>();
        for (String element : set1) {
            if (set2.contains(element.toLowerCase())) continue;
            setDifference.add(element);
        }
        return setDifference;
    }

    public static class ChangeLogLevelInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> arguments = parseResult.getParamValueStrings();
            String logLevel = arguments.get("loglevel");
            if (StringUtils.isBlank((String)logLevel) || LogLevel.getLevel(logLevel) == null) {
                return ResultBuilder.createUserErrorResult("Invalid log level: " + logLevel);
            }
            return ResultBuilder.createInfoResult("");
        }
    }

    public static class ExportStackTraceInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String fileName = paramValueMap.get("file");
            AbstractCliAroundInterceptor.Response response = this.readYesNo(CliStrings.format("If file {0} already present at locator directory it will be overwritten, do you want to continue?", (Object)fileName), AbstractCliAroundInterceptor.Response.YES);
            if (response == AbstractCliAroundInterceptor.Response.NO) {
                return ResultBuilder.createShellClientAbortOperationResult("Aborting export stack-traces");
            }
            return ResultBuilder.createInfoResult("");
        }
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            if (Boolean.getBoolean("ignoreInterCeptors")) {
                return ResultBuilder.createInfoResult("Shutting down entire distributed system");
            }
            AbstractCliAroundInterceptor.Response response = this.readYesNo("As a lot of data in memory will be lost, including possibly events in queues, do you really want to shutdown the entire distributed system?", AbstractCliAroundInterceptor.Response.YES);
            if (response == AbstractCliAroundInterceptor.Response.NO) {
                return ResultBuilder.createShellClientAbortOperationResult("Aborting shutdown of the entire distributed system");
            }
            return ResultBuilder.createInfoResult("Shutting down entire distributed system");
        }
    }
}

