/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexDetails;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDefinedIndexesFunction;
import org.apache.geode.management.internal.cli.functions.CreateIndexFunction;
import org.apache.geode.management.internal.cli.functions.DestroyIndexFunction;
import org.apache.geode.management.internal.cli.functions.ListIndexFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class IndexCommands
implements GfshCommand {
    private static final CreateIndexFunction createIndexFunction = new CreateIndexFunction();
    private static final DestroyIndexFunction destroyIndexFunction = new DestroyIndexFunction();
    private static final CreateDefinedIndexesFunction createDefinedIndexesFunction = new CreateDefinedIndexesFunction();
    private static final Set<IndexInfo> indexDefinitions = Collections.synchronizedSet(new HashSet());
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @CliCommand(value={"list indexes"}, help="Display the list of indexes created for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listIndex(@CliOption(key={"with-stats"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether statistics should also be displayed.") boolean showStats) {
        try {
            return this.toTabularResult(this.getIndexListing(), showStats);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"list indexes"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().error(t);
            return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while collecting all Index information across the Geode cluster: %1$s", this.toString(t, this.isDebugging())));
        }
    }

    protected List<IndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getMembers(this.getCache()));
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute(new ListIndexFunction());
        List results = (List)resultsCollector.getResult();
        ArrayList<IndexDetails> indexDetailsList = new ArrayList<IndexDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            indexDetailsList.addAll((Set)result);
        }
        Collections.sort(indexDetailsList);
        return indexDetailsList;
    }

    protected Result toTabularResult(List<IndexDetails> indexDetailsList, boolean showStats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (IndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Member Name", StringUtils.defaultString((String)indexDetails.getMemberName()));
                indexData.accumulate("Member ID", indexDetails.getMemberId());
                indexData.accumulate("Region Path", indexDetails.getRegionPath());
                indexData.accumulate("Name", indexDetails.getIndexName());
                indexData.accumulate("Type", StringUtils.defaultString((Object)indexDetails.getIndexType()));
                indexData.accumulate("Indexed Expression", indexDetails.getIndexedExpression());
                indexData.accumulate("From Clause", indexDetails.getFromClause());
                if (!showStats) continue;
                IndexStatisticsDetailsAdapter adapter = new IndexStatisticsDetailsAdapter(indexDetails.getIndexStatisticsDetails());
                indexData.accumulate("Uses", adapter.getTotalUses());
                indexData.accumulate("Updates", adapter.getNumberOfUpdates());
                indexData.accumulate("Update Time", adapter.getTotalUpdateTime());
                indexData.accumulate("Keys", adapter.getNumberOfKeys());
                indexData.accumulate("Values", adapter.getNumberOfValues());
            }
            return ResultBuilder.buildResult(indexData);
        }
        return ResultBuilder.createInfoResult("No Indexes Found");
    }

    @CliCommand(value={"create index"}, help="Create an index that can be used when executing queries.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the index to create.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"member"}, mandatory=false, optionContext="geode.converter.member.idOrName", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"type"}, mandatory=false, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type", help="Type of the index. Valid values are: range, key and hash.") String indexType, @CliOption(key={"group"}, mandatory=false, optionContext="geode.converter.member.groups", help="Group of members in which the index will be created.") String[] group) {
        Result result = null;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        this.securityService.authorizeRegionManage(regionPath);
        try {
            Cache cache = CacheFactory.getAnyInstance();
            int idxType = 1;
            if ("range".equalsIgnoreCase(indexType)) {
                idxType = 1;
            } else if ("hash".equalsIgnoreCase(indexType)) {
                idxType = 3;
            } else if ("key".equalsIgnoreCase(indexType)) {
                idxType = 2;
            } else {
                return ResultBuilder.createUserErrorResult("Invalid index type,value must be one of the following: range, key or hash.");
            }
            if (indexName == null || indexName.isEmpty()) {
                return ResultBuilder.createUserErrorResult("Invalid index name");
            }
            if (indexedExpression == null || indexedExpression.isEmpty()) {
                return ResultBuilder.createUserErrorResult("Invalid indexed expression : \"{0}\"");
            }
            if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
                return ResultBuilder.createUserErrorResult("Region not found : \"{0}\"");
            }
            if (!regionPath.startsWith("/")) {
                regionPath = "/" + regionPath;
            }
            IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, idxType);
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)createIndexFunction, (Object)indexInfo, targetMembers);
            List funcResults = (List)rc.getResult();
            TreeSet<String> successfulMembers = new TreeSet<String>();
            HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
            for (Object funcResult : funcResults) {
                if (!(funcResult instanceof CliFunctionResult)) continue;
                CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
                if (cliFunctionResult.isSuccessful()) {
                    successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                    if (xmlEntity.get() != null) continue;
                    xmlEntity.set(cliFunctionResult.getXmlEntity());
                    continue;
                }
                String exceptionMessage = cliFunctionResult.getMessage();
                TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
                if (failedMembers == null) {
                    failedMembers = new TreeSet<String>();
                }
                failedMembers.add(cliFunctionResult.getMemberIdOrName());
                indexOpFailMap.put(exceptionMessage, failedMembers);
            }
            if (!successfulMembers.isEmpty()) {
                InfoResultData infoResult = ResultBuilder.createInfoResultData();
                infoResult.addLine("Index successfully created with following details");
                infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
                infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
                infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
                infoResult.addLine("Members which contain the index");
                int num = 0;
                for (String memberId : successfulMembers) {
                    infoResult.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                }
                result = ResultBuilder.buildResult(infoResult);
            } else {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                erd.addLine(CliStrings.format("Failed to create index \"{0}\" due to following reasons", (Object)indexName));
                Set exceptionMessages = indexOpFailMap.keySet();
                for (String exceptionMessage : exceptionMessages) {
                    erd.addLine(exceptionMessage);
                    erd.addLine("Occurred on following members");
                    Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                    int num = 0;
                    for (String memberId : memberIds) {
                        erd.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                    }
                }
                result = ResultBuilder.buildResult(erd);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }

    @CliCommand(value={"destroy index"}, help="Destroy/Remove the specified index.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    public Result destroyIndex(@CliOption(key={"name"}, mandatory=false, unspecifiedDefaultValue="", help="Name of the index to remove.") String indexName, @CliOption(key={"region"}, mandatory=false, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region from which the index will be removed.") String regionPath, @CliOption(key={"member"}, mandatory=false, optionContext="geode.converter.member.idOrName", help="Name/Id of the member from which the index will be removed.") String[] memberNameOrID, @CliOption(key={"group"}, mandatory=false, optionContext="geode.converter.member.groups", help="Group of members from which the index will be removed.") String[] group) {
        Result result = null;
        if (StringUtils.isBlank((String)indexName) && StringUtils.isBlank((String)regionPath) && ArrayUtils.isEmpty((Object[])group) && ArrayUtils.isEmpty((Object[])memberNameOrID)) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("\"{0}\" requires that one or more parameters be provided.", (Object)"destroy index"));
        }
        String regionName = null;
        Cache cache = CacheFactory.getAnyInstance();
        if (StringUtils.isNotBlank((String)regionPath)) {
            regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
            this.securityService.authorizeRegionManage(regionName);
        } else {
            this.securityService.authorizeDataManage();
        }
        IndexInfo indexInfo = new IndexInfo(indexName, regionName);
        Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)destroyIndexFunction, (Object)indexInfo, targetMembers);
        List funcResults = (List)rc.getResult();
        TreeSet<String> successfulMembers = new TreeSet<String>();
        HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        for (Object funcResult : funcResults) {
            if (!(funcResult instanceof CliFunctionResult)) continue;
            CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
            if (cliFunctionResult.isSuccessful()) {
                successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(cliFunctionResult.getXmlEntity());
                continue;
            }
            String exceptionMessage = cliFunctionResult.getMessage();
            TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
            if (failedMembers == null) {
                failedMembers = new TreeSet<String>();
            }
            failedMembers.add(cliFunctionResult.getMemberIdOrName());
            indexOpFailMap.put(exceptionMessage, failedMembers);
        }
        if (!successfulMembers.isEmpty()) {
            InfoResultData infoResult = ResultBuilder.createInfoResultData();
            if (StringUtils.isNotBlank((String)indexName)) {
                if (StringUtils.isNotBlank((String)regionPath)) {
                    infoResult.addLine(CliStrings.format("Index \"{0}\" on region : \"{1}\" successfully destroyed on the following members", indexName, regionPath));
                } else {
                    infoResult.addLine(CliStrings.format("Index \"{0}\" successfully destroyed on the following members", (Object)indexName));
                }
            } else if (StringUtils.isNotBlank((String)regionPath)) {
                infoResult.addLine(CliStrings.format("Indexes on region : {0} successfully destroyed on the following members", (Object)regionPath));
            } else {
                infoResult.addLine("Indexes successfully destroyed on the following members");
            }
            int num = 0;
            for (String memberId : successfulMembers) {
                infoResult.addLine(CliStrings.format(CliStrings.format("{0}. {1}", ++num, memberId), new Object[0]));
            }
            result = ResultBuilder.buildResult(infoResult);
        } else {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            if (StringUtils.isNotBlank((String)indexName)) {
                erd.addLine(CliStrings.format("Index \"{0}\" could not be destroyed for following reasons", (Object)indexName));
            } else {
                erd.addLine("Indexes could not be destroyed for following reasons");
            }
            Set exceptionMessages = indexOpFailMap.keySet();
            for (String exceptionMessage : exceptionMessages) {
                erd.addLine(CliStrings.format("{0}.", (Object)exceptionMessage));
                erd.addLine("Occurred on following members");
                Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                int num = 0;
                for (String memberId : memberIds) {
                    erd.addLine(CliStrings.format(CliStrings.format("{0}. {1}", ++num, memberId), new Object[0]));
                }
                erd.addLine("");
            }
            result = ResultBuilder.buildResult(erd);
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }

    @CliCommand(value={"define index"}, help="Define an index that can be used when executing queries.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    public Result defineIndex(@CliOption(key={"name"}, mandatory=true, help="Define an index that can be used when executing queries.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"type"}, mandatory=false, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type", help="Type of the index. Valid values are: range, key and hash.") String indexType) {
        Result result = null;
        Object xmlEntity = null;
        this.securityService.authorizeRegionManage(regionPath);
        int idxType = 1;
        if ("range".equalsIgnoreCase(indexType)) {
            idxType = 1;
        } else if ("hash".equalsIgnoreCase(indexType)) {
            idxType = 3;
        } else if ("key".equalsIgnoreCase(indexType)) {
            idxType = 2;
        } else {
            return ResultBuilder.createUserErrorResult("Invalid index type,value must be one of the following: range, key or hash.");
        }
        if (indexName == null || indexName.isEmpty()) {
            return ResultBuilder.createUserErrorResult("Invalid index name");
        }
        if (indexedExpression == null || indexedExpression.isEmpty()) {
            return ResultBuilder.createUserErrorResult("Invalid indexed expression : \"{0}\"");
        }
        if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
            return ResultBuilder.createUserErrorResult("Region not found : \"{0}\"");
        }
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, idxType);
        indexDefinitions.add(indexInfo);
        InfoResultData infoResult = ResultBuilder.createInfoResultData();
        infoResult.addLine("Index successfully defined with following details");
        infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
        infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
        infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
        result = ResultBuilder.buildResult(infoResult);
        return result;
    }

    @CliCommand(value={"create defined indexes"}, help="Creates all the defined indexes.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createDefinedIndexes(@CliOption(key={"member"}, mandatory=false, optionContext="geode.converter.member.idOrName", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"group"}, mandatory=false, optionContext="geode.converter.member.groups", help="Group of members in which the index will be created.") String[] group) {
        Result result = null;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        if (indexDefinitions.isEmpty()) {
            InfoResultData infoResult = ResultBuilder.createInfoResultData();
            infoResult.addLine("No indexes defined");
            return ResultBuilder.buildResult(infoResult);
        }
        try {
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            Cache cache = CacheFactory.getAnyInstance();
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)createDefinedIndexesFunction, indexDefinitions, targetMembers);
            List funcResults = (List)rc.getResult();
            TreeSet<String> successfulMembers = new TreeSet<String>();
            HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
            for (Object funcResult : funcResults) {
                if (!(funcResult instanceof CliFunctionResult)) continue;
                CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
                if (cliFunctionResult.isSuccessful()) {
                    successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                    if (xmlEntity.get() != null) continue;
                    xmlEntity.set(cliFunctionResult.getXmlEntity());
                    continue;
                }
                String exceptionMessage = cliFunctionResult.getMessage();
                TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
                if (failedMembers == null) {
                    failedMembers = new TreeSet<String>();
                }
                failedMembers.add(cliFunctionResult.getMemberIdOrName());
                indexOpFailMap.put(exceptionMessage, failedMembers);
            }
            if (!successfulMembers.isEmpty()) {
                InfoResultData infoResult = ResultBuilder.createInfoResultData();
                infoResult.addLine("Indexes successfully created. Use list indexes to get details.");
                int num = 0;
                for (String memberId : successfulMembers) {
                    infoResult.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                }
                result = ResultBuilder.buildResult(infoResult);
            } else {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                Set exceptionMessages = indexOpFailMap.keySet();
                for (String exceptionMessage : exceptionMessages) {
                    erd.addLine(exceptionMessage);
                    erd.addLine("Occurred on following members");
                    Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                    int num = 0;
                    for (String memberId : memberIds) {
                        erd.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                    }
                }
                result = ResultBuilder.buildResult(erd);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }

    @CliCommand(value={"clear defined indexes"}, help="Clears all the defined indexes.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result clearDefinedIndexes() {
        indexDefinitions.clear();
        InfoResultData infoResult = ResultBuilder.createInfoResultData();
        infoResult.addLine("Index definitions successfully cleared");
        return ResultBuilder.buildResult(infoResult);
    }

    @CliAvailabilityIndicator(value={"list indexes", "create index", "destroy index", "create defined indexes", "clear defined indexes", "define index"})
    public boolean indexCommandsAvailable() {
        return !CliUtil.isGfshVM() || this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    protected static class IndexStatisticsDetailsAdapter {
        private final IndexDetails.IndexStatisticsDetails indexStatisticsDetails;

        protected IndexStatisticsDetailsAdapter(IndexDetails.IndexStatisticsDetails indexStatisticsDetails) {
            this.indexStatisticsDetails = indexStatisticsDetails;
        }

        public IndexDetails.IndexStatisticsDetails getIndexStatisticsDetails() {
            return this.indexStatisticsDetails;
        }

        public String getNumberOfKeys() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfKeys()) : "";
        }

        public String getNumberOfUpdates() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfUpdates()) : "";
        }

        public String getNumberOfValues() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfValues()) : "";
        }

        public String getTotalUpdateTime() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getTotalUpdateTime()) : "";
        }

        public String getTotalUses() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getTotalUses()) : "";
        }
    }
}

