/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.MemberNotFoundException;
import org.springframework.shell.core.CommandMarker;

public interface GfshCommand
extends CommandMarker {
    default public String convertDefaultValue(String from, String to) {
        return "__DEFAULT__".equals(from) ? to : from;
    }

    default public String toString(Boolean condition, String trueValue, String falseValue) {
        return Boolean.TRUE.equals(condition) ? StringUtils.defaultIfBlank((String)trueValue, (String)"true") : StringUtils.defaultIfBlank((String)falseValue, (String)"false");
    }

    default public String toString(Throwable t, boolean printStackTrace) {
        String message = t.getMessage();
        if (printStackTrace) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            message = writer.toString();
        }
        return message;
    }

    default public boolean isConnectedAndReady() {
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    default public ClusterConfigurationService getSharedConfiguration() {
        InternalLocator locator = InternalLocator.getLocator();
        return locator == null ? null : locator.getSharedConfiguration();
    }

    default public void persistClusterConfiguration(Result result, Runnable runnable) {
        if (result == null) {
            throw new IllegalArgumentException("Result should not be null");
        }
        ClusterConfigurationService sc = this.getSharedConfiguration();
        if (sc == null) {
            result.setCommandPersisted(false);
        } else {
            runnable.run();
            result.setCommandPersisted(true);
        }
    }

    default public boolean isDebugging() {
        return this.getGfsh() != null && this.getGfsh().getDebug();
    }

    default public boolean isLogging() {
        return this.getGfsh() != null;
    }

    default public InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    default public Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    default public DistributedMember getMember(InternalCache cache, String memberName) {
        for (DistributedMember member : this.getMembers(cache)) {
            if (!memberName.equalsIgnoreCase(member.getName()) && !memberName.equalsIgnoreCase(member.getId())) continue;
            return member;
        }
        throw new MemberNotFoundException(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberName));
    }

    @Deprecated
    default public Set<DistributedMember> getMembers(InternalCache cache) {
        HashSet<DistributedMember> members = new HashSet<DistributedMember>(cache.getMembers());
        members.add(cache.getDistributedSystem().getDistributedMember());
        return members;
    }

    default public Execution getMembersFunctionExecutor(Set<DistributedMember> members) {
        return FunctionService.onMembers(members);
    }

    default public void logInfo(String message) {
        this.logInfo(message, null);
    }

    default public void logInfo(Throwable cause) {
        this.logInfo(cause.getMessage(), cause);
    }

    default public void logInfo(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logInfo(message, cause);
        }
    }

    default public void logWarning(String message) {
        this.logWarning(message, null);
    }

    default public void logWarning(Throwable cause) {
        this.logWarning(cause.getMessage(), cause);
    }

    default public void logWarning(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logWarning(message, cause);
        }
    }

    default public void logSevere(String message) {
        this.logSevere(message, null);
    }

    default public void logSevere(Throwable cause) {
        this.logSevere(cause.getMessage(), cause);
    }

    default public void logSevere(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logSevere(message, cause);
        }
    }

    default public <T extends Function> T register(T function) {
        if (FunctionService.isRegistered(function.getId())) {
            function = FunctionService.getFunction(function.getId());
        } else {
            FunctionService.registerFunction(function);
        }
        return function;
    }
}

