/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.functions.ExportDataFunction;
import org.apache.geode.management.internal.cli.functions.ImportDataFunction;
import org.apache.geode.management.internal.cli.functions.RebalanceFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DataCommands
implements GfshCommand {
    final int resultItemCount = 9;
    private final ExportDataFunction exportDataFunction = new ExportDataFunction();
    private final ImportDataFunction importDataFunction = new ImportDataFunction();
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @CliCommand(value={"rebalance"}, help="Rebalance partitioned regions. The default is for all partitioned regions to be rebalanced.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result rebalance(@CliOption(key={"include-region"}, unspecifiedDefaultValue="__NULL__", help="Partitioned regions to be included when rebalancing. Includes take precedence over excludes.") String[] includeRegions, @CliOption(key={"exclude-region"}, unspecifiedDefaultValue="__NULL__", help="Partitioned regions to be excluded when rebalancing.") String[] excludeRegions, @CliOption(key={"time-out"}, unspecifiedDefaultValue="-1", help="Time to wait (in seconds) before GFSH returns to a prompt while rebalancing continues in the background. The default is to wait for rebalancing to complete.") long timeout, @CliOption(key={"simulate"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to only simulate rebalancing. The --time-out parameter is not available when simulating.") boolean simulate) {
        Result result;
        ExecutorService commandExecutors = Executors.newSingleThreadExecutor();
        ArrayList<Future<Result>> commandResult = new ArrayList<Future<Result>>();
        try {
            commandResult.add(commandExecutors.submit(new ExecuteRebalanceWithTimeout(includeRegions, excludeRegions, simulate)));
            Future fs = (Future)commandResult.get(0);
            result = timeout > 0L ? (Result)fs.get(timeout, TimeUnit.SECONDS) : (Result)fs.get();
        }
        catch (TimeoutException timeoutException) {
            result = ResultBuilder.createInfoResult("Rebalance will continue in background");
        }
        catch (Exception ex) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Exception occurred while rebelancing. Reason : {0}", (Object)ex.getMessage()));
        }
        LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
        return result;
    }

    private List<String> tokenize(String str, String separator) {
        StringTokenizer st = new StringTokenizer(str, separator);
        ArrayList<String> rstList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            rstList.add(st.nextToken());
        }
        return rstList;
    }

    private boolean checkResultList(CompositeResultData rebalanceResultData, List resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            for (Object object : resultList) {
                if (object instanceof Exception) {
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Exception)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Throwable)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            LogWrapper.getInstance().info("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            rebalanceResultData.addSection().addData("Rebalancing for member=" + member.getId(), ", resultList is either null or empty");
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    private Result executeRebalanceOnDS(InternalCache cache, String simulate, String[] excludeRegionsList) {
        List<MemberPRInfo> listMemberRegion;
        Result result = null;
        int index = 1;
        CompositeResultData rebalanceResultData = ResultBuilder.createCompositeResultData();
        ArrayList<String> listExcludedRegion = new ArrayList<String>();
        if (excludeRegionsList != null) {
            Collections.addAll(listExcludedRegion, excludeRegionsList);
        }
        if ((listMemberRegion = this.getMemberRegionList(cache, listExcludedRegion)).size() == 0) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        Iterator<MemberPRInfo> iterator = listMemberRegion.iterator();
        boolean flagToContinueWithRebalance = false;
        while (iterator.hasNext()) {
            if (iterator.next().dsMemberList.size() <= 1) continue;
            flagToContinueWithRebalance = true;
            break;
        }
        if (!flagToContinueWithRebalance) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        block5: for (MemberPRInfo memberPR : listMemberRegion) {
            try {
                if (memberPR.dsMemberList.size() <= 1) continue;
                for (int i = 0; i < memberPR.dsMemberList.size(); ++i) {
                    List<String> rstList;
                    HashSet excludeRegionSet;
                    DistributedMember dsMember = memberPR.dsMemberList.get(i);
                    RebalanceFunction rebalanceFunction = new RebalanceFunction();
                    Object[] functionArgs = new Object[3];
                    functionArgs[0] = simulate;
                    HashSet<String> regionSet = new HashSet<String>();
                    regionSet.add(memberPR.region);
                    functionArgs[1] = regionSet;
                    functionArgs[2] = excludeRegionSet = new HashSet();
                    ArrayList resultList = null;
                    try {
                        if (this.checkMemberPresence(dsMember, cache)) {
                            resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, dsMember).getResult();
                            if (this.checkResultList(rebalanceResultData, resultList, dsMember)) {
                                result = ResultBuilder.buildResult(rebalanceResultData);
                                continue;
                            }
                            rstList = this.tokenize((String)resultList.get(0), ",");
                            result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResultData, (ArrayList)rstList, index, simulate.equals("true"), cache));
                            ++index;
                            continue block5;
                        }
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResultData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : Members may be departed");
                        result = ResultBuilder.buildResult(rebalanceResultData);
                    }
                    catch (Exception ex) {
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResultData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : " + ex.getMessage());
                        result = ResultBuilder.buildResult(rebalanceResultData);
                    }
                    if (this.checkResultList(rebalanceResultData, resultList, dsMember)) {
                        result = ResultBuilder.buildResult(rebalanceResultData);
                        continue;
                    }
                    rstList = this.tokenize((String)resultList.get(0), ",");
                    result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResultData, (ArrayList)rstList, index, simulate.equals("true"), cache));
                    ++index;
                }
            }
            catch (Exception e) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
                return ResultBuilder.buildResult(errorResultData);
            }
        }
        return result;
    }

    public boolean checkMemberPresence(DistributedMember dsMember, InternalCache cache) {
        Set<DistributedMember> dsMemberList = CliUtil.getAllNormalMembers(cache);
        return dsMemberList.contains(dsMember);
    }

    public String listOfAllMembers(ArrayList<DistributedMember> dsMemberList) {
        StringBuilder listMembersId = new StringBuilder();
        for (int j = 0; j < dsMemberList.size() - 1; ++j) {
            listMembersId.append(dsMemberList.get(j).getId());
            listMembersId.append(" ; ");
        }
        return listMembersId.toString();
    }

    protected CompositeResultData toCompositeResultData(CompositeResultData rebalanceResulteData, ArrayList<String> rstlist, int index, boolean simulate, InternalCache cache) {
        if (rstlist.size() > 9 && StringUtils.isNotEmpty((String)rstlist.get(9))) {
            TabularResultData table1 = rebalanceResulteData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(0));
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(rstlist.get(0)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            table1.accumulate("Value", rstlist.get(1));
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(rstlist.get(1)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(2));
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(rstlist.get(2)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(3));
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(rstlist.get(3)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(4));
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(rstlist.get(4)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(5));
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(rstlist.get(5)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(6));
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(rstlist.get(6)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            table1.accumulate("Value", rstlist.get(7));
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(rstlist.get(7)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            table1.accumulate("Value", rstlist.get(8));
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(rstlist.get(8)).append(newLine);
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            for (int i = 9; i < rstlist.size(); ++i) {
                headerText = headerText + " " + rstlist.get(i);
            }
            table1.setHeader(headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResulteData;
    }

    private CompositeResultData buildResultForRebalance(CompositeResultData rebalanceResultData, RebalanceResults results, int index, boolean simulate, InternalCache cache) {
        Set<PartitionRebalanceInfo> regions = results.getPartitionRebalanceDetails();
        Iterator<PartitionRebalanceInfo> iterator = regions.iterator();
        if (regions.size() > 0 && StringUtils.isNotEmpty((String)iterator.next().getRegionPath())) {
            TabularResultData resultData = rebalanceResultData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateBytes());
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(results.getTotalBucketCreateBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateTime());
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(results.getTotalBucketCreateTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreatesCompleted());
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(results.getTotalBucketCreatesCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferBytes());
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransferBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferTime());
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(results.getTotalBucketTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransfersCompleted());
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransferTime());
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(results.getTotalPrimaryTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransfersCompleted());
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(results.getTotalPrimaryTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            resultData.accumulate("Value", results.getTotalTime());
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(results.getTotalTime()).append(newLine);
            Iterator<PartitionRebalanceInfo> it = regions.iterator();
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            while (it.hasNext()) {
                PartitionRebalanceInfo rgn = it.next();
                headerText = headerText + " " + rgn.getRegionPath();
            }
            resultData.setHeader(resultData.getHeader() + headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResultData;
    }

    public DistributedMember getAssociatedMembers(String region, InternalCache cache) {
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        DistributedMember member = null;
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        Iterator<DistributedMember> it = dsMembers.iterator();
        boolean matchFound = false;
        if (membersName.length > 1) {
            block0: while (it.hasNext() && !matchFound) {
                DistributedMember dsmember = it.next();
                for (String memberName : membersName) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    member = dsmember;
                    matchFound = true;
                    continue block0;
                }
            }
        }
        return member;
    }

    private List<MemberPRInfo> getMemberRegionList(InternalCache cache, List<String> listExcludedRegion) {
        ArrayList<MemberPRInfo> listMemberPRInfo = new ArrayList<MemberPRInfo>();
        String[] listDSRegions = ManagementService.getManagementService(cache).getDistributedSystemMXBean().listRegions();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        for (String regionName : listDSRegions) {
            DistributedRegionMXBean bean;
            boolean excludedRegionMatch = false;
            for (String aListExcludedRegion : listExcludedRegion) {
                String excludedRegion = aListExcludedRegion.trim();
                if (regionName.startsWith("/") && !excludedRegion.startsWith("/")) {
                    excludedRegion = "/" + excludedRegion;
                }
                if (excludedRegion.startsWith("/") && !regionName.startsWith("/")) {
                    regionName = "/" + regionName;
                }
                if (!excludedRegion.equals(regionName)) continue;
                excludedRegionMatch = true;
                break;
            }
            if (excludedRegionMatch) continue;
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            if ((bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(regionName)) == null || !bean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !bean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
            String[] memberNames = bean.getMembers();
            block2: for (DistributedMember dsmember : dsMembers) {
                for (String memberName : memberNames) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    MemberPRInfo memberAndItsPRRegions = new MemberPRInfo();
                    memberAndItsPRRegions.region = regionName;
                    memberAndItsPRRegions.dsMemberList.add(dsmember);
                    if (listMemberPRInfo.contains(memberAndItsPRRegions)) {
                        int index = listMemberPRInfo.indexOf(memberAndItsPRRegions);
                        MemberPRInfo listMember = (MemberPRInfo)listMemberPRInfo.get(index);
                        listMember.dsMemberList.add(dsmember);
                        continue block2;
                    }
                    listMemberPRInfo.add(memberAndItsPRRegions);
                    continue block2;
                }
            }
        }
        return listMemberPRInfo;
    }

    @CliCommand(value={"export data"}, help="Export user data from a region to a file.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public Result exportData(@CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Region from which data will be exported.") String regionName, @CliOption(key={"file"}, unspecifiedDefaultValue="__NULL__", mandatory=true, help="File to which the exported data will be written. The file must have an extension of \".gfd\".") String filePath, @CliOption(key={"member"}, unspecifiedDefaultValue="__NULL__", optionContext="geode.converter.member.idOrName", mandatory=true, help="Name/Id of a member which hosts the region. The data will be exported to the specified file on the host where the member is running.") String memberNameOrId) {
        Result result;
        this.securityService.authorizeRegionRead(regionName);
        DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
        if (!filePath.endsWith(".gfd")) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd"));
        }
        try {
            Object resultObj;
            String[] args;
            ResultCollector<?, ?> rc;
            List results;
            result = targetMember != null ? ((results = (List)(rc = CliUtil.executeFunction((Function)this.exportDataFunction, (Object)(args = new String[]{regionName, filePath}), targetMember)).getResult()) != null ? ((resultObj = results.get(0)) instanceof String ? ResultBuilder.createInfoResult((String)resultObj) : (resultObj instanceof Exception ? ResultBuilder.createGemFireErrorResult(((Exception)resultObj).getMessage()) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"export data")))) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"export data"))) : ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found", (Object)memberNameOrId));
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    @CliCommand(value={"import data"}, help="Import user data from a file to a region.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public Result importData(@CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Region into which data will be imported.") String regionName, @CliOption(key={"file"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="File from which the imported data will be read. The file must have an extension of \".gfd\".") String filePath, @CliOption(key={"member"}, mandatory=true, unspecifiedDefaultValue="__NULL__", optionContext="geode.converter.member.idOrName", help="Name/Id of a member which hosts the region. The data will be imported from the specified file on the host where the member is running.") String memberNameOrId, @CliOption(key={"invoke-callbacks"}, unspecifiedDefaultValue="false", help="Whether callbacks should be invoked") boolean invokeCallbacks) {
        Result result;
        this.securityService.authorizeRegionWrite(regionName);
        try {
            Object resultObj;
            Object[] args;
            ResultCollector<?, ?> rc;
            List results;
            DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            if (!filePath.endsWith(".gfd")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd"));
            }
            result = targetMember != null ? ((results = (List)(rc = CliUtil.executeFunction((Function)this.importDataFunction, (Object)(args = new Object[]{regionName, filePath, invokeCallbacks}), targetMember)).getResult()) != null ? ((resultObj = results.get(0)) instanceof String ? ResultBuilder.createInfoResult((String)resultObj) : (resultObj instanceof Exception ? ResultBuilder.createGemFireErrorResult(((Exception)resultObj).getMessage()) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data")))) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data"))) : ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found.", (Object)memberNameOrId));
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"put"}, help="Add/Update an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    public Result put(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"value"}, mandatory=true, help="String or JSON text from which to create the value.  Examples include: \"manager\", \"100L\" and \"('value': 'widget')\".") String value, @CliOption(key={"region"}, mandatory=true, help="Region into which the entry will be put.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @CliOption(key={"skip-if-exists"}, help="Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", unspecifiedDefaultValue="false") boolean putIfAbsent) {
        DataCommandResult dataResult;
        this.securityService.authorizeRegionWrite(regionPath);
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionPath)) {
            return this.makePresentationResult(DataCommandResult.createPutResult(key, null, null, "Region name is either empty or Null", false));
        }
        if (StringUtils.isEmpty((String)key)) {
            return this.makePresentationResult(DataCommandResult.createPutResult(key, null, null, "Key is either empty or Null", false));
        }
        if (StringUtils.isEmpty((String)value)) {
            return this.makePresentationResult(DataCommandResult.createPutResult(value, null, null, "Value is either empty or Null", false));
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction putfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, this.getCache(), false);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("put");
                request.setValue(value);
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setPutIfAbsent(putIfAbsent);
                dataResult = DataCommands.callFunctionForRegion(request, putfn, memberList);
            } else {
                dataResult = DataCommandResult.createPutInfoResult(key, value, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = putfn.put(key, value, putIfAbsent, keyClass, valueClass, regionPath);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    private Result makePresentationResult(DataCommandResult dataResult) {
        if (dataResult != null) {
            return dataResult.toCommandResult();
        }
        return ResultBuilder.createGemFireErrorResult("Error executing data command");
    }

    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"get"}, help="Display an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    public Result get(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to get the entry.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is the value constraint for the current region or String.") String valueClass, @CliOption(key={"load-on-cache-miss"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Explicitly enables or disables the use of any registered CacheLoaders on the specified Region when retrieving a value for the specified Key on Cache misses. (Default is true, or enabled)") Boolean loadOnCacheMiss) {
        DataCommandResult dataResult;
        this.securityService.authorizeRegionRead(regionPath, key);
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionPath)) {
            return this.makePresentationResult(DataCommandResult.createGetResult(key, null, null, "Region name is either empty or Null", false));
        }
        if (StringUtils.isEmpty((String)key)) {
            return this.makePresentationResult(DataCommandResult.createGetResult(key, null, null, "Key is either empty or Null", false));
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction getfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, this.getCache(), false);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("get");
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setLoadOnCacheMiss(loadOnCacheMiss);
                Subject subject = this.securityService.getSubject();
                if (subject != null) {
                    request.setPrincipal(subject.getPrincipal());
                }
                dataResult = DataCommands.callFunctionForRegion(request, getfn, memberList);
            } else {
                dataResult = DataCommandResult.createGetInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = getfn.get(null, key, keyClass, valueClass, regionPath, loadOnCacheMiss);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"locate entry"}, help="Identifies the location, including host, member and region, of entries that have the specified key.")
    public Result locateEntry(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create a key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region in which to locate values.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @CliOption(key={"recursive"}, help="Whether to traverse regions and subregions recursively.", unspecifiedDefaultValue="false") boolean recursive) {
        DataCommandResult dataResult;
        this.securityService.authorizeRegionRead(regionPath, key);
        if (StringUtils.isEmpty((String)regionPath)) {
            return this.makePresentationResult(DataCommandResult.createLocateEntryResult(key, null, null, "Region name is either empty or Null", false));
        }
        if (StringUtils.isEmpty((String)key)) {
            return this.makePresentationResult(DataCommandResult.createLocateEntryResult(key, null, null, "Key is either empty or Null", false));
        }
        DataCommandFunction locateEntry = new DataCommandFunction();
        Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, this.getCache(), true);
        if (CollectionUtils.isNotEmpty(memberList)) {
            DataCommandRequest request = new DataCommandRequest();
            request.setCommand("locate entry");
            request.setKey(key);
            request.setKeyClass(keyClass);
            request.setRegionName(regionPath);
            request.setValueClass(valueClass);
            request.setRecursive(recursive);
            dataResult = DataCommands.callFunctionForRegion(request, locateEntry, memberList);
        } else {
            dataResult = DataCommandResult.createLocateEntryInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"remove"}, help="Remove an entry from a region. If using a region whose key class has been set, then specifying --key-class is unnecessary.")
    public Result remove(@CliOption(key={"key"}, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".", specifiedDefaultValue="") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to remove the entry.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"all"}, help="Clears the region by removing all entries. Partitioned region does not support remove-all", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean removeAllKeys, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass) {
        DataCommandResult dataResult;
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionPath)) {
            return this.makePresentationResult(DataCommandResult.createRemoveResult(key, null, null, "Region name is either empty or Null", false));
        }
        if (!removeAllKeys && key == null) {
            return this.makePresentationResult(DataCommandResult.createRemoveResult(null, null, null, "Key is Null", false));
        }
        if (removeAllKeys) {
            this.securityService.authorizeRegionWrite(regionPath);
        } else {
            this.securityService.authorizeRegionWrite(regionPath, key);
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction removefn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, this.getCache(), false);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("remove");
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRemoveAllKeys(removeAllKeys ? "ALL" : null);
                request.setRegionName(regionPath);
                dataResult = DataCommands.callFunctionForRegion(request, removefn, memberList);
            } else {
                dataResult = DataCommandResult.createRemoveInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = removefn.remove(key, keyClass, regionPath, removeAllKeys ? "ALL" : null);
        }
        dataResult.setKeyClass(keyClass);
        return this.makePresentationResult(dataResult);
    }

    @CliAvailabilityIndicator(value={"rebalance", "get", "put", "remove", "locate entry", "query", "import data", "export data"})
    public boolean dataCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static DataCommandResult callFunctionForRegion(DataCommandRequest request, DataCommandFunction putfn, Set<DistributedMember> members) {
        if (members.size() == 1) {
            DistributedMember member = members.iterator().next();
            ResultCollector collector = FunctionService.onMember(member).setArguments(request).execute(putfn);
            List list = (List)collector.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                DataCommandResult result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            DataCommandResult result = (DataCommandResult)list.get(0);
            result.aggregate(null);
            return result;
        }
        ResultCollector collector = FunctionService.onMembers(members).setArguments(request).execute(putfn);
        List list = (List)collector.getResult();
        DataCommandResult result = null;
        for (Object object : list) {
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            if (result == null) {
                result = (DataCommandResult)object;
                result.aggregate(null);
                continue;
            }
            result.aggregate((DataCommandResult)object);
        }
        return result;
    }

    public static Set<DistributedMember> getQueryRegionsAssociatedMembers(Set<String> regions, InternalCache cache, boolean returnAll) {
        LogWriter logger = cache.getLogger();
        Set<DistributedMember> newMembers = null;
        Iterator<String> iterator = regions.iterator();
        String region = iterator.next();
        Set<DistributedMember> members = DataCommands.getRegionAssociatedMembers(region, cache, true);
        if (logger.fineEnabled()) {
            logger.fine("Members for region " + region + " Members " + members);
        }
        ArrayList<String> regionAndingList = new ArrayList<String>();
        regionAndingList.add(region);
        if (regions.size() == 1) {
            newMembers = members;
        } else if (CollectionUtils.isNotEmpty(members)) {
            while (iterator.hasNext()) {
                region = iterator.next();
                newMembers = DataCommands.getRegionAssociatedMembers(region, cache, true);
                if (newMembers == null) {
                    newMembers = new HashSet<DistributedMember>();
                }
                if (logger.fineEnabled()) {
                    logger.fine("Members for region " + region + " Members " + newMembers);
                }
                regionAndingList.add(region);
                newMembers.retainAll(members);
                members = newMembers;
                if (!logger.fineEnabled()) continue;
                logger.fine("Members after anding for regions " + regionAndingList + " List : " + newMembers);
            }
        }
        members = new HashSet<DistributedMember>();
        if (newMembers == null) {
            return members;
        }
        for (DistributedMember newMember : newMembers) {
            members.add(newMember);
            if (returnAll) continue;
            return members;
        }
        return members;
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, InternalCache cache, boolean returnAll) {
        if (StringUtils.isEmpty((String)region)) {
            return null;
        }
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        if (bean == null) {
            bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean("/" + region);
        }
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = cache.getMembers();
        HashSet<DistributedMember> dsMembersWithThisMember = new HashSet<DistributedMember>();
        dsMembersWithThisMember.addAll(dsMembers);
        dsMembersWithThisMember.add(cache.getDistributedSystem().getDistributedMember());
        Iterator it = dsMembersWithThisMember.iterator();
        Set<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        if (membersName.length > 0) {
            while (it.hasNext()) {
                DistributedMember dsmember = (DistributedMember)it.next();
                for (String memberName : membersName) {
                    String name = MBeanJMXAdapter.getMemberNameOrId(dsmember);
                    if (!name.equals(memberName)) continue;
                    DistributedMember member = dsmember;
                    matchedMembers.add(member);
                    if (returnAll) continue;
                    return matchedMembers;
                }
            }
        }
        if (matchedMembers.size() == 0) {
            matchedMembers = CliUtil.getMembersForeRegionViaFunction(cache, region, true);
        }
        return matchedMembers;
    }

    public static Object[] replaceGfshEnvVar(String query, Map<String, String> gfshEnvVarMap) {
        int index2;
        int index1;
        boolean done = false;
        int startIndex = 0;
        int replacedVars = 0;
        while (!done && (index1 = query.indexOf("${", startIndex)) != -1 && (index2 = query.indexOf("}", index1)) != -1) {
            String var = query.substring(index1 + 2, index2);
            String value = gfshEnvVarMap.get(var);
            if (value != null) {
                query = query.replaceAll("\\$\\{" + var + "\\}", value);
                ++replacedVars;
            }
            if ((startIndex = index2 + 1) < query.length()) continue;
            done = true;
        }
        return new Object[]{replacedVars, query};
    }

    private static class MemberPRInfo {
        public ArrayList<DistributedMember> dsMemberList = new ArrayList();
        public String region = "";

        public boolean equals(Object o2) {
            return o2 != null && this.region.equals(((MemberPRInfo)o2).region);
        }
    }

    private class ExecuteRebalanceWithTimeout
    implements Callable<Result> {
        String[] includeRegions = null;
        String[] excludeRegions = null;
        boolean simulate;
        InternalCache cache = DataCommands.this.getCache();

        @Override
        public Result call() throws Exception {
            return this.executeRebalanceWithTimeout(this.includeRegions, this.excludeRegions, this.simulate);
        }

        public ExecuteRebalanceWithTimeout(String[] includedRegions, String[] excludedRegions, boolean toSimulate) {
            this.includeRegions = includedRegions;
            this.excludeRegions = excludedRegions;
            this.simulate = toSimulate;
        }

        public Result executeRebalanceWithTimeout(String[] includeRegions, String[] excludeRegions, boolean simulate) {
            Result result = null;
            try {
                if (ArrayUtils.isNotEmpty((Object[])includeRegions)) {
                    CompositeResultData rebalanceResultData = ResultBuilder.createCompositeResultData();
                    int index = 0;
                    for (String regionName : includeRegions) {
                        regionName = regionName.startsWith("/") ? regionName : "/" + regionName;
                        Region region = this.cache.getRegion(regionName);
                        if (region == null) {
                            List rstList;
                            ArrayList resultList;
                            DistributedMember member = DataCommands.this.getAssociatedMembers(regionName, this.cache);
                            if (member == null) {
                                LogWrapper.getInstance().info(CliStrings.format("For the region {0}, no member was found", (Object)regionName));
                                continue;
                            }
                            RebalanceFunction rebalanceFunction = new RebalanceFunction();
                            Object[] functionArgs = new Object[3];
                            functionArgs[0] = simulate ? "true" : "false";
                            HashSet<String> setRegionName = new HashSet<String>();
                            setRegionName.add(regionName);
                            functionArgs[1] = setRegionName;
                            HashSet excludeRegionSet = new HashSet();
                            if (ArrayUtils.isNotEmpty((Object[])excludeRegions)) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            functionArgs[2] = excludeRegionSet;
                            if (simulate) {
                                try {
                                    resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Excpetion occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResultData.addSection().addData(CliStrings.format("Excpetion occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                if (DataCommands.this.checkResultList(rebalanceResultData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                rstList = DataCommands.this.tokenize((String)resultList.get(0), ",");
                                result = ResultBuilder.buildResult(DataCommands.this.toCompositeResultData(rebalanceResultData, (ArrayList)rstList, index, true, this.cache));
                            } else {
                                try {
                                    resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Excpetion occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResultData.addSection().addData(CliStrings.format("Excpetion occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                if (DataCommands.this.checkResultList(rebalanceResultData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                rstList = DataCommands.this.tokenize((String)resultList.get(0), ",");
                                result = ResultBuilder.buildResult(DataCommands.this.toCompositeResultData(rebalanceResultData, (ArrayList)rstList, index, false, this.cache));
                            }
                        } else {
                            RebalanceOperation op;
                            ResourceManager manager = this.cache.getResourceManager();
                            RebalanceFactory rbFactory = manager.createRebalanceFactory();
                            HashSet<String> excludeRegionSet = new HashSet<String>();
                            if (excludeRegions != null) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            rbFactory.excludeRegions(excludeRegionSet);
                            HashSet<String> includeRegionSet = new HashSet<String>();
                            includeRegionSet.add(regionName);
                            rbFactory.includeRegions(includeRegionSet);
                            if (simulate) {
                                op = manager.createRebalanceFactory().simulate();
                                result = ResultBuilder.buildResult(DataCommands.this.buildResultForRebalance(rebalanceResultData, op.getResults(), index, true, this.cache));
                            } else {
                                op = manager.createRebalanceFactory().start();
                                result = ResultBuilder.buildResult(DataCommands.this.buildResultForRebalance(rebalanceResultData, op.getResults(), index, false, this.cache));
                            }
                        }
                        ++index;
                    }
                    LogWrapper.getInstance().info("Rebalance returning result " + result);
                    return result;
                }
                result = DataCommands.this.executeRebalanceOnDS(this.cache, String.valueOf(simulate), excludeRegions);
                LogWrapper.getInstance().info("Starting Rebalance simulate false result >> " + result);
            }
            catch (Exception e) {
                result = ResultBuilder.createGemFireErrorResult(e.getMessage());
            }
            LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
            return result;
        }
    }
}

