/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.compression.Compressor;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.RegionAttributesData;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.FetchRegionAttributesFunction;
import org.apache.geode.management.internal.cli.functions.RegionAlterFunction;
import org.apache.geode.management.internal.cli.functions.RegionCreateFunction;
import org.apache.geode.management.internal.cli.functions.RegionDestroyFunction;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.util.RegionPath;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateAlterDestroyRegionCommands
implements GfshCommand {
    public static final Set<RegionShortcut> PERSISTENT_OVERFLOW_SHORTCUTS = new TreeSet<RegionShortcut>();
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @CliCommand(value={"create region"}, help="Create a region with the given path and configuration. Specifying a --key-constraint and --value-constraint makes object type information available during querying and indexing.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createRegion(@CliOption(key={"name"}, mandatory=true, help="Name/Path of the region to be created.") String regionPath, @CliOption(key={"type"}, help="Type of region to create. The following types are pre-defined by the product (see RegionShortcut javadocs for more information): PARTITION, PARTITION_REDUNDANT, PARTITION_PERSISTENT, PARTITION_REDUNDANT_PERSISTENT, PARTITION_OVERFLOW, PARTITION_REDUNDANT_OVERFLOW, PARTITION_PERSISTENT_OVERFLOW, PARTITION_REDUNDANT_PERSISTENT_OVERFLOW, PARTITION_HEAP_LRU, PARTITION_REDUNDANT_HEAP_LRU, REPLICATE, REPLICATE_PERSISTENT, REPLICATE_OVERFLOW, REPLICATE_PERSISTENT_OVERFLOW, REPLICATE_HEAP_LRU, LOCAL, LOCAL_PERSISTENT, LOCAL_HEAP_LRU, LOCAL_OVERFLOW, LOCAL_PERSISTENT_OVERFLOW, PARTITION_PROXY, PARTITION_PROXY_REDUNDANT, and REPLICATE_PROXY.") RegionShortcut regionShortcut, @CliOption(key={"template-region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose attributes should be duplicated when creating this region.") String useAttributesFrom, @CliOption(key={"group"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which the region will be created.") String[] groups, @CliOption(key={"skip-if-exists"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Skip region creation if the region already exists.") boolean skipIfExists, @CliOption(key={"async-event-queue-id"}, help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"cache-listener"}, help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") String[] cacheListener, @CliOption(key={"cache-loader"}, help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") String cacheLoader, @CliOption(key={"cache-writer"}, help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") String cacheWriter, @CliOption(key={"colocated-with"}, optionContext="geode.converter.region.path:disable-string-converter", help="Central Region with which this region should be colocated.") String prColocatedWith, @CliOption(key={"compressor"}, help="The fully-qualified class name of the Compressor to use when compressing region entry values.  The default is no compression.") String compressor, @CliOption(key={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently access a region entry at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @CliOption(key={"disk-store"}, help="Disk Store to be used by this region. \"list disk-store\" can be used to display existing disk stores.") String diskStore, @CliOption(key={"enable-async-conflation"}, help="Whether to allow aggregation of asynchronous TCP/IP messages sent by the producer member of the region. A false value causes all asynchronous messages to be sent individually.") Boolean enableAsyncConflation, @CliOption(key={"enable-cloning"}, help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"enable-concurrency-checks"}, help="Enables a versioning system that detects concurrent modifications and ensures that region contents are consistent across the distributed system.") Boolean concurrencyChecksEnabled, @CliOption(key={"enable-multicast"}, help="Enables multicast messaging on the region.  Multicast must also be enabled in the cache distributed system properties.  This is primarily useful for replicated regions that are in all servers.") Boolean mcastEnabled, @CliOption(key={"enable-statistics"}, help="Whether to gather statistics for the region. Must be true to use expiration on the region.") Boolean statisticsEnabled, @CliOption(key={"enable-subscription-conflation"}, help="Whether the server should conflate its messages to the client. A false value causes all server-client messages to be sent individually.") Boolean enableSubscriptionConflation, @CliOption(key={"enable-synchronous-disk"}, help="Whether writes are done synchronously for regions that persist data to disk.") Boolean diskSynchronous, @CliOption(key={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, help="Action to be taken on an entry that has exceeded the idle expiration.") String entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, help="Action to be taken on an entry that has exceeded the TTL expiration.") String entryExpirationTTLAction, @CliOption(key={"gateway-sender-id"}, help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"key-constraint"}, help="Fully qualified class name of the objects allowed as region keys. Ensures that keys for region entries are all of the same class.") String keyConstraint, @CliOption(key={"local-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in this process. (Default: 90% of available heap)") Integer prLocalMaxMemory, @CliOption(key={"off-heap"}, specifiedDefaultValue="true", help="Causes the values of the region to be stored in off-heap memory. The default is on heap.") Boolean offHeap, @CliOption(key={"partition-resolver"}, help="The fully-qualified class name of the region's partition resolver") String partitionResolver, @CliOption(key={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, help="Action to be taken on a region that has exceeded the idle expiration.") String regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, help="Action to be taken on a region that has exceeded the TTL expiration.") String regionExpirationTTLAction, @CliOption(key={"recovery-delay"}, help="Sets the delay in milliseconds that existing members will wait before satisfying redundancy after another member crashes. -1 (the default) indicates that redundancy will not be recovered after a failure.") Long prRecoveryDelay, @CliOption(key={"redundant-copies"}, help="Sets the number of extra copies of buckets desired. Extra copies allow for both high availability in the face of VM departure (intended or unintended) and and load balancing read operations. (Allowed values: 0, 1, 2 and 3)") Integer prRedundantCopies, @CliOption(key={"startup-recovery-delay"}, help="Sets the delay in milliseconds that new members will wait before satisfying redundancy. -1 indicates that adding new members will not trigger redundancy recovery. The default is to recover redundancy immediately when a new member is added.") Long prStartupRecoveryDelay, @CliOption(key={"total-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in all processes.") Long prTotalMaxMemory, @CliOption(key={"total-num-buckets"}, help="Sets the total number of hash buckets to be used by the region in all processes. (Default: 113).") Integer prTotalNumBuckets, @CliOption(key={"value-constraint"}, help="Fully qualified class name of the objects allowed as region values. If not specified then region values can be of any class.") String valueConstraint) {
        Result result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        try {
            Set<DistributedMember> membersToCreateRegionOn;
            RegionFunctionArgs regionFunctionArgs;
            InternalCache cache = this.getCache();
            if (regionShortcut != null && useAttributesFrom != null) {
                throw new IllegalArgumentException("Only one of type & template-region can be specified.");
            }
            if (regionShortcut == null && useAttributesFrom == null) {
                throw new IllegalArgumentException("One of \"type\" or \"template-region\" is required.");
            }
            this.validateRegionPathAndParent(cache, regionPath);
            this.validateGroups(cache, groups);
            RegionFunctionArgs.ExpirationAttrs entryIdle = null;
            if (entryExpirationIdleTime != null) {
                entryIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_IDLE, entryExpirationIdleTime, entryExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs entryTTL = null;
            if (entryExpirationTTL != null) {
                entryTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_TTL, entryExpirationTTL, entryExpirationTTLAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionIdle = null;
            if (regionExpirationIdleTime != null) {
                regionIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_IDLE, regionExpirationIdleTime, regionExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionTTL = null;
            if (regionExpirationTTL != null) {
                regionTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_TTL, regionExpirationTTL, regionExpirationTTLAction);
            }
            if (useAttributesFrom != null) {
                if (!CreateAlterDestroyRegionCommands.regionExists(cache, useAttributesFrom)) {
                    throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", useAttributesFrom));
                }
                FetchRegionAttributesFunction.FetchRegionAttributesFunctionResult regionAttributesResult = CreateAlterDestroyRegionCommands.getRegionAttributes(cache, useAttributesFrom);
                RegionAttributes regionAttributes = regionAttributesResult.getRegionAttributes();
                String[] cacheListenerClasses = cacheListener != null && cacheListener.length != 0 ? cacheListener : regionAttributesResult.getCacheListenerClasses();
                String cacheLoaderClass = cacheLoader != null ? cacheLoader : regionAttributesResult.getCacheLoaderClass();
                String cacheWriterClass = cacheWriter != null ? cacheWriter : regionAttributesResult.getCacheWriterClass();
                regionFunctionArgs = new RegionFunctionArgs(regionPath, useAttributesFrom, skipIfExists, keyConstraint, valueConstraint, statisticsEnabled, entryIdle, entryTTL, regionIdle, regionTTL, diskStore, diskSynchronous, enableAsyncConflation, enableSubscriptionConflation, cacheListenerClasses, cacheLoaderClass, cacheWriterClass, asyncEventQueueIds, gatewaySenderIds, concurrencyChecksEnabled, cloningEnabled, concurrencyLevel, prColocatedWith, prLocalMaxMemory, prRecoveryDelay, prRedundantCopies, prStartupRecoveryDelay, prTotalMaxMemory, prTotalNumBuckets, offHeap, mcastEnabled, regionAttributes, partitionResolver);
                if (regionAttributes.getPartitionAttributes() == null && regionFunctionArgs.hasPartitionAttributes()) {
                    throw new IllegalArgumentException(CliStrings.format("Parameter(s) \"{0}\" can be used only for creating a Partitioned Region.", (Object)regionFunctionArgs.getPartitionArgs().getUserSpecifiedPartitionAttributes()) + " " + CliStrings.format("\"{0}\" is not a Partitioned Region.", (Object)useAttributesFrom));
                }
            } else {
                regionFunctionArgs = new RegionFunctionArgs(regionPath, regionShortcut, useAttributesFrom, skipIfExists, keyConstraint, valueConstraint, statisticsEnabled, entryIdle, entryTTL, regionIdle, regionTTL, diskStore, diskSynchronous, enableAsyncConflation, enableSubscriptionConflation, cacheListener, cacheLoader, cacheWriter, asyncEventQueueIds, gatewaySenderIds, concurrencyChecksEnabled, cloningEnabled, concurrencyLevel, prColocatedWith, prLocalMaxMemory, prRecoveryDelay, prRedundantCopies, prStartupRecoveryDelay, prTotalMaxMemory, prTotalNumBuckets, null, compressor, offHeap, mcastEnabled, partitionResolver);
                if (!regionShortcut.name().startsWith("PARTITION") && regionFunctionArgs.hasPartitionAttributes()) {
                    throw new IllegalArgumentException(CliStrings.format("Parameter(s) \"{0}\" can be used only for creating a Partitioned Region.", (Object)regionFunctionArgs.getPartitionArgs().getUserSpecifiedPartitionAttributes()) + " " + CliStrings.format("\"{0}\" is not a Partitioned Region.", (Object)useAttributesFrom));
                }
            }
            this.validateRegionFunctionArgs(cache, regionFunctionArgs);
            if (groups != null && groups.length != 0) {
                membersToCreateRegionOn = CliUtil.getDistributedMembersByGroup(cache, groups);
                Iterator<DistributedMember> it = membersToCreateRegionOn.iterator();
                while (it.hasNext()) {
                    DistributedMember distributedMember = it.next();
                    if (((InternalDistributedMember)distributedMember).getVmKind() != 11) continue;
                    it.remove();
                }
            } else {
                membersToCreateRegionOn = CliUtil.getAllNormalMembers(cache);
            }
            if (membersToCreateRegionOn.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No caching members found.");
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)RegionCreateFunction.INSTANCE, (Object)regionFunctionArgs, membersToCreateRegionOn);
            List regionCreateResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult regionCreateResult : regionCreateResults) {
                boolean success = regionCreateResult.isSuccessful();
                tabularResultData.accumulate("Member", regionCreateResult.getMemberIdOrName());
                tabularResultData.accumulate("Status", (success ? "" : "ERROR: ") + regionCreateResult.getMessage());
                if (!success) continue;
                xmlEntity.set(regionCreateResult.getXmlEntity());
            }
            result = ResultBuilder.buildResult(tabularResultData);
            this.verifyDistributedRegionMbean(cache, regionPath);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
        }
        return result;
    }

    public boolean verifyDistributedRegionMbean(InternalCache cache, String regionName) {
        int federationInterval = cache.getInternalDistributedSystem().getConfig().getJmxManagerUpdateRate();
        long timeEnd = System.currentTimeMillis() + (long)federationInterval + 50L;
        while (System.currentTimeMillis() <= timeEnd) {
            try {
                DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(regionName);
                if (bean == null) {
                    bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean("/" + regionName);
                }
                if (bean != null) {
                    return true;
                }
                Thread.sleep(2L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @CliCommand(value={"alter region"}, help="Alter a region with the given path and configuration.")
    @CliMetaData(relatedTopic={"Region"})
    public Result alterRegion(@CliOption(key={"name"}, mandatory=true, help="Name/Path of the region to be altered.") String regionPath, @CliOption(key={"group"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which the region will be altered.") String[] groups, @CliOption(key={"entry-idle-time-expiration"}, specifiedDefaultValue="-1", help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the idle expiration.") String entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, specifiedDefaultValue="-1", help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the TTL expiration.") String entryExpirationTTLAction, @CliOption(key={"region-idle-time-expiration"}, specifiedDefaultValue="-1", help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the idle expiration.") String regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, specifiedDefaultValue="-1", help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the TTL expiration.") String regionExpirationTTLAction, @CliOption(key={"cache-listener"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") String[] cacheListeners, @CliOption(key={"cache-loader"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") String cacheLoader, @CliOption(key={"cache-writer"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") String cacheWriter, @CliOption(key={"async-event-queue-id"}, specifiedDefaultValue="", help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"gateway-sender-id"}, specifiedDefaultValue="", help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="false", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"eviction-max"}, specifiedDefaultValue="0", help="Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine when to perform its Eviction Action. The unit of the maximum value is determined by the Eviction Algorithm.") Integer evictionMax) {
        Result result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        this.securityService.authorizeRegionManage(regionPath);
        try {
            RegionFunctionArgs regionFunctionArgs;
            Set<String> cacheListenersSet;
            InternalCache cache = this.getCache();
            if (groups != null) {
                this.validateGroups(cache, groups);
            }
            RegionFunctionArgs.ExpirationAttrs entryIdle = null;
            if (entryExpirationIdleTime != null || entryExpirationIdleTimeAction != null) {
                if (entryExpirationIdleTime != null && entryExpirationIdleTime == -1) {
                    entryExpirationIdleTime = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(entryExpirationIdleTimeAction)) {
                    entryExpirationIdleTimeAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                entryIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_IDLE, entryExpirationIdleTime, entryExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs entryTTL = null;
            if (entryExpirationTTL != null || entryExpirationTTLAction != null) {
                if (entryExpirationTTL != null && entryExpirationTTL == -1) {
                    entryExpirationTTL = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(entryExpirationTTLAction)) {
                    entryExpirationTTLAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                entryTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_TTL, entryExpirationTTL, entryExpirationTTLAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionIdle = null;
            if (regionExpirationIdleTime != null || regionExpirationIdleTimeAction != null) {
                if (regionExpirationIdleTime != null && regionExpirationIdleTime == -1) {
                    regionExpirationIdleTime = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(regionExpirationIdleTimeAction)) {
                    regionExpirationIdleTimeAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                regionIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_IDLE, regionExpirationIdleTime, regionExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionTTL = null;
            if (regionExpirationTTL != null || regionExpirationTTLAction != null) {
                if (regionExpirationTTL != null && regionExpirationTTL == -1) {
                    regionExpirationTTL = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(regionExpirationTTLAction)) {
                    regionExpirationTTLAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                regionTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_TTL, regionExpirationTTL, regionExpirationTTLAction);
            }
            if ((cacheListenersSet = (regionFunctionArgs = new RegionFunctionArgs(regionPath, null, null, false, null, null, null, entryIdle, entryTTL, regionIdle, regionTTL, null, null, null, null, cacheListeners, cacheLoader = this.convertDefaultValue(cacheLoader, ""), cacheWriter = this.convertDefaultValue(cacheWriter, ""), asyncEventQueueIds, gatewaySenderIds, null, cloningEnabled, null, null, null, null, null, null, null, null, evictionMax, null, null, null, null)).getCacheListeners()) != null && !cacheListenersSet.isEmpty()) {
                for (String cacheListener : cacheListenersSet) {
                    if (this.isClassNameValid(cacheListener)) continue;
                    throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-listener. \"{0}\" is not valid.", new Object[]{cacheListener}));
                }
            }
            if (cacheLoader != null && !this.isClassNameValid(cacheLoader)) {
                throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-loader. \"{0}\" is not valid.", new Object[]{cacheLoader}));
            }
            if (cacheWriter != null && !this.isClassNameValid(cacheWriter)) {
                throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-writer. \"{0}\" is not valid.", new Object[]{cacheWriter}));
            }
            if (evictionMax != null && evictionMax < 0) {
                throw new IllegalArgumentException(CliStrings.format("Specify 0 or a positive integer value for eviction-max.  \"{0}\" is not valid.", new Object[]{evictionMax}));
            }
            Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)new RegionAlterFunction(), (Object)regionFunctionArgs, targetMembers);
            List regionAlterResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult regionAlterResult : regionAlterResults) {
                boolean success = regionAlterResult.isSuccessful();
                tabularResultData.accumulate("Member", regionAlterResult.getMemberIdOrName());
                if (success) {
                    tabularResultData.accumulate("Status", regionAlterResult.getMessage());
                    xmlEntity.set(regionAlterResult.getXmlEntity());
                    continue;
                }
                tabularResultData.accumulate("Status", "ERROR: " + regionAlterResult.getMessage());
                tabularResultData.setStatus(Result.Status.ERROR);
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
        }
        return result;
    }

    private static boolean regionExists(InternalCache cache, String regionPath) {
        boolean regionFound = false;
        if (regionPath != null && !"/".equals(regionPath)) {
            String[] allRegionPaths;
            ManagementService managementService = ManagementService.getExistingManagementService(cache);
            DistributedSystemMXBean dsMBean = managementService.getDistributedSystemMXBean();
            for (String allRegionPath : allRegionPaths = dsMBean.listAllRegionPaths()) {
                if (!allRegionPath.equals(regionPath)) continue;
                regionFound = true;
                break;
            }
        }
        return regionFound;
    }

    private void validateRegionPathAndParent(InternalCache cache, String regionPath) {
        if (StringUtils.isEmpty((String)regionPath)) {
            throw new IllegalArgumentException("Specify a valid name");
        }
        RegionPath regionPathData = new RegionPath(regionPath);
        String parentRegionPath = regionPathData.getParent();
        if (parentRegionPath != null && !"/".equals(parentRegionPath) && !CreateAlterDestroyRegionCommands.regionExists(cache, parentRegionPath)) {
            throw new IllegalArgumentException(CliStrings.format("Parent region for \"{0}\" doesn't exist. ", new Object[]{regionPath}));
        }
    }

    private void validateGroups(InternalCache cache, String[] groups) {
        if (groups != null && groups.length != 0) {
            HashSet<String> existingGroups = new HashSet<String>();
            Set<DistributedMember> members = CliUtil.getAllNormalMembers(cache);
            for (DistributedMember distributedMember : members) {
                List<String> memberGroups = distributedMember.getGroups();
                existingGroups.addAll(memberGroups);
            }
            ArrayList<String> groupsList = new ArrayList<String>(Arrays.asList(groups));
            groupsList.removeAll(existingGroups);
            if (!groupsList.isEmpty()) {
                throw new IllegalArgumentException(CliStrings.format("Group(s) \"{0}\" are invalid.", new Object[]{String.valueOf(groupsList)}));
            }
        }
    }

    private void validateRegionFunctionArgs(InternalCache cache, RegionFunctionArgs regionFunctionArgs) {
        int concurrencyLevel;
        String cacheLoader;
        String keyConstraint;
        if (regionFunctionArgs.getRegionPath() == null) {
            throw new IllegalArgumentException("Specify a valid name");
        }
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMBean = managementService.getDistributedSystemMXBean();
        String useAttributesFrom = regionFunctionArgs.getUseAttributesFrom();
        if (useAttributesFrom != null && !useAttributesFrom.isEmpty() && CreateAlterDestroyRegionCommands.regionExists(cache, useAttributesFrom)) {
            if (!CreateAlterDestroyRegionCommands.regionExists(cache, useAttributesFrom)) {
                throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", useAttributesFrom));
            }
            if (!regionFunctionArgs.isSetUseAttributesFrom().booleanValue() || regionFunctionArgs.getRegionAttributes() == null) {
                throw new IllegalArgumentException(CliStrings.format("Could not retrieve region attributes for given path \"{0}\". Use \"list regions\" to verify region exists.", (Object)useAttributesFrom));
            }
        }
        if (regionFunctionArgs.hasPartitionAttributes()) {
            long prTotalMaxMemory;
            int prLocalMaxMemory;
            RegionFunctionArgs.PartitionArgs partitionArgs = regionFunctionArgs.getPartitionArgs();
            String colocatedWith = partitionArgs.getPrColocatedWith();
            if (colocatedWith != null && !colocatedWith.isEmpty()) {
                String[] listAllRegionPaths = dsMBean.listAllRegionPaths();
                Object foundRegionPath = null;
                for (String regionPath : listAllRegionPaths) {
                    if (!regionPath.equals(colocatedWith)) continue;
                    foundRegionPath = regionPath;
                    break;
                }
                if (foundRegionPath == null) {
                    throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "colocated-with", colocatedWith));
                }
                ManagementService mgmtService = ManagementService.getExistingManagementService(cache);
                DistributedRegionMXBean distributedRegionMXBean = mgmtService.getDistributedRegionMXBean((String)foundRegionPath);
                String regionType = distributedRegionMXBean.getRegionType();
                if (!DataPolicy.PARTITION.toString().equals(regionType) && !DataPolicy.PERSISTENT_PARTITION.toString().equals(regionType)) {
                    throw new IllegalArgumentException(CliStrings.format("colocated-with \"{0}\" is not a Partitioned Region.", new Object[]{colocatedWith}));
                }
            }
            if (partitionArgs.isSetPRLocalMaxMemory().booleanValue() && (prLocalMaxMemory = partitionArgs.getPrLocalMaxMemory().intValue()) < 0) {
                throw new IllegalArgumentException(LocalizedStrings.AttributesFactory_PARTITIONATTRIBUTES_LOCALMAXMEMORY_MUST_NOT_BE_NEGATIVE.toLocalizedString());
            }
            if (partitionArgs.isSetPRTotalMaxMemory().booleanValue() && (prTotalMaxMemory = partitionArgs.getPrTotalMaxMemory().longValue()) <= 0L) {
                throw new IllegalArgumentException(LocalizedStrings.AttributesFactory_TOTAL_SIZE_OF_PARTITION_REGION_MUST_BE_0.toLocalizedString());
            }
            if (partitionArgs.isSetPRRedundantCopies().booleanValue()) {
                int prRedundantCopies = partitionArgs.getPrRedundantCopies();
                switch (prRedundantCopies) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(CliStrings.format("redundant-copies \"{0}\" is not valid. It should be one of 0, 1, 2, 3.", new Object[]{prRedundantCopies}));
                    }
                }
            }
        }
        if ((keyConstraint = regionFunctionArgs.getKeyConstraint()) != null && !this.isClassNameValid(keyConstraint)) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for key-constraint. \"{0}\" is not valid.", new Object[]{keyConstraint}));
        }
        String valueConstraint = regionFunctionArgs.getValueConstraint();
        if (valueConstraint != null && !this.isClassNameValid(valueConstraint)) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for value-constraint. \"{0}\" is not valid.", new Object[]{valueConstraint}));
        }
        Set<String> cacheListeners = regionFunctionArgs.getCacheListeners();
        if (cacheListeners != null && !cacheListeners.isEmpty()) {
            for (String cacheListener : cacheListeners) {
                if (this.isClassNameValid(cacheListener)) continue;
                throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-listener. \"{0}\" is not valid.", new Object[]{cacheListener}));
            }
        }
        if ((cacheLoader = regionFunctionArgs.getCacheLoader()) != null && !this.isClassNameValid(cacheLoader)) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-loader. \"{0}\" is not valid.", new Object[]{cacheLoader}));
        }
        String cacheWriter = regionFunctionArgs.getCacheWriter();
        if (cacheWriter != null && !this.isClassNameValid(cacheWriter)) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-writer. \"{0}\" is not valid.", new Object[]{cacheWriter}));
        }
        Set<String> gatewaySenderIds = regionFunctionArgs.getGatewaySenderIds();
        if (gatewaySenderIds != null && !gatewaySenderIds.isEmpty()) {
            String[] gatewaySenders = dsMBean.listGatewaySenders();
            if (gatewaySenders.length == 0) {
                throw new IllegalArgumentException("There are no GatewaySenders defined currently in the system.");
            }
            ArrayList<String> gatewaySendersList = new ArrayList<String>(Arrays.asList(gatewaySenders));
            gatewaySenderIds = new HashSet<String>(gatewaySenderIds);
            gatewaySenderIds.removeAll(gatewaySendersList);
            if (!gatewaySenderIds.isEmpty()) {
                throw new IllegalArgumentException(CliStrings.format("Specify valid gateway-sender-id. Unknown Gateway Sender(s): \"{0}\".", new Object[]{gatewaySenderIds}));
            }
        }
        if (regionFunctionArgs.isSetConcurrencyLevel().booleanValue() && (concurrencyLevel = regionFunctionArgs.getConcurrencyLevel().intValue()) < 0) {
            throw new IllegalArgumentException(CliStrings.format("Specify positive integer value for concurrency-level.  \"{0}\" is not valid.", new Object[]{concurrencyLevel}));
        }
        String diskStore = regionFunctionArgs.getDiskStore();
        if (diskStore != null) {
            RegionShortcut regionShortcut = regionFunctionArgs.getRegionShortcut();
            if (regionShortcut != null && !PERSISTENT_OVERFLOW_SHORTCUTS.contains((Object)regionShortcut)) {
                String subMessage = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
                String message = subMessage + ". " + CliStrings.format("Use one of these shortcuts: {0}", new Object[]{String.valueOf(PERSISTENT_OVERFLOW_SHORTCUTS)});
                throw new IllegalArgumentException(message);
            }
            RegionAttributes regionAttributes = regionFunctionArgs.getRegionAttributes();
            if (regionAttributes != null && !regionAttributes.getDataPolicy().withPersistence()) {
                String subMessage = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
                String message = subMessage + ". " + CliStrings.format("template-region region \"{0}\" is not persistent.", new Object[]{String.valueOf(regionFunctionArgs.getUseAttributesFrom())});
                throw new IllegalArgumentException(message);
            }
            if (!this.diskStoreExists(cache, diskStore)) {
                throw new IllegalArgumentException(CliStrings.format("Specify valid disk-store. Unknown Disk Store : \"{0}\".", new Object[]{diskStore}));
            }
        }
        RegionFunctionArgs.ExpirationAttrs entryExpirationIdleTime = regionFunctionArgs.getEntryExpirationIdleTime();
        RegionFunctionArgs.ExpirationAttrs entryExpirationTTL = regionFunctionArgs.getEntryExpirationTTL();
        RegionFunctionArgs.ExpirationAttrs regionExpirationIdleTime = regionFunctionArgs.getRegionExpirationIdleTime();
        RegionFunctionArgs.ExpirationAttrs regionExpirationTTL = regionFunctionArgs.getRegionExpirationTTL();
        if (!(regionFunctionArgs.isSetStatisticsEnabled().booleanValue() && regionFunctionArgs.isStatisticsEnabled().booleanValue() || entryExpirationIdleTime == null && entryExpirationTTL == null && regionExpirationIdleTime == null && regionExpirationTTL == null)) {
            String message = LocalizedStrings.AttributesFactory_STATISTICS_MUST_BE_ENABLED_FOR_EXPIRATION.toLocalizedString();
            throw new IllegalArgumentException(message + ".");
        }
        boolean compressorFailure = false;
        if (regionFunctionArgs.isSetCompressor()) {
            String compressorClassName = regionFunctionArgs.getCompressor();
            Object compressor = null;
            try {
                Class<?> compressorClass = ClassPathLoader.getLatest().forName(compressorClassName);
                compressor = compressorClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                compressorFailure = true;
            }
            if (compressorFailure || !(compressor instanceof Compressor)) {
                throw new IllegalArgumentException(CliStrings.format("{0} is an invalid Compressor.", new Object[]{regionFunctionArgs.getCompressor()}));
            }
        }
        if (regionFunctionArgs.hasPartitionAttributes() && regionFunctionArgs.isPartitionResolverSet().booleanValue()) {
            String partitionResolverClassName = regionFunctionArgs.getPartitionResolver();
            try {
                Class<?> resolverClass = ClassPathLoader.getLatest().forName(partitionResolverClassName);
                PartitionResolver partitionResolver = (PartitionResolver)resolverClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(CliStrings.format("{0} is an invalid Partition Resolver.", new Object[]{regionFunctionArgs.getCompressor()}), e);
            }
        }
    }

    private boolean diskStoreExists(InternalCache cache, String diskStoreName) {
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Map<String, String[]> diskstore = dsMXBean.listMemberDiskstore();
        Set<Map.Entry<String, String[]>> entrySet = diskstore.entrySet();
        for (Map.Entry<String, String[]> entry : entrySet) {
            Object[] value = entry.getValue();
            if (!CliUtil.contains(value, diskStoreName)) continue;
            return true;
        }
        return false;
    }

    private static <K, V> FetchRegionAttributesFunction.FetchRegionAttributesFunctionResult<K, V> getRegionAttributes(InternalCache cache, String regionPath) {
        DistributedMember distributedMember;
        ResultCollector<?, ?> resultCollector;
        List resultsList;
        Set<DistributedMember> regionAssociatedMembers;
        if (!CreateAlterDestroyRegionCommands.isClusterWideSameConfig(cache, regionPath)) {
            throw new IllegalStateException(CliStrings.format("The region mentioned for \"template-region\" exists in this Geode Cluster but with different Scopes or Data Policies on different members. For details, use command \"describe region\" for \"{0}\".", (Object)regionPath));
        }
        FetchRegionAttributesFunction.FetchRegionAttributesFunctionResult attributes = null;
        try {
            attributes = FetchRegionAttributesFunction.getRegionAttributes(regionPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (attributes == null && (regionAssociatedMembers = CliUtil.getRegionAssociatedMembers(regionPath, cache, false)) != null && !regionAssociatedMembers.isEmpty() && (resultsList = (List)(resultCollector = CliUtil.executeFunction((Function)FetchRegionAttributesFunction.INSTANCE, (Object)regionPath, distributedMember = regionAssociatedMembers.iterator().next())).getResult()) != null && !resultsList.isEmpty()) {
            for (Object object : resultsList) {
                if (object instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)object;
                }
                if (object instanceof Throwable) {
                    Throwable th = (Throwable)object;
                    LogWrapper.getInstance().info(CliUtil.stackTraceAsString(th));
                    throw new IllegalArgumentException(CliStrings.format("Could not retrieve region attributes for given path \"{0}\". Reason: {1}", regionPath, th.getMessage()));
                }
                FetchRegionAttributesFunction.FetchRegionAttributesFunctionResult regAttr = (FetchRegionAttributesFunction.FetchRegionAttributesFunctionResult)object;
                if (attributes != null) continue;
                attributes = regAttr;
                break;
            }
        }
        return attributes;
    }

    private static boolean isClusterWideSameConfig(InternalCache cache, String regionPath) {
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Set<DistributedMember> allMembers = CliUtil.getAllNormalMembers(cache);
        RegionAttributesData regionAttributesToValidateAgainst = null;
        for (DistributedMember distributedMember : allMembers) {
            try {
                ObjectName regionObjectName = dsMXBean.fetchRegionObjectName(CliUtil.getMemberNameOrId(distributedMember), regionPath);
                RegionMXBean regionMBean = managementService.getMBeanInstance(regionObjectName, RegionMXBean.class);
                RegionAttributesData regionAttributes = regionMBean.listRegionAttributes();
                if (regionAttributesToValidateAgainst == null) {
                    regionAttributesToValidateAgainst = regionAttributes;
                    continue;
                }
                if (regionAttributesToValidateAgainst.getScope().equals(regionAttributes.getScope()) || regionAttributesToValidateAgainst.getDataPolicy().equals(regionAttributes.getDataPolicy())) continue;
                return false;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    private boolean isClassNameValid(String fqcn) {
        if (fqcn.isEmpty()) {
            return true;
        }
        String regex = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*";
        return Pattern.matches(regex, fqcn);
    }

    @CliCommand(value={"destroy region"}, help="Destroy/Remove a region.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyRegion(@CliOption(key={"name"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Name/Path of the region to be removed.") String regionPath) {
        Result result;
        if (regionPath == null) {
            return ResultBuilder.createInfoResult("Please specify region path for the region to be destroyed.");
        }
        if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
            return ResultBuilder.createInfoResult(CliStrings.format("Region path \"{0}\" is not valid.", new Object[]{regionPath}));
        }
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        try {
            Set<DistributedMember> regionMembersList;
            InternalCache cache = this.getCache();
            ManagementService managementService = ManagementService.getExistingManagementService(cache);
            String regionPathToUse = regionPath;
            if (!regionPathToUse.startsWith("/")) {
                regionPathToUse = "/" + regionPathToUse;
            }
            if ((regionMembersList = this.findMembersForRegion(cache, managementService, regionPathToUse)).size() == 0) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Could not find a Region with Region path \"{0}\" in this Geode cluster. If region was recently created, please wait for at least {1} to allow the associated Management resources to be federated.", regionPath, "jmx-manager-update-rate milliseconds"));
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)RegionDestroyFunction.INSTANCE, (Object)regionPath, regionMembersList);
            List resultsList = (List)resultCollector.getResult();
            String message = CliStrings.format("\"{0}\" {1} destroyed successfully.", regionPath, "");
            boolean isRegionDestroyed = true;
            for (CliFunctionResult aResultsList : resultsList) {
                CliFunctionResult destroyRegionResult = aResultsList;
                if (destroyRegionResult.isSuccessful()) {
                    xmlEntity.set(destroyRegionResult.getXmlEntity());
                    continue;
                }
                if (destroyRegionResult.getThrowable() != null) {
                    Throwable t = destroyRegionResult.getThrowable();
                    LogWrapper.getInstance().info(t.getMessage(), t);
                    message = CliStrings.format("Error occurred while destroying region \"{0}\". Reason: {1}", regionPath, t.getMessage());
                    isRegionDestroyed = false;
                    continue;
                }
                message = CliStrings.format("Unknown result while destroying region \"{0}\". Reason: {1}", regionPath, destroyRegionResult.getMessage());
                isRegionDestroyed = false;
            }
            result = isRegionDestroyed ? ResultBuilder.createInfoResult(message) : ResultBuilder.createUserErrorResult(message);
        }
        catch (IllegalStateException e) {
            result = ResultBuilder.createUserErrorResult(CliStrings.format("Error while destroying region {0}. Reason: {1}", regionPath, e.getMessage()));
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error while destroying region {0}. Reason: {1}", regionPath, e.getMessage()));
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity((XmlEntity)xmlEntity.get(), null));
        }
        return result;
    }

    private Set<DistributedMember> findMembersForRegion(InternalCache cache, ManagementService managementService, String regionPath) {
        Set<DistributedMember> membersList = new HashSet<DistributedMember>();
        HashSet<String> regionMemberIds = new HashSet<String>();
        MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
        if (regionPath.contains("-")) {
            regionPath = "\"" + regionPath + "\"";
        }
        String queryExp = MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", regionPath, "*");
        try {
            ObjectName queryExpON = new ObjectName(queryExp);
            Set<ObjectName> queryNames = mbeanServer.queryNames(null, queryExpON);
            if (queryNames == null || queryNames.isEmpty()) {
                return membersList;
            }
            boolean addedOneRemote = false;
            for (ObjectName regionMBeanObjectName : queryNames) {
                try {
                    RegionMXBean regionMXBean = managementService.getMBeanInstance(regionMBeanObjectName, RegionMXBean.class);
                    if (regionMXBean == null) continue;
                    RegionAttributesData regionAttributes = regionMXBean.listRegionAttributes();
                    String scope = regionAttributes.getScope();
                    if (Scope.LOCAL.equals(Scope.fromString(scope))) {
                        regionMemberIds.add(regionMXBean.getMember());
                        continue;
                    }
                    if (addedOneRemote) continue;
                    regionMemberIds.add(regionMXBean.getMember());
                    addedOneRemote = true;
                }
                catch (ClassCastException e) {
                    LogWriter logger = cache.getLogger();
                    if (!logger.finerEnabled()) continue;
                    logger.finer(regionMBeanObjectName + " is not a " + RegionMXBean.class.getSimpleName(), e);
                }
            }
            if (!regionMemberIds.isEmpty()) {
                membersList = this.getMembersByIds(cache, regionMemberIds);
            }
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
        }
        return membersList;
    }

    private Set<DistributedMember> getMembersByIds(InternalCache cache, Set<String> memberIds) {
        Set<DistributedMember> foundMembers = Collections.emptySet();
        if (memberIds != null && !memberIds.isEmpty()) {
            foundMembers = new HashSet<DistributedMember>();
            Set<DistributedMember> allNormalMembers = CliUtil.getAllNormalMembers(cache);
            for (String memberId : memberIds) {
                for (DistributedMember distributedMember : allNormalMembers) {
                    if (!memberId.equals(distributedMember.getId()) && !memberId.equals(distributedMember.getName())) continue;
                    foundMembers.add(distributedMember);
                }
            }
        }
        return foundMembers;
    }

    @CliAvailabilityIndicator(value={"alter region", "create region", "destroy region"})
    public boolean isRegionCommandAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    static {
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_PERSISTENT);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_REDUNDANT_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_PERSISTENT_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.REPLICATE_PERSISTENT);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.REPLICATE_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.REPLICATE_PERSISTENT_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.LOCAL_PERSISTENT);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.LOCAL_OVERFLOW);
        PERSISTENT_OVERFLOW_SHORTCUTS.add(RegionShortcut.LOCAL_PERSISTENT_OVERFLOW);
    }
}

