/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management;

import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;

@ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
public interface GatewaySenderMXBean {
    public String getSenderId();

    public int getRemoteDSId();

    public int getSocketBufferSize();

    public long getSocketReadTimeout();

    public String getOverflowDiskStoreName();

    public int getMaximumQueueMemory();

    public int getBatchSize();

    public long getBatchTimeInterval();

    public boolean isBatchConflationEnabled();

    public boolean isPersistenceEnabled();

    public int getAlertThreshold();

    public String[] getGatewayEventFilters();

    public String[] getGatewayTransportFilters();

    public boolean isManualStart();

    public boolean isRunning();

    public boolean isPaused();

    public float getEventsReceivedRate();

    public float getEventsQueuedRate();

    public int getEventQueueSize();

    public int getTotalEventsConflated();

    public float getBatchesDispatchedRate();

    public long getAverageDistributionTimePerBatch();

    public int getTotalBatchesRedistributed();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void start();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void stop();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void pause();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void resume();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void rebalance();

    public boolean isPrimary();

    public int getDispatcherThreads();

    public String getOrderPolicy();

    public boolean isDiskSynchronous();

    public boolean isParallel();

    public String getGatewayReceiver();

    public boolean isConnected();

    public int getEventsExceedingAlertThreshold();
}

