/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.lang.ObjectUtils;

public abstract class IOUtils {
    public static final int BUFFER_SIZE = 4096;

    public static String appendToPath(String pathname, String ... pathElements) {
        if (pathElements != null) {
            pathname = StringUtils.defaultIfBlank((String)pathname, (String)File.separator);
            for (String pathElement : pathElements) {
                pathname = pathname + (pathname.endsWith(File.separator) ? "" : File.separator);
                pathname = pathname + pathElement;
            }
        }
        return pathname;
    }

    public static void close(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String createPath(String ... pathElements) {
        return IOUtils.createPath(pathElements, File.separator);
    }

    public static String createPath(String[] pathElements, String separator) {
        separator = ObjectUtils.defaultIfNull(separator, File.separator);
        StringBuilder buffer = new StringBuilder();
        for (String pathElement : pathElements) {
            buffer.append(separator).append(pathElement);
        }
        return buffer.toString();
    }

    public static Object deserializeObject(byte[] objBytes) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objIn = null;
        try {
            objIn = new ObjectInputStream(new ByteArrayInputStream(objBytes));
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.close(objIn);
            throw throwable;
        }
        IOUtils.close(objIn);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(byte[] objBytes, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object object;
        ClassLoaderObjectInputStream objIn = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(objBytes);
            objIn = new ClassLoaderObjectInputStream(bis, loader);
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.close(objIn);
            throw throwable;
        }
        IOUtils.close(objIn);
        return object;
    }

    public static String getFilename(String pathname) {
        String filename = pathname;
        if (StringUtils.isNotBlank((String)filename)) {
            int index = filename.lastIndexOf(File.separator);
            filename = index == -1 ? filename : filename.substring(index + 1);
        }
        return filename;
    }

    public static boolean isExistingPathname(String pathname) {
        return StringUtils.isNotBlank((String)pathname) && new File(pathname).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Object obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(out);
            objOut.writeObject(obj);
            objOut.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(objOut);
            throw throwable;
        }
        IOUtils.close(objOut);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        assert (in != null) : "The input stream to read bytes from cannot be null!";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                out.flush();
            }
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
        return out.toByteArray();
    }

    public static File tryGetCanonicalFileElseGetAbsoluteFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static String tryGetCanonicalPathElseGetAbsolutePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static String verifyPathnameExists(String pathname) throws FileNotFoundException {
        if (IOUtils.isExistingPathname(pathname)) {
            return pathname;
        }
        throw new FileNotFoundException(String.format("Pathname (%1$s) could not be found!", pathname));
    }

    protected static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader loader;

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            if (loader == null) {
                throw new NullPointerException("The ClassLoader used by this ObjectInputStream to resolve Class types for serialized Objects cannot be null!");
            }
            this.loader = loader;
        }

        protected ClassLoader getClassLoader() {
            return this.loader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass descriptor) throws IOException, ClassNotFoundException {
            return Class.forName(descriptor.getName(), false, this.getClassLoader());
        }
    }
}

