/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.statistics.HostStatHelper;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.geode.internal.statistics.platform.ProcessStats;

public class LinuxProcessStats {
    static final int imageSizeINT = 0;
    static final int rssSizeINT = 1;
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private LinuxProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    public static ProcessStats createProcessStats(final Statistics stats) {
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refresh((LocalStatisticsImpl)stats);
        }
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return stats.getInt(1);
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("LinuxProcessStats", "Statistics on a Linux process.", new StatisticDescriptor[]{f.createIntGauge("imageSize", "The size of the process's image in megabytes.", "megabytes"), f.createIntGauge("rssSize", "The size of the process's resident set size in megabytes. (assumes PAGESIZE=4096, specify -Dgemfire.statistics.linux.pageSize=<pagesize> to adjust)", "megabytes")});
        LinuxProcessStats.checkOffset("imageSize", 0);
        LinuxProcessStats.checkOffset("rssSize", 1);
    }
}

