/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.CancelCriterion;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.AbstractStatisticsFactory;
import org.apache.geode.internal.statistics.DummyStatisticsImpl;
import org.apache.geode.internal.statistics.SimpleStatSampler;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LocalStatisticsFactory
extends AbstractStatisticsFactory
implements StatisticsFactory,
StatisticsManager {
    private static final Logger logger = LogService.getLogger();
    public static final String STATS_DISABLE_NAME_PROPERTY = "stats.disable";
    private final SimpleStatSampler sampler;
    private final boolean statsDisabled = Boolean.getBoolean("stats.disable");

    public LocalStatisticsFactory(CancelCriterion stopper) {
        super(LocalStatisticsFactory.initId(), LocalStatisticsFactory.initName(), LocalStatisticsFactory.initStartTime());
        if (this.statsDisabled) {
            this.sampler = null;
            logger.info(LogMarker.STATISTICS, (Message)LocalizedMessage.create(LocalizedStrings.LocalStatisticsFactory_STATISTIC_COLLECTION_IS_DISABLED_USE_DSTATSDISABLEFALSE_TO_TURN_ON_STATISTICS));
        } else if (stopper != null) {
            this.sampler = new SimpleStatSampler(stopper, this);
            this.sampler.start();
        } else {
            this.sampler = null;
        }
    }

    protected static long initId() {
        return Thread.currentThread().hashCode();
    }

    protected static String initName() {
        return System.getProperty("stats.name", Thread.currentThread().getName());
    }

    protected static long initStartTime() {
        return System.currentTimeMillis();
    }

    protected SimpleStatSampler getStatSampler() {
        return this.sampler;
    }

    @Override
    public void close() {
        if (this.sampler != null) {
            this.sampler.stop();
        }
    }

    @Override
    protected Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        return super.createOsStatistics(type, textId, numericId, osStatFlags);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        return super.createAtomicStatistics(type, textId, numericId);
    }
}

