/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.logging.DateFormatter;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.Transition;
import org.apache.geode.internal.sequencelog.io.OutputStreamAppender;

public class GemfireLogConverter {
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d).(\\d\\d\\d)");
    private static final Pattern ALL = Pattern.compile(".*");
    private static ArrayList<Test> tests = GemfireLogConverter.buildTests();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFiles(OutputStream output, File[] files) throws IOException {
        Context context = new Context();
        context.appender = new OutputStreamAppender(output);
        for (File file : files) {
            context.currentMember = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    for (Test test : tests) {
                        if (test.apply(context, line)) break;
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            GemfireLogConverter.usage();
            System.exit(1);
        }
        File outputFile = new File(args[0]);
        File[] files = new File[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            File file;
            String fileName = args[i];
            files[i - 1] = file = new File(fileName);
        }
        GemfireLogConverter.convertFiles(new BufferedOutputStream(new FileOutputStream(outputFile)), files);
    }

    private static ArrayList<Test> buildTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        tests.add(new Test("Starting DistributionManager (.*)\\."){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String member = matcher.group(1);
                context.currentMember = member;
                context.appender.write(new Transition(timestamp, GraphType.MEMBER, "member", "start", "running", member, member));
            }
        });
        tests.add(new Test("Member at (.*) unexpectedly left the distributed cache"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String member = matcher.group(1);
                context.appender.write(new Transition(timestamp, GraphType.MEMBER, "member", "crashed", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.REGION, ALL, "crash", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.KEY, ALL, "crash", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.MESSAGE, ALL, "crash", "destroyed", member, member));
            }
        });
        tests.add(new Test("VM is exiting - shutting down distributed system"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String member = context.currentMember;
                context.appender.write(new Transition(timestamp, GraphType.MEMBER, "member", "stop", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.REGION, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.KEY, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.MESSAGE, ALL, "destroy", "destroyed", member, member));
            }
        });
        tests.add(new Test("GemFireCache .*Now closing"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String member = context.currentMember;
                context.appender.write(new Transition(timestamp, GraphType.MEMBER, "member", "stop", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.REGION, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.KEY, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.MESSAGE, ALL, "destroy", "destroyed", member, member));
            }
        });
        tests.add(new Test("Shutting down DistributionManager"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String member = context.currentMember;
                context.appender.write(new Transition(timestamp, GraphType.MEMBER, "member", "stop", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.REGION, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.KEY, ALL, "destroy", "destroyed", member, member));
                context.appender.write(new Transition(timestamp, GraphType.MESSAGE, ALL, "destroy", "destroyed", member, member));
            }
        });
        tests.add(new Test("initializing region (.*)"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "create", "created", context.currentMember, context.currentMember));
            }
        });
        tests.add(new Test("Partitioned Region /(.*) is created with"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "create", "created", context.currentMember, context.currentMember));
            }
        });
        tests.add(new Test(" Region (.*) requesting initial image from (.*)"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                String source = matcher.group(2);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "GII", "created", source, context.currentMember));
            }
        });
        tests.add(new Test(" Region (.*) initialized persistent id: .* diskStoreId (.*) with data from "){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                String store = matcher.group(2);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "persist", "persisted", context.currentMember, store));
            }
        });
        tests.add(new Test(" Region /__PR/(.*) was created on this member with the persistent id .* diskStoreId (.*)\\."){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                String store = matcher.group(2);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "persist", "persisted", context.currentMember, store));
            }
        });
        tests.add(new Test(" Region /__PR/(.*) recovered from the local disk. .* new persistent ID.*diskStoreId (.*)"){

            @Override
            public void process(Context context, long timestamp, Matcher matcher) throws IOException {
                String region = matcher.group(1);
                String store = matcher.group(2);
                context.appender.write(new Transition(timestamp, GraphType.REGION, region, "recover", "created", store, context.currentMember));
            }
        });
        return tests;
    }

    private static long extractDate(String line) {
        Matcher matcher = DATE_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IllegalStateException("Could not parse timestamp from line " + line);
        }
        matcher.start();
        DateFormat formatter = DateFormatter.createDateFormat();
        Date date = formatter.parse(line, new ParsePosition(matcher.start()));
        return date.getTime();
    }

    private static void usage() {
        System.err.println("Usage java org.apache.sequence.logconversion.ConvertGemfireLogs outputfile [log_file]+");
    }

    private static class Context {
        private OutputStreamAppender appender;
        private String currentMember;

        private Context() {
        }
    }

    private static abstract class Test {
        private Pattern pattern;

        public Test(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean apply(Context context, String line) throws IOException {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                long timestamp = GemfireLogConverter.extractDate(line);
                this.process(context, timestamp, matcher);
                return true;
            }
            return false;
        }

        public abstract void process(Context var1, long var2, Matcher var4) throws IOException;
    }
}

