/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public interface SecurityService {
    public ThreadState bindSubject(Subject var1);

    public Subject getSubject();

    public Subject login(Properties var1);

    public void logout();

    public Callable associateWith(Callable var1);

    public void authorize(ResourceOperation var1);

    public void authorizeClusterManage();

    public void authorizeClusterWrite();

    public void authorizeClusterRead();

    public void authorizeDataManage();

    public void authorizeDataWrite();

    public void authorizeDataRead();

    public void authorizeRegionManage(String var1);

    public void authorizeRegionManage(String var1, String var2);

    public void authorizeRegionWrite(String var1);

    public void authorizeRegionWrite(String var1, String var2);

    public void authorizeRegionRead(String var1);

    public void authorizeRegionRead(String var1, String var2);

    public void authorize(String var1, String var2);

    public void authorize(String var1, String var2, String var3);

    public void authorize(String var1, String var2, String var3, String var4);

    public void authorize(ResourcePermission var1);

    public void initSecurity(Properties var1);

    public void close();

    public boolean needPostProcess();

    public Object postProcess(String var1, Object var2, Object var3, boolean var4);

    public Object postProcess(Object var1, String var2, Object var3, Object var4, boolean var5);

    public boolean isClientSecurityRequired();

    public boolean isIntegratedSecurity();

    public boolean isPeerSecurityRequired();

    public SecurityManager getSecurityManager();

    public void setSecurityManager(SecurityManager var1);

    public PostProcessor getPostProcessor();

    public void setPostProcessor(PostProcessor var1);

    public static <T> T getObjectOfTypeFromClassName(String className, Class<T> expectedClazz) {
        Class actualClass = null;
        try {
            actualClass = ClassLoadUtil.classFromName(className);
        }
        catch (Exception ex) {
            throw new GemFireSecurityException("Instance could not be obtained, " + ex.toString(), ex);
        }
        if (!expectedClazz.isAssignableFrom(actualClass)) {
            throw new GemFireSecurityException("Instance could not be obtained. Expecting a " + expectedClazz.getName() + " class.");
        }
        T actualObject = null;
        try {
            actualObject = actualClass.newInstance();
        }
        catch (Exception e) {
            throw new GemFireSecurityException("Instance could not be obtained. Error instantiating " + actualClass.getName(), e);
        }
        return actualObject;
    }

    public static <T> T getObjectOfTypeFromFactoryMethod(String factoryMethodName, Class<T> expectedClazz) {
        Object actualObject = null;
        try {
            Method factoryMethod = ClassLoadUtil.methodFromName(factoryMethodName);
            actualObject = factoryMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new GemFireSecurityException("Instance could not be obtained from " + factoryMethodName, e);
        }
        if (actualObject == null) {
            throw new GemFireSecurityException("Instance could not be obtained from " + factoryMethodName);
        }
        return (T)actualObject;
    }

    public static <T> T getObjectOfType(String classOrMethod, Class<T> expectedClazz) {
        T object = null;
        try {
            object = SecurityService.getObjectOfTypeFromClassName(classOrMethod, expectedClazz);
        }
        catch (Exception e) {
            object = SecurityService.getObjectOfTypeFromFactoryMethod(classOrMethod, expectedClazz);
        }
        return object;
    }

    public static Properties getCredentials(Properties securityProps) {
        Properties credentials = null;
        if (securityProps.containsKey("security-username") && securityProps.containsKey("security-password")) {
            credentials = new Properties();
            credentials.setProperty("security-username", securityProps.getProperty("security-username"));
            credentials.setProperty("security-password", securityProps.getProperty("security-password"));
        }
        return credentials;
    }

    public static SecurityService getSecurityService() {
        return IntegratedSecurityService.getSecurityService();
    }
}

