/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.ObjectWithAuthz;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;

public class FilterPostAuthorization
implements AccessControl {
    private String principalName = null;
    private LogWriterI18n logger = null;

    public static AccessControl create() {
        return new FilterPostAuthorization();
    }

    @Override
    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        this.principalName = principal == null ? "" : principal.getName();
        this.logger = cache.getSecurityLoggerI18n();
    }

    private byte[] checkObjectAuth(byte[] serializedObj, boolean isObject) {
        Object obj;
        if (!isObject) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(serializedObj);
        DataInputStream dis = new DataInputStream(bis);
        try {
            obj = DataSerializer.readObject(dis);
            if (this.logger.finerEnabled()) {
                this.logger.finer("FilterPostAuthorization: successfully read object from serialized object: " + obj);
            }
        }
        catch (Exception ex) {
            this.logger.severe(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_AN_EXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE, ex);
            return null;
        }
        obj = this.checkObjectAuth(obj);
        if (obj != null) {
            HeapDataOutputStream hos = new HeapDataOutputStream(serializedObj.length + 32, Version.CURRENT);
            try {
                DataSerializer.writeObject(obj, hos);
                return hos.toByteArray();
            }
            catch (Exception ex) {
                this.logger.severe(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_AN_EXCEPTION_WAS_THROWN_WHILE_TRYING_TO_SERIALIZE, ex);
            }
        }
        return null;
    }

    private Object checkObjectAuth(Object value) {
        Object obj = value;
        if (value instanceof CqEntry) {
            obj = ((CqEntry)value).getValue();
        }
        if (obj instanceof ObjectWithAuthz) {
            int lastChar = this.principalName.charAt(this.principalName.length() - 1) - 48;
            ObjectWithAuthz authzObj = (ObjectWithAuthz)obj;
            int authzIndex = (Integer)authzObj.getAuthz() - 48;
            if ((lastChar %= 10) == 0 || (authzIndex %= 10) % lastChar != 0) {
                this.logger.warning(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_THE_USER_0_IS_NOT_AUTHORIZED_FOR_THE_OBJECT_1, new Object[]{this.principalName, authzObj.getVal()});
                return null;
            }
            if (this.logger.fineEnabled()) {
                this.logger.fine("FilterPostAuthorization: user [" + this.principalName + "] authorized for object: " + authzObj.getVal());
            }
            if (value instanceof CqEntry) {
                return new CqEntry(((CqEntry)value).getKey(), authzObj.getVal());
            }
            return authzObj.getVal();
        }
        this.logger.warning(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_THE_OBJECT_OF_TYPE_0_IS_NOT_AN_INSTANCE_OF_1, new Object[]{obj.getClass(), ObjectWithAuthz.class});
        return null;
    }

    @Override
    public boolean authorizeOperation(String regionName, OperationContext context) {
        assert (context.isPostOperation());
        OperationContext.OperationCode opCode = context.getOperationCode();
        if (opCode.isGet()) {
            GetOperationContext getContext = (GetOperationContext)context;
            Object value = getContext.getObject();
            boolean isObject = getContext.isObject();
            if (value != null) {
                if ((value = this.checkObjectAuth(value)) != null) {
                    getContext.setObject(value, isObject);
                    return true;
                }
            } else {
                byte[] serializedValue = getContext.getSerializedValue();
                if ((serializedValue = this.checkObjectAuth(serializedValue, isObject)) != null) {
                    getContext.setSerializedValue(serializedValue, isObject);
                    return true;
                }
            }
        } else if (opCode.isPut()) {
            PutOperationContext putContext = (PutOperationContext)context;
            byte[] serializedValue = putContext.getSerializedValue();
            boolean isObject = putContext.isObject();
            if ((serializedValue = this.checkObjectAuth(serializedValue, isObject)) != null) {
                putContext.setSerializedValue(serializedValue, isObject);
                return true;
            }
        } else if (!opCode.equals((Object)OperationContext.OperationCode.PUTALL) && (opCode.isQuery() || opCode.isExecuteCQ())) {
            QueryOperationContext queryContext = (QueryOperationContext)context;
            Object value = queryContext.getQueryResult();
            if (value instanceof SelectResults) {
                SelectResults results = (SelectResults)value;
                ArrayList newResults = new ArrayList();
                for (Object obj : results) {
                    if ((obj = this.checkObjectAuth(obj)) == null) continue;
                    newResults.add(obj);
                }
                if (results.isModifiable()) {
                    results.clear();
                    results.addAll(newResults);
                } else {
                    ObjectType constraint = results.getCollectionType().getElementType();
                    results = new ResultsCollectionWrapper(constraint, newResults);
                    queryContext.setQueryResult(results);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void close() {
        this.principalName = null;
    }

    static {
        Instantiator.register(new Instantiator(ObjectWithAuthz.class, 57){

            @Override
            public DataSerializable newInstance() {
                return new ObjectWithAuthz();
            }
        }, false);
    }
}

