/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.LocalProcessLauncher;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessType;
import org.apache.logging.log4j.Logger;

public class ControllableProcess {
    private static final Logger logger = LogService.getLogger();
    private final File directory;
    private final LocalProcessLauncher launcher;
    private final ControlFileWatchdog stopRequestFileWatchdog;
    private final ControlFileWatchdog statusRequestFileWatchdog;

    public ControllableProcess(ControlNotificationHandler handler, File directory, ProcessType processType, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, force, ControllableProcess.createPidFile(directory, processType), ControllableProcess.createStopHandler(handler), ControllableProcess.createStatusHandler(handler, directory, processType));
    }

    private ControllableProcess(File directory, ProcessType processType, boolean force, File pidFile, ControlFileWatchdog.ControlRequestHandler stopHandler, ControlFileWatchdog.ControlRequestHandler statusHandler) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, ControllableProcess.createLocalProcessLauncher(pidFile, force), ControllableProcess.createStopRequestFileWatchdog(directory, processType, stopHandler), ControllableProcess.createStatusRequestFileWatchdog(directory, processType, statusHandler));
    }

    ControllableProcess(File directory, ProcessType processType, LocalProcessLauncher launcher, ControlFileWatchdog stopRequestFileWatchdog, ControlFileWatchdog statusRequestFileWatchdog) {
        Validate.notNull((Object)directory, (String)("Invalid directory '" + directory + "' specified"));
        Validate.notNull((Object)((Object)processType), (String)("Invalid processType '" + (Object)((Object)processType) + "' specified"));
        Validate.notNull((Object)launcher, (String)("Invalid launcher '" + launcher + "' specified"));
        Validate.notNull((Object)stopRequestFileWatchdog, (String)("Invalid stopRequestFileWatchdog '" + stopRequestFileWatchdog + "' specified"));
        Validate.notNull((Object)statusRequestFileWatchdog, (String)("Invalid statusRequestFileWatchdog '" + statusRequestFileWatchdog + "' specified"));
        this.directory = directory;
        this.launcher = launcher;
        this.stopRequestFileWatchdog = stopRequestFileWatchdog;
        this.statusRequestFileWatchdog = statusRequestFileWatchdog;
        this.deleteFiles(directory, processType);
        stopRequestFileWatchdog.start();
        statusRequestFileWatchdog.start();
    }

    public int getPid() {
        return this.launcher.getPid();
    }

    public File getPidFile() {
        return this.launcher.getPidFile();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void stop() {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close();
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stop(boolean deletePidFileOnStop) {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close(deletePidFileOnStop);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean stop(ControlFileWatchdog fileWatchdog) {
        boolean interrupted = false;
        try {
            fileWatchdog.stop();
        }
        catch (InterruptedException e) {
            interrupted = true;
            logger.warn("Interrupted while stopping status handler for controllable process.", (Throwable)e);
        }
        return interrupted;
    }

    private void deleteFiles(File directory, ProcessType processType) {
        this.deleteFile(directory, processType.getStatusRequestFileName());
        this.deleteFile(directory, processType.getStatusFileName());
        this.deleteFile(directory, processType.getStopRequestFileName());
    }

    private void deleteFile(File directory, String fileName) {
        File file = new File(directory, fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    private static File createPidFile(File directory, ProcessType processType) {
        return new File(directory, processType.getPidFileName());
    }

    private static LocalProcessLauncher createLocalProcessLauncher(File pidFile, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        return new LocalProcessLauncher(pidFile, force);
    }

    private static ControlFileWatchdog.ControlRequestHandler createStopHandler(ControlNotificationHandler handler) {
        return handler::handleStop;
    }

    private static ControlFileWatchdog.ControlRequestHandler createStatusHandler(ControlNotificationHandler handler, File directory, ProcessType processType) {
        return () -> {
            File statusFileTmp;
            AbstractLauncher.ServiceState<?> state = handler.handleStatus();
            File statusFile = new File(directory, processType.getStatusFileName());
            if (statusFile.exists()) {
                boolean deleted = statusFile.delete();
                assert (deleted);
            }
            if ((statusFileTmp = new File(directory, processType.getStatusFileName() + ".tmp")).exists()) {
                boolean deleted = statusFileTmp.delete();
                assert (deleted);
            }
            boolean created = statusFileTmp.createNewFile();
            assert (created);
            FileWriter writer = new FileWriter(statusFileTmp);
            writer.write(state.toJson());
            writer.flush();
            writer.close();
            boolean renamed = statusFileTmp.renameTo(statusFile);
            assert (renamed);
        };
    }

    private static ControlFileWatchdog createStopRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler stopHandler) {
        return new ControlFileWatchdog(directory, processType.getStopRequestFileName(), stopHandler, false);
    }

    private static ControlFileWatchdog createStatusRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler statusHandler) {
        return new ControlFileWatchdog(directory, processType.getStatusRequestFileName(), statusHandler, false);
    }
}

