/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;
import org.apache.geode.internal.stats50.Atomic50StatisticsImpl;

public class Atomics {
    private static final boolean STRIPED_STATS_DISABLED = Boolean.getBoolean("gemfire.STRIPED_STATS_DISABLED") || "IBM Corporation".equals(System.getProperty("java.vm.vendor", "unknown"));

    private Atomics() {
    }

    public static Statistics createAtomicStatistics(StatisticsType type, String textId, long nId, long uId, StatisticsManager mgr) {
        StatisticsImpl result = null;
        result = ((StatisticsTypeImpl)type).getDoubleStatCount() == 0 && !STRIPED_STATS_DISABLED ? new Atomic50StatisticsImpl(type, textId, nId, uId, mgr) : new LocalStatisticsImpl(type, textId, nId, uId, true, 0, mgr);
        return result;
    }

    public static boolean setIfGreater(AtomicLong atom, long update) {
        long cur;
        while (update > (cur = atom.get())) {
            if (!atom.compareAndSet(cur, update)) continue;
            return true;
        }
        return false;
    }
}

