/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tx.DistTxKeyInfo;
import org.apache.geode.internal.cache.versions.VersionTag;

public class DistTxEntryEvent
extends EntryEventImpl {
    protected static final byte HAS_PUTALL_OP = 1;
    protected static final byte HAS_REMOVEALL_OP = 2;

    public DistTxEntryEvent(EntryEventImpl entry) {
        super(entry);
    }

    public DistTxEntryEvent() {
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return 2166;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.eventID, out);
        DataSerializer.writeObject(this.region.getFullPath(), out);
        out.writeByte(this.op.ordinal);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeInteger(this.keyInfo.getBucketId(), out);
        DataSerializer.writeObject(this.basicGetNewValue(), out);
        byte flags = 0;
        if (this.putAllOp != null) {
            flags = (byte)(flags | 1);
        }
        if (this.removeAllOp != null) {
            flags = (byte)(flags | 2);
        }
        DataSerializer.writeByte(flags, out);
        if (this.putAllOp != null) {
            this.putAllToData(out);
        }
        if (this.removeAllOp != null) {
            this.removeAllToData(out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.eventID = (EventID)DataSerializer.readObject(in);
        String regionName = DataSerializer.readString(in);
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        this.region = (LocalRegion)cache.getRegion(regionName);
        this.op = Operation.fromOrdinal(in.readByte());
        Object key = DataSerializer.readObject(in);
        Integer bucketId = DataSerializer.readInteger(in);
        this.keyInfo = new DistTxKeyInfo(key, null, null, bucketId);
        this.basicSetNewValue(DataSerializer.readObject(in));
        byte flags = DataSerializer.readByte(in);
        if ((flags & 1) != 0) {
            this.putAllFromData(in);
        }
        if ((flags & 2) != 0) {
            this.removeAllFromData(in);
        }
    }

    private void putAllToData(DataOutput out) throws IOException {
        DataSerializer.writeInteger(this.putAllOp.putAllDataSize, out);
        DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllOp.putAllDataSize);
        boolean hasTags = false;
        DistributedPutAllOperation.PutAllEntryData[] putAllData = this.putAllOp.getPutAllEntryData();
        for (int i = 0; i < this.putAllOp.putAllDataSize; ++i) {
            if (!hasTags && putAllData[i].versionTag != null) {
                hasTags = true;
            }
            VersionTag tag = putAllData[i].versionTag;
            versionTags.add(tag);
            putAllData[i].versionTag = null;
            putAllData[i].toData(out);
            putAllData[i].versionTag = tag;
        }
        out.writeBoolean(hasTags);
        if (hasTags) {
            InternalDataSerializer.invokeToData(versionTags, out);
        }
    }

    private void putAllFromData(DataInput in) throws IOException, ClassNotFoundException {
        int putAllSize = DataSerializer.readInteger(in);
        DistributedPutAllOperation.PutAllEntryData[] putAllEntries = new DistributedPutAllOperation.PutAllEntryData[putAllSize];
        if (putAllSize > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < putAllSize; ++i) {
                putAllEntries[i] = new DistributedPutAllOperation.PutAllEntryData(in, this.eventID, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < putAllSize; ++i) {
                    putAllEntries[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
        EntryEventImpl e = EntryEventImpl.create(this.region, Operation.PUTALL_CREATE, null, null, null, true, this.getDistributedMember(), true, true);
        this.putAllOp = new DistributedPutAllOperation(e, putAllSize, false);
        this.putAllOp.setPutAllEntryData(putAllEntries);
    }

    private void removeAllToData(DataOutput out) throws IOException {
        DataSerializer.writeInteger(this.removeAllOp.removeAllDataSize, out);
        DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllOp.removeAllDataSize);
        boolean hasTags = false;
        DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData = this.removeAllOp.getRemoveAllEntryData();
        for (int i = 0; i < this.removeAllOp.removeAllDataSize; ++i) {
            if (!hasTags && removeAllData[i].versionTag != null) {
                hasTags = true;
            }
            VersionTag tag = removeAllData[i].versionTag;
            versionTags.add(tag);
            removeAllData[i].versionTag = null;
            removeAllData[i].toData(out);
            removeAllData[i].versionTag = tag;
        }
        out.writeBoolean(hasTags);
        if (hasTags) {
            InternalDataSerializer.invokeToData(versionTags, out);
        }
    }

    private void removeAllFromData(DataInput in) throws IOException, ClassNotFoundException {
        int removeAllSize = DataSerializer.readInteger(in);
        DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData = new DistributedRemoveAllOperation.RemoveAllEntryData[removeAllSize];
        Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
        ByteArrayDataInput bytesIn = new ByteArrayDataInput();
        for (int i = 0; i < removeAllSize; ++i) {
            removeAllData[i] = new DistributedRemoveAllOperation.RemoveAllEntryData(in, this.eventID, i, version, bytesIn);
        }
        boolean hasTags = in.readBoolean();
        if (hasTags) {
            DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
            for (int i = 0; i < removeAllSize; ++i) {
                removeAllData[i].versionTag = (VersionTag)versionTags.get(i);
            }
        }
        EntryEventImpl e = EntryEventImpl.create(this.region, Operation.REMOVEALL_DESTROY, null, null, null, true, this.getDistributedMember(), true, true);
        this.removeAllOp = new DistributedRemoveAllOperation(e, removeAllSize, false);
        this.removeAllOp.setRemoveAllEntryData(removeAllData);
    }

    public void setDistributedMember(DistributedMember sender) {
        this.distributedMember = sender;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        buf.append("[");
        buf.append("eventID=");
        buf.append(this.eventID);
        if (this.region != null) {
            buf.append(";r=").append(this.region.getName());
        }
        buf.append(";op=");
        buf.append(this.getOperation());
        buf.append(";key=");
        buf.append(this.getKey());
        buf.append(";bucket=");
        buf.append(this.getKeyInfo().getBucketId());
        buf.append(";oldValue=");
        if (this.putAllOp != null) {
            buf.append(";putAllDataSize :" + this.putAllOp.putAllDataSize);
        }
        if (this.removeAllOp != null) {
            buf.append(";removeAllDataSize :" + this.removeAllOp.removeAllDataSize);
        }
        buf.append("]");
        return buf.toString();
    }
}

