/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.security.NotAuthorizedException;

public class UnregisterInterest
extends BaseCommand {
    private static final UnregisterInterest singleton = new UnregisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    UnregisterInterest() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws ClassNotFoundException, IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        int interestType2 = 0;
        StringId errMessage = null;
        serverConnection.setAsTrue(2);
        regionNamePart = clientMessage.getPart(0);
        interestType2 = clientMessage.getPart(1).getInt();
        keyPart = clientMessage.getPart(2);
        Part isClosingPart = clientMessage.getPart(3);
        byte[] isClosingPartBytes = (byte[])isClosingPart.getObject();
        boolean isClosing = isClosingPartBytes[0] == 1;
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean keepalive = false;
        try {
            Part keepalivePart = clientMessage.getPart(4);
            byte[] keepaliveBytes = (byte[])keepalivePart.getObject();
            keepalive = keepaliveBytes[0] != 0;
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null && regionName == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_UNREGISTER_INTEREST_REQUEST_ARE_NULL;
        } else if (key == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_KEY_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
        } else if (regionName == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)s);
            UnregisterInterest.writeErrorResponse(clientMessage, 23, s, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            if (interestType2 == 1) {
                this.securityService.authorizeRegionRead(regionName);
            } else {
                this.securityService.authorizeRegionRead(regionName, key.toString());
            }
        }
        catch (NotAuthorizedException ex) {
            UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
            try {
                UnregisterInterestOperationContext unregisterContext = authzRequest.unregisterInterestAuthorize(regionName, key, interestType2);
                key = unregisterContext.getKey();
            }
            catch (NotAuthorizedException ex) {
                UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        serverConnection.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, key, interestType2, isClosing, serverConnection.getProxyID(), keepalive);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent unregister interest response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
    }
}

