/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;

public class RequestEventValue
extends BaseCommand {
    private static final RequestEventValue singleton = new RequestEventValue();

    public static Command getCommand() {
        return singleton;
    }

    private RequestEventValue() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        Part eventIDPart = null;
        Part valuePart = null;
        EventID event = null;
        Object callbackArg = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        StringBuffer errMessage = new StringBuffer();
        serverConnection.setAsTrue(2);
        int parts = clientMessage.getNumberOfParts();
        eventIDPart = clientMessage.getPart(0);
        if (eventIDPart == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RequestEventValue_0_THE_EVENT_ID_FOR_THE_GET_EVENT_VALUE_REQUEST_IS_NULL, serverConnection.getName()));
            errMessage.append(" The event id for the get event value request is null.");
            RequestEventValue.writeErrorResponse(clientMessage, 3, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
        } else {
            CacheClientNotifier ccn;
            HAContainerWrapper haContainer;
            try {
                event = (EventID)eventIDPart.getObject();
            }
            catch (Exception e) {
                RequestEventValue.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (parts > 1) {
                valuePart = clientMessage.getPart(1);
                try {
                    if (valuePart != null) {
                        callbackArg = valuePart.getObject();
                    }
                }
                catch (Exception e) {
                    RequestEventValue.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Received get event value request ({} bytes) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString());
            }
            if ((haContainer = (HAContainerWrapper)(ccn = serverConnection.getAcceptor().getCacheClientNotifier()).getHaContainer()) == null) {
                String reason = " was not found during get event value request";
                RequestEventValue.writeRegionDestroyedEx(clientMessage, "ha container", reason, serverConnection);
                serverConnection.setAsTrue(1);
            } else {
                Object data;
                Object[] valueAndIsObject = new Object[2];
                try {
                    Object val;
                    data = haContainer.get(new HAEventWrapper(event));
                    if (data == null) {
                        logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RequestEventValue_UNABLE_TO_FIND_A_CLIENT_UPDATE_MESSAGE_FOR_0, event));
                        String msgStr = "No value found for " + event + " in " + haContainer.getName();
                        RequestEventValue.writeErrorResponse(clientMessage, 69, msgStr, serverConnection);
                        serverConnection.setAsTrue(1);
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Value retrieved for event {}", (Object)event);
                    }
                    if (!((val = ((ClientUpdateMessageImpl)data).getValueToConflate()) instanceof byte[])) {
                        val = val instanceof CachedDeserializable ? (Object)((CachedDeserializable)val).getSerializedValue() : (Object)CacheServerHelper.serialize(val);
                        ((ClientUpdateMessageImpl)data).setLatestValue(val);
                    }
                    valueAndIsObject[0] = val;
                    valueAndIsObject[1] = ((ClientUpdateMessageImpl)data).valueIsObject();
                }
                catch (Exception e) {
                    RequestEventValue.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                data = valueAndIsObject[0];
                boolean isObject = (Boolean)valueAndIsObject[1];
                RequestEventValue.writeResponse(data, callbackArg, clientMessage, isObject, serverConnection);
                serverConnection.setAsTrue(1);
                ccn.getClientProxy(serverConnection.getProxyID()).getStatistics().incDeltaFullMessagesSent();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get event value response back to {} for ha container {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)haContainer.getName());
                }
            }
        }
    }
}

