/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class RegisterInterestList
extends BaseCommand {
    private static final RegisterInterestList singleton = new RegisterInterestList();

    public static Command getCommand() {
        return singleton;
    }

    RegisterInterestList() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, InterruptedException {
        InterestResultPolicy policy;
        Part regionNamePart = null;
        Part keyPart = null;
        Part numberOfKeysPart = null;
        String regionName = null;
        Object key = null;
        List<Object> keys = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        int numberOfKeys = 0;
        int partNumber = 0;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        ChunkedMessage chunkedResponseMsg = serverConnection.getRegisterInterestResponseMessage();
        regionNamePart = clientMessage.getPart(0);
        regionName = regionNamePart.getString();
        try {
            policy = (InterestResultPolicy)clientMessage.getPart(1).getObject();
        }
        catch (Exception e) {
            RegisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = clientMessage.getPart(2);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        numberOfKeysPart = clientMessage.getPart(3);
        numberOfKeys = numberOfKeysPart.getInt();
        partNumber = 4;
        keys = new ArrayList<Object>();
        for (int i = 0; i < numberOfKeys; ++i) {
            keyPart = clientMessage.getPart(partNumber + i);
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                RegisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            keys.add(key);
        }
        boolean sendUpdatesAsInvalidates = false;
        if (clientMessage.getNumberOfParts() > numberOfKeys + partNumber) {
            try {
                Part notifyPart = clientMessage.getPart(numberOfKeys + partNumber);
                byte[] notifyPartBytes = (byte[])notifyPart.getObject();
                sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
            }
            catch (Exception e) {
                RegisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest request ({} bytes) from {} for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)numberOfKeys, (Object)regionName, keys);
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_REGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_REGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)s);
            RegisterInterestList.writeChunkedErrorResponse(clientMessage, 21, s, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RegisterInterestList_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_LIST_REQUEST, new Object[]{serverConnection.getName(), regionName}));
        }
        try {
            this.securityService.authorizeRegionRead(regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                RegisterInterestOperationContext registerContext = authzRequest.registerInterestListAuthorize(regionName, keys, policy);
                keys = (List)registerContext.getKey();
            }
            serverConnection.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, keys, serverConnection.getProxyID(), isDurable, sendUpdatesAsInvalidates, false, 0, true);
        }
        catch (Exception ex) {
            RegisterInterestList.checkForInterrupt(serverConnection, ex);
            RegisterInterestList.writeChunkedException(clientMessage, ex, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isPrimary = serverConnection.getAcceptor().getCacheClientNotifier().getClientProxy(serverConnection.getProxyID()).isPrimary();
        if (!isPrimary) {
            chunkedResponseMsg.setMessageType(33);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", (Object)serverConnection.getName(), (Object)regionName, key, (Object)chunkedResponseMsg);
            }
            chunkedResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setMessageType(32);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            try {
                RegisterInterestList.fillAndSendRegisterInterestResponseChunks(region, keys, 0, policy, serverConnection);
                serverConnection.setAsTrue(1);
            }
            catch (Exception e) {
                RegisterInterestList.checkForInterrupt(serverConnection, e);
                RegisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent register interest response for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)numberOfKeys, (Object)regionName, keys);
            }
        }
    }
}

