/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class RegisterDataSerializers
extends BaseCommand {
    private static final RegisterDataSerializers singleton = new RegisterDataSerializers();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterDataSerializers() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException {
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register dataserializer request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        if (!ServerConnection.allowInternalMessagesWithoutCredentials) {
            serverConnection.getAuthzRequest();
        }
        int noOfParts = clientMessage.getNumberOfParts();
        int noOfDataSerializers = (noOfParts - 1) / 2;
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(clientMessage.getPart(noOfParts - 1).getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        byte[][] serializedDataSerializers = new byte[noOfDataSerializers * 2][];
        boolean caughtCNFE = false;
        ClassNotFoundException cnfe = null;
        try {
            for (int i = 0; i < noOfParts - 1; i += 2) {
                Part dataSerializerClassNamePart = clientMessage.getPart(i);
                serializedDataSerializers[i] = dataSerializerClassNamePart.getSerializedForm();
                String dataSerializerClassName = (String)CacheServerHelper.deserialize(serializedDataSerializers[i]);
                Part idPart = clientMessage.getPart(i + 1);
                serializedDataSerializers[i + 1] = idPart.getSerializedForm();
                int id = idPart.getInt();
                Class<?> dataSerializerClass = null;
                try {
                    dataSerializerClass = InternalDataSerializer.getCachedClass(dataSerializerClassName);
                    InternalDataSerializer.register(dataSerializerClass, true, eventId, serverConnection.getProxyID());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    caughtCNFE = true;
                    cnfe = e;
                }
            }
        }
        catch (Exception e) {
            RegisterDataSerializers.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
        }
        if (caughtCNFE) {
            RegisterDataSerializers.writeException(clientMessage, cnfe, false, serverConnection);
            serverConnection.setAsTrue(1);
        }
        if (!serverConnection.getTransientFlag(1)) {
            this.writeReply(clientMessage, serverConnection);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registered dataserializer for MembershipId = {}", (Object)serverConnection.getMembershipID());
        }
    }
}

