/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommandQuery;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;

public class Query
extends BaseCommandQuery {
    private static final Query singleton = new Query();

    public static Command getCommand() {
        return singleton;
    }

    protected Query() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, InterruptedException {
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        String queryString = clientMessage.getPart(0).getString();
        if (clientMessage.getNumberOfParts() == 3) {
            int timeout = clientMessage.getPart(2).getInt();
            serverConnection.setRequestSpecificTimeout(timeout);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received query request from {} queryString: {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)queryString);
        }
        try {
            QueryService queryService = serverConnection.getCachedRegionHelper().getCache().getLocalQueryService();
            org.apache.geode.cache.query.Query query = queryService.newQuery(queryString);
            Set regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            QueryOperationContext queryContext = null;
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                queryContext = authzRequest.queryAuthorize(queryString, regionNames);
                String newQueryString = queryContext.getQuery();
                if (queryString != null && !queryString.equals(newQueryString)) {
                    query = queryService.newQuery(newQueryString);
                    queryString = newQueryString;
                    regionNames = queryContext.getRegionNames();
                    if (regionNames == null) {
                        regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                    }
                }
            }
            this.processQuery(clientMessage, query, queryString, regionNames, start, null, queryContext, serverConnection, true);
        }
        catch (QueryInvalidException e) {
            throw new QueryInvalidException(e.getMessage() + queryString);
        }
        catch (QueryExecutionLowMemoryException e) {
            Query.writeQueryResponseException(clientMessage, e, serverConnection);
        }
    }

    @Override
    protected CollectionType getCollectionType(SelectResults selectResults) {
        return new CollectionTypeImpl(List.class, selectResults.getCollectionType().getElementType());
    }
}

