/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class Ping
extends BaseCommand {
    private static final Ping singleton = new Ping();

    public static Command getCommand() {
        return singleton;
    }

    private Ping() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        ClientHealthMonitor chm;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: rcv tx: {} from {} rcvTime: {}", (Object)serverConnection.getName(), (Object)clientMessage.getTransactionId(), (Object)serverConnection.getSocketString(), (Object)(DistributionStats.getStatTime() - start));
        }
        if ((chm = ClientHealthMonitor.getInstance()) != null) {
            chm.receivedPing(serverConnection.getProxyID());
        }
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent ping reply to {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection serverConnection) throws IOException {
        Message replyMsg = serverConnection.getReplyMessage();
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(Ping.okBytes());
        replyMsg.send(serverConnection);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)serverConnection.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

