/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class PeriodicAck
extends BaseCommand {
    private static final PeriodicAck singleton = new PeriodicAck();

    public static Command getCommand() {
        return singleton;
    }

    private PeriodicAck() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException {
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received periodic ack request ({} bytes) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString());
        }
        try {
            int numEvents = clientMessage.getNumberOfParts();
            boolean success = false;
            CacheClientNotifier ccn = serverConnection.getAcceptor().getCacheClientNotifier();
            CacheClientProxy proxy = ccn.getClientProxy(serverConnection.getProxyID());
            if (proxy != null) {
                proxy.getHARegionQueue().createAckedEventsMap();
                for (int i = 0; i < numEvents; ++i) {
                    Part eventIdPart = clientMessage.getPart(i);
                    eventIdPart.setVersion(serverConnection.getClientVersion());
                    EventID eid = (EventID)eventIdPart.getObject();
                    success = ccn.processDispatchedMessage(serverConnection.getProxyID(), eid);
                    if (!success) break;
                }
            }
            if (success) {
                proxy.getHARegionQueue().setAckedEvents();
                this.writeReply(clientMessage, serverConnection);
                serverConnection.setAsTrue(1);
            }
        }
        catch (Exception e) {
            PeriodicAck.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent periodic ack response for {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
    }
}

