/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;

public class Invalidate
extends BaseCommand {
    private static final Invalidate singleton = new Invalidate();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadInvalidateRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        keyPart = clientMessage.getPart(1);
        eventPart = clientMessage.getPart(2);
        if (clientMessage.getNumberOfParts() > 3) {
            callbackArgPart = clientMessage.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Invalidate.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Invalidate.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(serverConnection.getName() + ": Received invalidate request (" + clientMessage.getPayloadLength() + " bytes) from " + serverConnection.getSocketString() + " for region " + regionName + " key " + key);
        }
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_KEY_FOR_THE_0_REQUEST_IS_NULL, "invalidate"));
                errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_KEY_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("invalidate"));
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL, "invalidate"));
                errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("invalidate"));
            }
            Invalidate.writeErrorResponse(clientMessage, 10, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.BaseCommand__0_WAS_NOT_FOUND_DURING_1_REQUEST.toLocalizedString(regionName, "invalidate");
            Invalidate.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        Breadcrumbs.setEventId(eventId);
        VersionTag tag = null;
        try {
            this.securityService.authorizeRegionWrite(regionName, key.toString());
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                InvalidateOperationContext invalidateContext = authzRequest.invalidateAuthorize(regionName, key, callbackArg);
                callbackArg = invalidateContext.getCallbackArg();
            }
            EventIDHolder clientEvent = new EventIDHolder(eventId);
            if (clientMessage.isRetry()) {
                clientEvent.setPossibleDuplicate(true);
                if (region.getAttributes().getConcurrencyChecksEnabled()) {
                    clientEvent.setRegion(region);
                    if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                        clientEvent.setPossibleDuplicate(false);
                    }
                }
            }
            region.basicBridgeInvalidate(key, callbackArg, serverConnection.getProxyID(), true, clientEvent);
            tag = clientEvent.getVersionTag();
            serverConnection.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand_DURING_0_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{"invalidate", key}));
        }
        catch (RegionDestroyedException rde) {
            Invalidate.writeException(clientMessage, rde, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Invalidate.checkForInterrupt(serverConnection, e);
            Invalidate.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)e);
                }
            } else {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, serverConnection.getName()), (Throwable)e);
            }
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessInvalidateTime(start - oldStart2);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, pr.getNetworkHopType(), tag);
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection, tag);
            }
        } else {
            this.writeReply(clientMessage, serverConnection, tag);
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent invalidate response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteInvalidateResponseTime(DistributionStats.getStatTime() - start);
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, VersionTag tag) throws IOException {
        this.writeReply(origMsg, servConn);
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag tag) throws IOException {
        this.writeReplyWithRefreshMetadata(origMsg, servConn, pr, nwHop);
    }
}

