/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

public class GetPDXIdForType
extends BaseCommand {
    private static final GetPDXIdForType singleton = new GetPDXIdForType();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXIdForType() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException {
        int pdxId;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx id for type request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        if (!ServerConnection.allowInternalMessagesWithoutCredentials) {
            serverConnection.getAuthzRequest();
        }
        int noOfParts = clientMessage.getNumberOfParts();
        PdxType type = (PdxType)clientMessage.getPart(0).getObject();
        try {
            InternalCache cache = serverConnection.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            pdxId = registry.defineType(type);
        }
        catch (Exception e) {
            GetPDXIdForType.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(clientMessage.getTransactionId());
        responseMsg.addIntPart(pdxId);
        responseMsg.send(serverConnection);
        serverConnection.setAsTrue(1);
    }
}

