/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.cache.operations.RegionCreateOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.InterestRegistrationEventImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.HARegionQueueAttributes;
import org.apache.geode.internal.cache.ha.HARegionQueueStats;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxyStats;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientMarkerMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientUserAuths;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AccessControl;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public class CacheClientProxy
implements ClientSession {
    private static final Logger logger = LogService.getLogger();
    protected Socket _socket;
    private final AtomicBoolean _socketClosed = new AtomicBoolean();
    protected ByteBuffer _commBuffer;
    protected String _remoteHostAddress;
    protected volatile boolean isMarkedForRemoval = false;
    protected final Object isMarkedForRemovalLock = new Object();
    protected ClientProxyMembershipID proxyID;
    protected final InternalCache _cache;
    protected final ClientInterestList[] cils = new ClientInterestList[2];
    protected volatile MessageDispatcher _messageDispatcher;
    protected final CacheClientProxyStats _statistics;
    protected final AtomicReference _durableExpirationTask = new AtomicReference();
    protected SystemTimer durableTimer;
    protected volatile boolean _isPaused = true;
    private volatile boolean connected = false;
    private boolean markerEnqueued = false;
    protected static final int MAXIMUM_SHUTDOWN_PEEKS = Integer.getInteger("gemfire.MAXIMUM_SHUTDOWN_PEEKS", 50);
    protected static final int MESSAGE_OFFER_TIME = 0;
    protected final int _maximumMessageCount;
    protected final int _messageTimeToLive;
    protected final CacheClientNotifier _cacheClientNotifier;
    protected static final boolean LOG_DROPPED_MSGS = !Boolean.getBoolean("gemfire.disableNotificationWarnings");
    public static boolean isSlowStartForTesting = false;
    private static final long DEFAULT_SLOW_STARTING_TIME = 5000L;
    private static final String KEY_SLOW_START_TIME_FOR_TESTING = "slowStartTimeForTesting";
    private boolean isPrimary;
    protected byte clientConflation = 0;
    boolean keepalive = false;
    private AccessControl postAuthzCallback;
    private Subject subject;
    private ClientUserAuths clientUserAuths;
    private final Object clientUserAuthsLock = new Object();
    private Version clientVersion;
    private volatile Map regionsWithEmptyDataPolicy = new HashMap();
    public static boolean AFTER_MESSAGE_CREATION_FLAG = false;
    protected static final boolean NOTIFY_REGION_ON_INTEREST = Boolean.getBoolean("gemfire.updateAccessTimeOnClientInterest");
    private final long _acceptorId;
    private final boolean notifyBySubscription;
    private volatile ConcurrentLinkedQueue<Conflatable> queuedEvents = new ConcurrentLinkedQueue();
    private final Object queuedEventsSync = new Object();
    private volatile boolean messageDispatcherInit = false;
    private final AtomicInteger pingCounter = new AtomicInteger();
    private Date creationDate;
    private boolean drainLocked = false;
    private final Object drainLock = new Object();
    private int numDrainsInProgress = 0;
    private final Object drainsInProgressLock = new Object();
    private SecurityService securityService = SecurityService.getSecurityService();
    private final AtomicBoolean closing = new AtomicBoolean(false);
    public static TestHook testHook;

    protected CacheClientProxy(CacheClientNotifier ccn, Socket socket, ClientProxyMembershipID proxyID, boolean isPrimary, byte clientConflation, Version clientVersion, long acceptorId, boolean notifyBySubscription) throws CacheException {
        this.initializeTransientFields(socket, proxyID, isPrimary, clientConflation, clientVersion);
        this._cacheClientNotifier = ccn;
        this._cache = ccn.getCache();
        this._maximumMessageCount = ccn.getMaximumMessageCount();
        this._messageTimeToLive = ccn.getMessageTimeToLive();
        this._acceptorId = acceptorId;
        this.notifyBySubscription = notifyBySubscription;
        DistributedSystem factory = this._cache.getDistributedSystem();
        this._statistics = new CacheClientProxyStats(factory, "id_" + this.proxyID.getDistributedMember().getId() + "_at_" + this._remoteHostAddress + ":" + this._socket.getPort());
        this.cils[0] = new ClientInterestList(this, this.proxyID);
        this.cils[1] = new ClientInterestList(this, this.getDurableId());
        this.postAuthzCallback = null;
        this._cacheClientNotifier.getAcceptorStats().incCurrentQueueConnections();
        this.creationDate = new Date();
        this.initializeClientAuths();
    }

    private void initializeClientAuths() {
        if (AcceptorImpl.isPostAuthzCallbackPresent()) {
            this.clientUserAuths = ServerConnection.getClientUserAuths(this.proxyID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitializeClientAuths() {
        if (this.clientUserAuths != null && AcceptorImpl.isPostAuthzCallbackPresent()) {
            Object object = this.clientUserAuthsLock;
            synchronized (object) {
                ClientUserAuths newClientAuth = ServerConnection.getClientUserAuths(this.proxyID);
                newClientAuth.fillPreviousCQAuth(this.clientUserAuths);
                this.clientUserAuths = newClientAuth;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostAuthzCallback(AccessControl authzCallback) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.postAuthzCallback != null) {
                this.postAuthzCallback.close();
            }
            this.postAuthzCallback = authzCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubject(Subject subject) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.subject != null) {
                subject.logout();
            }
            this.subject = subject;
        }
    }

    public void setCQVsUserAuth(String cqName, long uniqueId, boolean isDurable) {
        if (this.postAuthzCallback == null && this.clientUserAuths != null) {
            this.clientUserAuths.setUserAuthAttributesForCq(cqName, uniqueId, isDurable);
        }
    }

    private void initializeTransientFields(Socket socket, ClientProxyMembershipID pid, boolean ip, byte cc, Version vers) {
        this._socket = socket;
        this.proxyID = pid;
        this.connected = true;
        int bufSize = 1024;
        try {
            bufSize = this._socket.getSendBufferSize();
            if (bufSize < 1024) {
                bufSize = 1024;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this._commBuffer = ServerConnection.allocateCommBuffer(bufSize, socket);
        this._remoteHostAddress = socket.getInetAddress().getHostAddress();
        this.isPrimary = ip;
        this.clientConflation = cc;
        this.clientVersion = vers;
    }

    public boolean isMarkerEnqueued() {
        return this.markerEnqueued;
    }

    public void setMarkerEnqueued(boolean bool) {
        this.markerEnqueued = bool;
    }

    public long getAcceptorId() {
        return this._acceptorId;
    }

    public boolean isNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyID;
    }

    protected boolean isMember(ClientProxyMembershipID memberId) {
        return this.proxyID.equals(memberId);
    }

    protected boolean isSameDSMember(ClientProxyMembershipID memberId) {
        return this.proxyID.isSameDSMember(memberId);
    }

    protected void setKeepAlive(boolean option) {
        this.keepalive = option;
    }

    protected Socket getSocket() {
        return this._socket;
    }

    public String getSocketHost() {
        return this._socket.getInetAddress().getHostAddress();
    }

    protected ByteBuffer getCommBuffer() {
        return this._commBuffer;
    }

    protected String getRemoteHostAddress() {
        return this._remoteHostAddress;
    }

    public int getRemotePort() {
        return this._socket.getPort();
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startRemoval() {
        boolean result;
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            result = this.isMarkedForRemoval;
            this.isMarkedForRemoval = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitRemoval() {
        boolean result;
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            result = this.isMarkedForRemoval;
            boolean interrupted = false;
            try {
                while (this.isMarkedForRemoval) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for CacheClientProxy removal: {}", (Object)this);
                    }
                    try {
                        this.isMarkedForRemovalLock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this._cache.getCancelCriterion().checkCancelInProgress(e);
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoval() {
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            this.isMarkedForRemoval = false;
            this.isMarkedForRemovalLock.notifyAll();
        }
    }

    public InternalCache getCache() {
        return this._cache;
    }

    public Set<String> getInterestRegisteredRegions() {
        HashSet<String> regions = new HashSet<String>();
        for (int i = 0; i < this.cils.length; ++i) {
            if (this.cils[i].regions.isEmpty()) continue;
            regions.addAll(this.cils[i].regions);
        }
        return regions;
    }

    public CacheClientProxyStats getStatistics() {
        return this._statistics;
    }

    protected CacheClientNotifier getCacheClientNotifier() {
        return this._cacheClientNotifier;
    }

    public int getQueueSize() {
        return this._messageDispatcher == null ? 0 : this._messageDispatcher.getQueueSize();
    }

    public int getQueueSizeStat() {
        return this._messageDispatcher == null ? 0 : this._messageDispatcher.getQueueSizeStat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainInProgress() {
        Object object = this.drainsInProgressLock;
        synchronized (object) {
            return this.numDrainsInProgress > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockDrain() {
        Object object = this.drainsInProgressLock;
        synchronized (object) {
            if (!this.drainInProgress()) {
                Object object2 = this.drainLock;
                synchronized (object2) {
                    if (testHook != null) {
                        testHook.doTestHook("PRE_ACQUIRE_DRAIN_LOCK_UNDER_SYNC");
                    }
                    if (!this.drainLocked) {
                        this.drainLocked = true;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDrain() {
        if (testHook != null) {
            testHook.doTestHook("PRE_RELEASE_DRAIN_LOCK");
        }
        Object object = this.drainLock;
        synchronized (object) {
            this.drainLocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeClientCq(String clientCQName) throws CqException {
        block18: {
            if (testHook != null) {
                testHook.doTestHook("PRE_DRAIN_IN_PROGRESS");
            }
            Object object = this.drainsInProgressLock;
            synchronized (object) {
                ++this.numDrainsInProgress;
            }
            if (testHook != null) {
                testHook.doTestHook("DRAIN_IN_PROGRESS_BEFORE_DRAIN_LOCK_CHECK");
            }
            try {
                String msg;
                if (this.drainLocked) {
                    msg = LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_RESTARTING_DURABLE_CLIENT.toLocalizedString(clientCQName, this.proxyID.getDurableId());
                    logger.info(msg);
                    throw new CqException(msg);
                }
                if (this.isPaused() && !this.isConnected()) {
                    CqService cqService = this.getCache().getCqService();
                    if (cqService == null) break block18;
                    InternalCqQuery cqToClose = cqService.getCq(cqService.constructServerCqName(clientCQName, this.proxyID));
                    if (cqToClose != null) {
                        cqService.closeCq(clientCQName, this.proxyID);
                        this._messageDispatcher.drainClientCqEvents(this.proxyID, cqToClose);
                        break block18;
                    }
                    String msg2 = LocalizedStrings.CqService_CQ_NOT_FOUND_FAILED_TO_CLOSE_THE_SPECIFIED_CQ_0.toLocalizedString(clientCQName);
                    logger.info(msg2);
                    throw new CqException(msg2);
                }
                msg = LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_ACTIVE_DURABLE_CLIENT.toLocalizedString(clientCQName, this.proxyID.getDurableId());
                logger.info(msg);
                throw new CqException(msg);
            }
            finally {
                object = this.drainsInProgressLock;
                synchronized (object) {
                    --this.numDrainsInProgress;
                }
                if (testHook != null) {
                    testHook.doTestHook("DRAIN_COMPLETE");
                }
            }
        }
        return true;
    }

    protected boolean isAlive() {
        if (this._messageDispatcher == null) {
            return false;
        }
        return !this._messageDispatcher.isStopped();
    }

    public boolean isPaused() {
        return this._isPaused;
    }

    protected void setPaused(boolean isPaused) {
        this._isPaused = isPaused;
    }

    protected void close() {
        this.close(true, false);
    }

    protected boolean close(boolean checkQueue, boolean stoppedNormally) {
        boolean keepProxy;
        block9: {
            boolean pauseDurable = false;
            if (this.isDurable() && (!stoppedNormally || this.getDurableKeepAlive() && stoppedNormally)) {
                pauseDurable = true;
            }
            keepProxy = false;
            if (pauseDurable) {
                this.pauseDispatching();
                keepProxy = true;
            } else {
                this.terminateDispatching(checkQueue);
                this.closeTransientFields();
            }
            this.connected = false;
            try {
                if (!pauseDurable) {
                    if (this.postAuthzCallback != null) {
                        this.postAuthzCallback.close();
                        this.postAuthzCallback = null;
                    } else if (this.clientUserAuths != null) {
                        this.clientUserAuths.cleanup(true);
                        this.clientUserAuths = null;
                    }
                }
            }
            catch (Exception ex) {
                if (!this._cache.getSecurityLoggerI18n().warningEnabled()) break block9;
                this._cache.getSecurityLoggerI18n().warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, ex});
            }
        }
        return keepProxy;
    }

    protected void pauseDispatching() {
        if (this._messageDispatcher == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pausing processing", (Object)this);
        }
        if (!this.testAndSetPaused(true) && this.isPrimary && this._messageDispatcher != Thread.currentThread()) {
            this._messageDispatcher.interrupt();
        }
        try {
            this.closeTransientFields();
        }
        finally {
            this.scheduleDurableExpirationTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAndSetPaused(boolean newValue) {
        Object object = this._messageDispatcher._pausedLock;
        synchronized (object) {
            if (this._isPaused != newValue) {
                this._isPaused = newValue;
                this._messageDispatcher._pausedLock.notifyAll();
                return !this._isPaused;
            }
            this._messageDispatcher._pausedLock.notifyAll();
            return this._isPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateDispatching(boolean checkQueue) {
        block19: {
            if (this._messageDispatcher == null) {
                return;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Terminating processing", (Object)this);
                }
                if (this._messageDispatcher == Thread.currentThread()) {
                    this._messageDispatcher.stopDispatching(checkQueue);
                    this.cils[0].clearClientInterestList();
                    this.cils[1].clearClientInterestList();
                    this.destroyRQ();
                    return;
                }
                if (!this.closing.compareAndSet(false, true)) {
                    return;
                }
                this.cils[0].clearClientInterestList();
                this.cils[1].clearClientInterestList();
                if (this.testAndSetPaused(false)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Paused but terminating processing", (Object)this);
                    }
                    this.cancelDurableExpirationTask(false);
                }
                boolean alreadyDestroyed = false;
                boolean gotInterrupt = Thread.interrupted();
                try {
                    this._messageDispatcher.stopDispatching(checkQueue);
                    gotInterrupt |= Thread.interrupted();
                    if (!this._messageDispatcher.isAlive()) break block19;
                    this.closeSocket();
                    this.destroyRQ();
                    alreadyDestroyed = true;
                    this._messageDispatcher.interrupt();
                    if (!this._messageDispatcher.isAlive()) break block19;
                    try {
                        this._messageDispatcher.join(1000L);
                    }
                    catch (InterruptedException ex) {
                        gotInterrupt = true;
                    }
                    if (this._messageDispatcher.isAlive()) {
                        logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_COULD_NOT_STOP_MESSAGE_DISPATCHER_THREAD, this));
                    }
                }
                finally {
                    if (gotInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                    if (!alreadyDestroyed) {
                        this.destroyRQ();
                    }
                }
            }
            finally {
                this._statistics.close();
                this.closeTransientFields();
            }
        }
    }

    private void closeSocket() {
        if (this._socketClosed.compareAndSet(false, true)) {
            this._cacheClientNotifier.getSocketCloser().asyncClose(this._socket, this._remoteHostAddress, null);
            this.getCacheClientNotifier().getAcceptorStats().decCurrentQueueConnections();
        }
    }

    private void closeTransientFields() {
        this.closeSocket();
        this.releaseCommBuffer();
        String remoteHostAddress = this._remoteHostAddress;
        if (remoteHostAddress != null) {
            this._cacheClientNotifier.getSocketCloser().releaseResourcesForAddress(remoteHostAddress);
            this._remoteHostAddress = null;
        }
        try {
            this.cils[0].clearClientInterestList();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        this.closeNonDurableCqs();
    }

    private void releaseCommBuffer() {
        ByteBuffer bb = this._commBuffer;
        if (bb != null) {
            this._commBuffer = null;
            ServerConnection.releaseCommBuffer(bb);
        }
    }

    private void closeNonDurableCqs() {
        CqService cqService = this.getCache().getCqService();
        if (cqService != null) {
            try {
                cqService.closeNonDurableClientCqs(this.getProxyID());
            }
            catch (CqException ex) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_CQEXCEPTION_WHILE_CLOSING_NON_DURABLE_CQS_0, ex.getLocalizedMessage()));
            }
        }
    }

    private void destroyRQ() {
        if (this._messageDispatcher == null) {
            return;
        }
        try {
            HARegionQueue rq = this._messageDispatcher._messageQueue;
            rq.destroy();
        }
        catch (RegionDestroyedException rq) {
        }
        catch (CancelException rq) {
        }
        catch (Exception warning) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_EXCEPTION_IN_CLOSING_THE_UNDERLYING_HAREGION_OF_THE_HAREGIONQUEUE, this), (Throwable)warning);
        }
    }

    @Override
    public void registerInterestRegex(String regionName, String regex, boolean isDurable) {
        this.registerInterestRegex(regionName, regex, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regionName, String regex, boolean isDurable, boolean receiveValues) {
        if (!this.isPrimary) {
            throw new IllegalStateException(LocalizedStrings.CacheClientProxy_NOT_PRIMARY.toLocalizedString());
        }
        this.notifySecondariesAndClient(regionName, regex, InterestResultPolicy.NONE, isDurable, receiveValues, 1);
    }

    @Override
    public void registerInterest(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterest(regionName, keyOfInterest, policy, isDurable, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerInterest(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        if (keyOfInterest instanceof String && keyOfInterest.equals("ALL_KEYS")) {
            this.registerInterestRegex(regionName, ".*", isDurable, receiveValues);
            return;
        } else if (keyOfInterest instanceof List) {
            if (!this.isPrimary) throw new IllegalStateException(LocalizedStrings.CacheClientProxy_NOT_PRIMARY.toLocalizedString());
            this.notifySecondariesAndClient(regionName, keyOfInterest, policy, isDurable, receiveValues, 0);
            return;
        } else {
            if (!this.isPrimary) throw new IllegalStateException(LocalizedStrings.CacheClientProxy_NOT_PRIMARY.toLocalizedString());
            this.notifySecondariesAndClient(regionName, keyOfInterest, policy, isDurable, receiveValues, 0);
            if (policy != InterestResultPolicy.KEYS_VALUES) return;
            this.enqueueInitialValue(null, regionName, keyOfInterest);
        }
    }

    private void notifySecondariesAndClient(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable, boolean receiveValues, int interestType2) {
        ClientInterestMessageImpl message = new ClientInterestMessageImpl(new EventID(this._cache.getDistributedSystem()), regionName, keyOfInterest, interestType2, policy.getOrdinal(), isDurable, !receiveValues, 0);
        this.notifySecondariesOfInterestChange(message);
        if (keyOfInterest instanceof List) {
            this.registerClientInterestList(regionName, (List)keyOfInterest, isDurable, !receiveValues, true);
        } else {
            this.registerClientInterest(regionName, keyOfInterest, interestType2, isDurable, !receiveValues, true);
        }
        this.enqueueInterestRegistrationMessage(message);
    }

    private void enqueueInitialValue(ClientInterestMessageImpl clientInterestMessage, String regionName, Object keyOfInterest) {
        Get70 request = (Get70)Get70.getCommand();
        LocalRegion lr = (LocalRegion)this._cache.getRegion(regionName);
        Get70.Entry entry = request.getValueAndIsObject(lr, keyOfInterest, null, null);
        boolean isObject = entry.isObject;
        byte[] value = null;
        if (entry.value != null) {
            if (entry.value instanceof byte[]) {
                value = (byte[])entry.value;
            } else {
                try {
                    value = CacheServerHelper.serialize(entry.value);
                }
                catch (IOException e) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_THE_FOLLOWING_EXCEPTION_OCCURRED_0, entry.value), (Throwable)e);
                }
            }
            VersionTag tag = entry.versionTag;
            EventID eventId = null;
            eventId = clientInterestMessage == null ? new EventID(this._cache.getDistributedSystem()) : new EventID(clientInterestMessage.getEventId(), 1);
            ClientUpdateMessageImpl updateMessage = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_CREATE, lr, keyOfInterest, value, null, isObject ? (byte)1 : 0, null, this.proxyID, eventId, tag);
            CacheClientNotifier.routeSingleClientMessage(updateMessage, this.proxyID);
        }
    }

    private void enqueueInterestRegistrationMessage(ClientInterestMessageImpl message) {
        if (Version.GFE_701.compareTo(this.clientVersion) > 0 && message.getKeyOfInterest() instanceof List) {
            Iterator i = ((List)message.getKeyOfInterest()).iterator();
            while (i.hasNext()) {
                this._messageDispatcher.enqueueMessage(new ClientInterestMessageImpl(message, i.next()));
            }
        } else {
            this._messageDispatcher.enqueueMessage(message);
        }
    }

    @Override
    public void unregisterInterestRegex(String regionName, String regex, boolean isDurable) {
        this.unregisterInterestRegex(regionName, regex, isDurable, true);
    }

    @Override
    public void unregisterInterestRegex(String regionName, String regex, boolean isDurable, boolean receiveValues) {
        if (!this.isPrimary) {
            throw new IllegalStateException(LocalizedStrings.CacheClientProxy_NOT_PRIMARY.toLocalizedString());
        }
        this.notifySecondariesAndClient(regionName, regex, isDurable, receiveValues, 1);
    }

    @Override
    public void unregisterInterest(String regionName, Object keyOfInterest, boolean isDurable) {
        this.unregisterInterest(regionName, keyOfInterest, isDurable, true);
    }

    @Override
    public void unregisterInterest(String regionName, Object keyOfInterest, boolean isDurable, boolean receiveValues) {
        if (keyOfInterest instanceof String && keyOfInterest.equals("ALL_KEYS")) {
            this.unregisterInterestRegex(regionName, ".*", isDurable, receiveValues);
        } else if (this.isPrimary) {
            this.notifySecondariesAndClient(regionName, keyOfInterest, isDurable, receiveValues, 0);
        } else {
            throw new IllegalStateException(LocalizedStrings.CacheClientProxy_NOT_PRIMARY.toLocalizedString());
        }
    }

    private void notifySecondariesAndClient(String regionName, Object keyOfInterest, boolean isDurable, boolean receiveValues, int interestType2) {
        ClientInterestMessageImpl message = new ClientInterestMessageImpl(new EventID(this._cache.getDistributedSystem()), regionName, keyOfInterest, interestType2, 0, isDurable, !receiveValues, 1);
        this.notifySecondariesOfInterestChange(message);
        if (keyOfInterest instanceof List) {
            this.unregisterClientInterest(regionName, (List)keyOfInterest, false);
        } else {
            this.unregisterClientInterest(regionName, keyOfInterest, interestType2, false);
        }
        this.enqueueInterestRegistrationMessage(message);
    }

    protected void notifySecondariesOfInterestChange(ClientInterestMessageImpl message) {
        if (logger.isDebugEnabled()) {
            StringBuffer subBuffer = new StringBuffer();
            if (message.isRegister()) {
                subBuffer.append("register ").append(message.getIsDurable() ? "" : "non-").append("durable interest in ");
            } else {
                subBuffer.append("unregister interest in ");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this).append(": Notifying secondary proxies to ").append(subBuffer.toString()).append(message.getRegionName()).append("->").append(message.getKeyOfInterest()).append("->").append(InterestType.getString(message.getInterestType()));
            logger.debug(buffer.toString());
        }
        this._cacheClientNotifier.deliverInterestChange(this.proxyID, message);
    }

    protected void registerClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean flushState) {
        HARegionQueue queue;
        ClientInterestList cil = this.cils[RegisterInterestTracker.getInterestLookupIndex(isDurable, false)];
        cil.registerClientInterest(regionName, keyOfInterest, interestType2, sendUpdatesAsInvalidates);
        if (flushState) {
            this.flushForInterestRegistration(regionName, this._cache.getDistributedSystem().getDistributedMember());
        }
        if ((queue = this.getHARegionQueue()) != null) {
            queue.setHasRegisteredInterest(true);
        }
    }

    public void flushForInterestRegistration(String regionName, DistributedMember target) {
        Region r = this._cache.getRegion(regionName);
        if (r == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to find region '{}' to flush for interest registration", (Object)regionName);
            }
        } else if (r.getAttributes().getScope().isDistributed()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing region '{}' for interest registration", (Object)regionName);
            }
            CacheDistributionAdvisee cd = (CacheDistributionAdvisee)((Object)r);
            StateFlushOperation sfo = r instanceof PartitionedRegion ? new StateFlushOperation(this._cache.getInternalDistributedSystem().getDistributionManager()) : new StateFlushOperation((DistributedRegion)r);
            try {
                CacheDistributionAdvisor.InitialImageAdvice advice = cd.getCacheDistributionAdvisor().adviseInitialImage(null);
                HashSet<InternalDistributedMember> recips = new HashSet<InternalDistributedMember>(advice.getReplicates());
                recips.addAll(advice.getUninitialized());
                recips.addAll(advice.getEmpties());
                recips.addAll(advice.getPreloaded());
                recips.addAll(advice.getOthers());
                sfo.flush(recips, target, 75, true);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    protected void unregisterClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean isClosing) {
        if (!isClosing || !this.getDurableKeepAlive()) {
            this.cils[1].unregisterClientInterest(regionName, keyOfInterest, interestType2);
        }
        this.cils[0].unregisterClientInterest(regionName, keyOfInterest, interestType2);
    }

    protected void registerClientInterestList(String regionName, List keysOfInterest, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean flushState) {
        ClientInterestList cil = this.cils[RegisterInterestTracker.getInterestLookupIndex(isDurable, false)];
        cil.registerClientInterestList(regionName, keysOfInterest, sendUpdatesAsInvalidates);
        if (this.getHARegionQueue() != null) {
            if (flushState) {
                this.flushForInterestRegistration(regionName, this._cache.getDistributedSystem().getDistributedMember());
            }
            this.getHARegionQueue().setHasRegisteredInterest(true);
        }
    }

    protected void unregisterClientInterest(String regionName, List keysOfInterest, boolean isClosing) {
        if (!isClosing || !this.getDurableKeepAlive()) {
            this.cils[1].unregisterClientInterestList(regionName, keysOfInterest);
        }
        this.cils[0].unregisterClientInterestList(regionName, keysOfInterest);
    }

    protected void processInterestMessage(ClientInterestMessageImpl message) {
        int interestType2 = message.getInterestType();
        String regionName = message.getRegionName();
        Object key = message.getKeyOfInterest();
        if (message.isRegister()) {
            if (key instanceof List) {
                this.registerClientInterestList(regionName, (List)key, message.getIsDurable(), message.getForUpdatesAsInvalidates(), true);
            } else {
                this.registerClientInterest(regionName, key, interestType2, message.getIsDurable(), message.getForUpdatesAsInvalidates(), true);
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this).append(": Interest listener registered ").append(message.getIsDurable() ? "" : "non-").append("durable interest in ").append(message.getRegionName()).append("->").append(message.getKeyOfInterest()).append("->").append(InterestType.getString(message.getInterestType()));
                logger.debug(buffer.toString());
            }
        } else {
            if (key instanceof List) {
                this.unregisterClientInterest(regionName, (List)key, false);
            } else {
                this.unregisterClientInterest(regionName, key, interestType2, false);
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this).append(": Interest listener unregistered interest in ").append(message.getRegionName()).append("->").append(message.getKeyOfInterest()).append("->").append(InterestType.getString(message.getInterestType()));
                logger.debug(buffer.toString());
            }
        }
        this.enqueueInterestRegistrationMessage(message);
        if (message.isRegister() && message.getInterestType() == 0 && !(key instanceof List) && InterestResultPolicy.fromOrdinal(message.getInterestResultPolicy()) == InterestResultPolicy.KEYS_VALUES) {
            this.enqueueInitialValue(message, regionName, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postDeliverAuthCheckPassed(ClientUpdateMessage clientMessage) {
        if (AcceptorImpl.isAuthenticationRequired() && this.postAuthzCallback == null && AcceptorImpl.isPostAuthzCallbackPresent()) {
            ClientUpdateMessageImpl cumi = (ClientUpdateMessageImpl)clientMessage;
            ClientUpdateMessageImpl.CqNameToOp clientCq = cumi.getClientCq(this.proxyID);
            if (clientCq != null && !clientCq.isEmpty()) {
                String[] regionNameHolder;
                OperationContext opctxt;
                if (logger.isDebugEnabled()) {
                    logger.debug("CCP clientCq size before processing auth {}", (Object)clientCq.size());
                }
                if ((opctxt = this.getOperationContext(clientMessage, regionNameHolder = new String[1])) == null) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy__0_NOT_ADDING_MESSAGE_TO_QUEUE_1_BECAUSE_THE_OPERATION_CONTEXT_OBJECT_COULD_NOT_BE_OBTAINED_FOR_THIS_CLIENT_MESSAGE, new Object[]{this, clientMessage}));
                    return false;
                }
                String[] cqNames = clientCq.getNames();
                if (logger.isDebugEnabled()) {
                    logger.debug("CCP clientCq names array size {}", (Object)cqNames.length);
                }
                for (int i = 0; i < cqNames.length; ++i) {
                    try {
                        AuthorizeRequestPP postAuthCallback;
                        if (logger.isDebugEnabled()) {
                            logger.debug("CCP clientCq name {}", (Object)cqNames[i]);
                        }
                        boolean isAuthorized = false;
                        if (this.proxyID.isDurable() && this.getDurableKeepAlive() && this._isPaused) {
                            Object object = this.clientUserAuthsLock;
                            synchronized (object) {
                                postAuthCallback = this.clientUserAuths.getUserAuthAttributes(cqNames[i]).getPostAuthzRequest();
                                if (logger.isDebugEnabled() && postAuthCallback == null) {
                                    logger.debug("CCP clientCq post callback is null");
                                }
                                if (postAuthCallback != null && postAuthCallback.getPostAuthzCallback().authorizeOperation(regionNameHolder[0], opctxt)) {
                                    isAuthorized = true;
                                }
                            }
                        } else {
                            UserAuthAttributes userAuthAttributes = this.clientUserAuths.getUserAuthAttributes(cqNames[i]);
                            postAuthCallback = userAuthAttributes.getPostAuthzRequest();
                            if (postAuthCallback == null && logger.isDebugEnabled()) {
                                logger.debug("CCP clientCq post callback is null");
                            }
                            if (postAuthCallback != null && postAuthCallback.getPostAuthzCallback().authorizeOperation(regionNameHolder[0], opctxt)) {
                                isAuthorized = true;
                            }
                        }
                        if (!isAuthorized) {
                            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy__0_NOT_ADDING_CQ_MESSAGE_TO_QUEUE_1_BECAUSE_AUTHORIZATION_FAILED, new Object[]{this, clientMessage}));
                            clientCq.delete(cqNames[i]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("CCP clientCq size after processing auth {}", (Object)clientCq.size());
                }
                if (!clientMessage.hasCqs(this.proxyID)) {
                    this._statistics.incMessagesNotQueuedNotInterested();
                    if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                        logger.debug("{}: Not adding message to queue. It is not interested in this region and key: {}", (Object)clientMessage);
                    }
                    return false;
                }
            }
        } else if (this.postAuthzCallback != null) {
            String[] regionNameHolder = new String[1];
            boolean isAuthorize = false;
            OperationContext opctxt = this.getOperationContext(clientMessage, regionNameHolder);
            if (opctxt == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy__0_NOT_ADDING_MESSAGE_TO_QUEUE_1_BECAUSE_THE_OPERATION_CONTEXT_OBJECT_COULD_NOT_BE_OBTAINED_FOR_THIS_CLIENT_MESSAGE, new Object[]{this, clientMessage}));
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Invoking authorizeOperation for message: {}", (Object)this, (Object)clientMessage);
            }
            if (this.proxyID.isDurable() && this.getDurableKeepAlive() && this._isPaused) {
                Object object = this.clientUserAuthsLock;
                synchronized (object) {
                    isAuthorize = this.postAuthzCallback.authorizeOperation(regionNameHolder[0], opctxt);
                }
            } else {
                isAuthorize = this.postAuthzCallback.authorizeOperation(regionNameHolder[0], opctxt);
            }
            if (!isAuthorize) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy__0_NOT_ADDING_MESSAGE_TO_QUEUE_1_BECAUSE_AUTHORIZATION_FAILED, new Object[]{this, clientMessage}));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverMessage(Conflatable conflatable) {
        ThreadState state = this.securityService.bindSubject(this.subject);
        ClientUpdateMessage clientMessage = null;
        clientMessage = conflatable instanceof HAEventWrapper ? ((HAEventWrapper)conflatable).getClientUpdateMessage() : (ClientUpdateMessage)conflatable;
        this._statistics.incMessagesReceived();
        if (this.securityService.needPostProcess()) {
            Object oldValue = clientMessage.getValue();
            Object newValue = this.securityService.postProcess(clientMessage.getRegionName(), clientMessage.getKeyOfInterest(), oldValue, clientMessage.valueIsObject());
            clientMessage.setLatestValue(newValue);
        }
        if (clientMessage.needsNoAuthorizationCheck() || this.postDeliverAuthCheckPassed(clientMessage)) {
            if (this.messageDispatcherInit) {
                Object object = this.queuedEventsSync;
                synchronized (object) {
                    if (this.messageDispatcherInit) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Message dispatcher for proxy {} is getting initialized. Adding message to the queuedEvents.", (Object)this);
                        }
                        this.queuedEvents.add(conflatable);
                        return;
                    }
                }
            }
            if (this._messageDispatcher != null) {
                this._messageDispatcher.enqueueMessage(conflatable);
            } else {
                this._statistics.incMessagesFailedQueued();
                if (logger.isDebugEnabled()) {
                    logger.debug("Message is not added to the queue. Message dispatcher for proxy: {} doesn't exist.", (Object)this);
                }
            }
        } else {
            this._statistics.incMessagesFailedQueued();
        }
        if (state != null) {
            state.clear();
        }
    }

    protected void sendMessageDirectly(ClientMessage message) {
        if (logger.isDebugEnabled()) {
            logger.debug("About to send message directly to {}", (Object)this);
        }
        if (this._messageDispatcher != null && this._socket != null && !this._socket.isClosed()) {
            this._messageDispatcher.sendMessageDirectly(message);
            if (logger.isDebugEnabled()) {
                logger.debug("Sent message directly to {}", (Object)this);
            }
        } else {
            this.resetPingCounter();
            if (logger.isDebugEnabled()) {
                logger.debug("Skipped sending message directly to {}", (Object)this);
            }
        }
    }

    private OperationContext getOperationContext(ClientMessage cmsg, String[] regionNameHolder) {
        String regionName;
        ClientUpdateMessageImpl cmsgimpl = (ClientUpdateMessageImpl)cmsg;
        OperationContext opctxt = null;
        regionNameHolder[0] = regionName = cmsgimpl.getRegionName();
        if (cmsgimpl.isCreate()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionCreateOperationContext(true);
            } else {
                PutOperationContext tmp = new PutOperationContext(cmsgimpl.getKeyOfInterest(), cmsgimpl.getValue(), cmsgimpl.valueIsObject(), 1, true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isUpdate()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionCreateOperationContext(true);
            } else {
                PutOperationContext tmp = new PutOperationContext(cmsgimpl.getKeyOfInterest(), cmsgimpl.getValue(), cmsgimpl.valueIsObject(), 2, true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isDestroy()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionDestroyOperationContext(true);
            } else {
                DestroyOperationContext tmp = new DestroyOperationContext(cmsgimpl.getKeyOfInterest(), true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isDestroyRegion()) {
            opctxt = new RegionDestroyOperationContext(true);
        } else if (cmsgimpl.isInvalidate()) {
            InvalidateOperationContext tmp = new InvalidateOperationContext(cmsgimpl.getKeyOfInterest(), true);
            tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
            opctxt = tmp;
        } else if (cmsgimpl.isClearRegion()) {
            RegionClearOperationContext tmp = new RegionClearOperationContext(true);
            tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
            opctxt = tmp;
        }
        return opctxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeMessageDispatcher() throws CacheException {
        this.messageDispatcherInit = true;
        try {
            Conflatable nextEvent;
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initializing message dispatcher with capacity of {} entries", (Object)this, (Object)this._maximumMessageCount);
            }
            String name = "Client Message Dispatcher for " + this.getProxyID().getDistributedMember() + (this.isDurable() ? " (" + this.getDurableId() + ")" : "");
            this._messageDispatcher = new MessageDispatcher(this, name);
            if (logger.isDebugEnabled()) {
                logger.debug("{} draining {} events from init queue into intialized queue", (Object)this, (Object)this.queuedEvents.size());
            }
            while ((nextEvent = this.queuedEvents.poll()) != null) {
                this._messageDispatcher.enqueueMessage(nextEvent);
            }
            Object object = this.queuedEventsSync;
            synchronized (object) {
                while ((nextEvent = this.queuedEvents.poll()) != null) {
                    this._messageDispatcher.enqueueMessage(nextEvent);
                }
                this.messageDispatcherInit = false;
            }
        }
        finally {
            if (this.messageDispatcherInit) {
                this._statistics.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startOrResumeMessageDispatcher(boolean processedMarker) {
        if (this.isPrimary) {
            if (!processedMarker) {
                EventID eventId = new EventID(this._cache.getDistributedSystem());
                this._messageDispatcher.enqueueMarker(new ClientMarkerMessageImpl(eventId));
            }
            this._messageDispatcher._messageQueue.setPrimary(true);
            Object object = this._messageDispatcher._pausedLock;
            synchronized (object) {
                if (this.isPaused()) {
                    this.setPaused(false);
                    if (this._messageDispatcher.isStopped()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Starting dispatcher", (Object)this);
                        }
                        this._messageDispatcher.start();
                    } else {
                        this._messageDispatcher.initializeTransients();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Resuming dispatcher", (Object)this);
                        }
                        this._messageDispatcher.resumeDispatching();
                    }
                } else if (!this._messageDispatcher.isAlive()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Starting dispatcher", (Object)this);
                    }
                    this._messageDispatcher.start();
                }
            }
        }
    }

    protected boolean hasRegisteredInterested() {
        return this.cils[0].hasInterest() || this.cils[1].hasInterest();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CacheClientProxy[").append(this.proxyID).append("; port=").append(this._socket.getPort()).append("; primary=").append(this.isPrimary).append("; version=").append(this.clientVersion).append("]");
        return buffer.toString();
    }

    public String getState() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CacheClientProxy[").append(this.proxyID).append("; port=").append(this._socket.getPort()).append("; primary=").append(this.isPrimary).append("; version=").append(this.clientVersion).append("; paused=").append(this.isPaused()).append("; alive=").append(this.isAlive()).append("; connected=").append(this.isConnected()).append("; isMarkedForRemoval=").append(this.isMarkedForRemoval).append("]");
        if (this._messageDispatcher != null && this.isAlive()) {
            buffer.append(LogWriterImpl.getStackTrace(this._messageDispatcher));
        }
        return buffer.toString();
    }

    @Override
    public boolean isPrimary() {
        boolean primary = this.isPrimary;
        return primary;
    }

    protected boolean basicIsPrimary() {
        return this.isPrimary;
    }

    protected void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public HARegionQueue getHARegionQueue() {
        if (this._messageDispatcher != null) {
            return this._messageDispatcher._messageQueue;
        }
        return null;
    }

    protected void reinitialize(Socket socket, ClientProxyMembershipID proxyId, Cache cache, boolean ip, byte cc, Version ver) {
        this.initializeTransientFields(socket, proxyId, ip, cc, ver);
        this.getCacheClientNotifier().getAcceptorStats().incCurrentQueueConnections();
        this.cancelDurableExpirationTask(true);
        this._messageDispatcher._messageQueue.setPrimary(ip);
        this._messageDispatcher._messageQueue.setClientConflation(cc);
        this.reinitializeClientAuths();
        this.creationDate = new Date();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Has been reinitialized", (Object)this);
        }
    }

    protected boolean isDurable() {
        return this.getProxyID().isDurable();
    }

    protected String getDurableId() {
        return this.getProxyID().getDurableId();
    }

    protected int getDurableTimeout() {
        return this.getProxyID().getDurableTimeout();
    }

    private boolean getDurableKeepAlive() {
        return this.keepalive;
    }

    protected String getHARegionName() {
        return this.getProxyID().getHARegionName();
    }

    public Region getHARegion() {
        return this._messageDispatcher._messageQueue.getRegion();
    }

    public Version getVersion() {
        return this.clientVersion;
    }

    protected void scheduleDurableExpirationTask() {
        SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                CacheClientProxy.this._durableExpirationTask.compareAndSet(this, null);
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__THE_EXPIRATION_TASK_HAS_FIRED_SO_THIS_PROXY_IS_BEING_TERMINATED, CacheClientProxy.this));
                CacheClientProxy.this.getCacheClientNotifier().removeClientProxy(CacheClientProxy.this);
                CacheClientProxy.this.getCacheClientNotifier().durableClientTimedOut(CacheClientProxy.this.proxyID);
                CacheClientProxy.this.terminateDispatching(false);
                CacheClientProxy.this._cacheClientNotifier.statistics.incQueueDroppedCount();
                Object task = CacheClientProxy.this._durableExpirationTask.getAndSet(null);
                if (task != null && ((SystemTimer.SystemTimerTask)task).cancel()) {
                    CacheClientProxy.this._cache.purgeCCPTimer();
                }
            }
        };
        if (this._durableExpirationTask.compareAndSet(null, task)) {
            this._cache.getCCPTimer().schedule(task, (long)this.getDurableTimeout() * 1000L);
        }
    }

    protected void cancelDurableExpirationTask(boolean logMessage) {
        SystemTimer.SystemTimerTask task = this._durableExpirationTask.getAndSet(null);
        if (task != null) {
            if (logMessage) {
                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_CANCELLING_EXPIRATION_TASK_SINCE_THE_CLIENT_HAS_RECONNECTED, this));
            }
            if (task.cancel()) {
                this._cache.purgeCCPTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            this._statistics.incCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            this._statistics.decCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOneCq() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount() == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNoCq() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount() == 0;
        }
    }

    public Map getRegionsWithEmptyDataPolicy() {
        return this.regionsWithEmptyDataPolicy;
    }

    public int incrementAndGetPingCounter() {
        int pingCount = this.pingCounter.incrementAndGet();
        return pingCount;
    }

    public void resetPingCounter() {
        this.pingCounter.set(0);
    }

    public long getUpTime() {
        return (System.currentTimeMillis() - this.creationDate.getTime()) / 1000L;
    }

    public static interface TestHook {
        public void doTestHook(String var1);
    }

    static class MessageDispatcher
    extends Thread {
        protected final HARegionQueue _messageQueue;
        private final CacheClientProxy _proxy;
        private volatile boolean _isStopped = true;
        protected final Object _pausedLock = new Object();
        private final Object _stopDispatchingLock = new Object();
        private final ReadWriteLock socketLock = new ReentrantReadWriteLock();
        private final Lock socketWriteLock = this.socketLock.writeLock();

        protected MessageDispatcher(CacheClientProxy proxy, String name) throws CacheException {
            super((ThreadGroup)LoggingThreadGroup.createThreadGroup(name, logger), name);
            this.setDaemon(true);
            this._proxy = proxy;
            try {
                boolean canHandleDelta;
                HARegionQueueAttributes harq = new HARegionQueueAttributes();
                harq.setBlockingQueueCapacity(proxy._maximumMessageCount);
                harq.setExpiryTime(proxy._messageTimeToLive);
                ((HAContainerWrapper)proxy._cacheClientNotifier.getHaContainer()).putProxy(HARegionQueue.createRegionName(this.getProxy().getHARegionName()), this.getProxy());
                boolean createDurableQueue = proxy.proxyID.isDurable();
                boolean bl = canHandleDelta = proxy.clientVersion.compareTo(Version.GFE_61) >= 0 && InternalDistributedSystem.getAnyInstance().getConfig().getDeltaPropagation() && this._proxy.clientConflation != 1;
                if ((createDurableQueue || canHandleDelta) && logger.isDebugEnabled()) {
                    logger.debug("Creating a durable HA queue");
                }
                this._messageQueue = HARegionQueue.getHARegionQueueInstance(this.getProxy().getHARegionName(), this.getCache(), harq, 1, createDurableQueue, proxy._cacheClientNotifier.getHaContainer(), proxy.getProxyID(), this._proxy.clientConflation, this._proxy.isPrimary(), canHandleDelta);
                if (this._proxy.hasRegisteredInterested()) {
                    this._messageQueue.setHasRegisteredInterest(true);
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (RegionExistsException ree) {
                throw ree;
            }
            catch (Exception e) {
                this.getCache().getCancelCriterion().checkCancelInProgress(e);
                throw new CacheException(LocalizedStrings.CacheClientProxy_EXCEPTION_OCCURRED_WHILE_TRYING_TO_CREATE_A_MESSAGE_QUEUE.toLocalizedString(), e){
                    private static final long serialVersionUID = 0L;
                };
            }
        }

        private CacheClientProxy getProxy() {
            return this._proxy;
        }

        private InternalCache getCache() {
            return this.getProxy().getCache();
        }

        private Socket getSocket() {
            return this.getProxy().getSocket();
        }

        private ByteBuffer getCommBuffer() {
            return this.getProxy().getCommBuffer();
        }

        private CacheClientProxyStats getStatistics() {
            return this.getProxy().getStatistics();
        }

        private void basicStopDispatching() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: notified dispatcher to stop", (Object)this);
            }
            this._isStopped = true;
        }

        @Override
        public String toString() {
            return this.getProxy().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void stopDispatching(boolean checkQueue) {
            if (this.isStopped()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopping dispatching", (Object)this);
            }
            if (!checkQueue) {
                this.basicStopDispatching();
                return;
            }
            List events = null;
            try {
                for (int numberOfPeeks = 0; numberOfPeeks < MAXIMUM_SHUTDOWN_PEEKS; ++numberOfPeeks) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        events = this._messageQueue.peek(1, -1);
                        if (events != null && events.size() != 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Waiting for client to drain queue: {}", (Object)this._proxy.proxyID);
                            }
                            Thread.sleep(500L);
                            continue;
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancelException e) {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    catch (CacheException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("{}: Exception occurred while trying to stop dispatching", (Object)this, (Object)e);
                        continue;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            finally {
                this.basicStopDispatching();
            }
        }

        protected boolean isStopped() {
            return this._isStopped;
        }

        protected int getQueueSize() {
            return this._messageQueue == null ? 0 : this._messageQueue.size();
        }

        protected int getQueueSizeStat() {
            if (this._messageQueue != null) {
                HARegionQueueStats stats = this._messageQueue.getStatistics();
                return (int)(stats.getEventsEnqued() - stats.getEventsRemoved() - stats.getEventsConflated() - stats.getMarkerEventsConflated() - stats.getEventsExpired() - stats.getEventsRemovedByQrm() - stats.getEventsTaken() - stats.getNumVoidRemovals());
            }
            return 0;
        }

        protected void drainClientCqEvents(ClientProxyMembershipID clientId, InternalCqQuery cqToClose) {
            this._messageQueue.closeClientCq(clientId, cqToClose);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean exceptionOccurred = false;
            this._isStopped = false;
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Beginning to process events", (Object)this);
            }
            if (isSlowStartForTesting) {
                long slowStartTimeForTesting = Long.getLong(CacheClientProxy.KEY_SLOW_START_TIME_FOR_TESTING, 5000L);
                long elapsedTime = 0L;
                long startTime = System.currentTimeMillis();
                while (slowStartTimeForTesting > elapsedTime && isSlowStartForTesting) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignore) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("Slow start for testing interrupted");
                        break;
                    }
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (slowStartTimeForTesting < elapsedTime) {
                    isSlowStartForTesting = false;
                }
            }
            ClientMessage clientMessage = null;
            while (!this.isStopped() && !this._proxy._cache.getCancelCriterion().isCancelInProgress()) {
                try {
                    if (this.getProxy().isPaused()) {
                        Object object = this._pausedLock;
                        synchronized (object) {
                            try {
                                logger.info("available ids = " + this._messageQueue.size() + " , isEmptyAckList =" + this._messageQueue.isEmptyAckList() + ", peekInitialized = " + this._messageQueue.isPeekInitialized());
                                while (!this._messageQueue.isEmptyAckList() && this._messageQueue.isPeekInitialized()) {
                                    this._messageQueue.remove();
                                }
                            }
                            catch (InterruptedException ex) {
                                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_SLEEP_INTERRUPTED, this));
                            }
                        }
                        this.waitForResumption();
                    }
                    try {
                        clientMessage = (ClientMessage)this._messageQueue.peek();
                    }
                    catch (RegionDestroyedException skipped) {
                        break;
                    }
                    this.getStatistics().setQueueSize(this._messageQueue.size());
                    if (this.isStopped()) break;
                    if (clientMessage != null) {
                        long start = this.getStatistics().startTime();
                        boolean isDispatched = this.dispatchMessage(clientMessage);
                        this.getStatistics().endMessage(start);
                        if (isDispatched) {
                            this._messageQueue.remove();
                            if (clientMessage instanceof ClientMarkerMessageImpl) {
                                this.getProxy().markerEnqueued = false;
                            }
                        }
                    } else {
                        this._messageQueue.remove();
                    }
                    clientMessage = null;
                }
                catch (MessageTooLargeException e) {
                    logger.warn("Message too large to send to client: {}, {}", clientMessage, (Object)e.getMessage());
                }
                catch (IOException e) {
                    Object ex = this._stopDispatchingLock;
                    synchronized (ex) {
                        if (!this.isStopped() && !this.getProxy().isPaused()) {
                            if ("Broken pipe".equals(e.getMessage())) {
                                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_PROXY_CLOSING_DUE_TO_UNEXPECTED_BROKEN_PIPE_ON_SOCKET_CONNECTION, this));
                            } else if ("Connection reset".equals(e.getMessage())) {
                                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_PROXY_CLOSING_DUE_TO_UNEXPECTED_RESET_ON_SOCKET_CONNECTION, this));
                            } else if ("Connection reset by peer".equals(e.getMessage())) {
                                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_PROXY_CLOSING_DUE_TO_UNEXPECTED_RESET_BY_PEER_ON_SOCKET_CONNECTION, this));
                            } else if ("Socket is closed".equals(e.getMessage()) || "Socket Closed".equals(e.getMessage())) {
                                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_PROXY_CLOSING_DUE_TO_SOCKET_BEING_CLOSED_LOCALLY, this));
                            } else {
                                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_AN_UNEXPECTED_IOEXCEPTION_OCCURRED_SO_THE_PROXY_WILL_BE_CLOSED, this), (Throwable)e);
                            }
                            this.pauseOrUnregisterProxy(e);
                        }
                    }
                    exceptionOccurred = true;
                }
                catch (InterruptedException e) {
                    if (this.getProxy().isPaused()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: interrupted because it is being paused. It will continue and wait for resumption.", (Object)this);
                        }
                        Thread.interrupted();
                        continue;
                    }
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("{}: interrupted", (Object)this);
                    break;
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: shutting down due to cancellation", (Object)this);
                    }
                    exceptionOccurred = true;
                    break;
                }
                catch (RegionDestroyedException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: shutting down due to loss of message queue", (Object)this);
                    }
                    exceptionOccurred = true;
                    break;
                }
                catch (Exception e) {
                    if (this.isStopped()) continue;
                    logger.fatal((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__AN_UNEXPECTED_EXCEPTION_OCCURRED, this), (Throwable)e);
                }
            }
            List list = null;
            if (!exceptionOccurred) {
                try {
                    Thread.interrupted();
                    int size = this._messageQueue.size();
                    list = this._messageQueue.peek(size);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: After flagging the dispatcher to stop , the residual List of messages to be dispatched={} size={}", (Object)this, (Object)list, (Object)list.size());
                    }
                    if (list.size() > 0) {
                        long start = this.getStatistics().startTime();
                        Iterator itr = list.iterator();
                        while (itr.hasNext()) {
                            this.dispatchMessage((ClientMessage)itr.next());
                            this.getStatistics().endMessage(start);
                        }
                        this._messageQueue.remove();
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("CacheClientNotifier stopped due to cancellation");
                    }
                }
                catch (Exception ignore) {
                    StringId extraMsg = null;
                    if ("Broken pipe".equals(ignore.getMessage())) {
                        extraMsg = LocalizedStrings.CacheClientProxy_PROBLEM_CAUSED_BY_BROKEN_PIPE_ON_SOCKET;
                    } else if (ignore instanceof RegionDestroyedException) {
                        extraMsg = LocalizedStrings.CacheClientProxy_PROBLEM_CAUSED_BY_MESSAGE_QUEUE_BEING_CLOSED;
                    }
                    Object[] msgArgs = new Object[]{!this.isStopped() ? this.toString() + ": " : "", list == null ? 0 : list.size()};
                    if (extraMsg != null) {
                        logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_POSSIBILITY_OF_NOT_BEING_ABLE_TO_SEND_SOME_OR_ALL_THE_MESSAGES_TO_CLIENTS_TOTAL_MESSAGES_CURRENTLY_PRESENT_IN_THE_LIST_1, msgArgs));
                        logger.info((Object)extraMsg);
                    }
                    logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_POSSIBILITY_OF_NOT_BEING_ABLE_TO_SEND_SOME_OR_ALL_THE_MESSAGES_TO_CLIENTS_TOTAL_MESSAGES_CURRENTLY_PRESENT_IN_THE_LIST_1, msgArgs), (Throwable)ignore);
                }
                if (list != null && logger.isTraceEnabled()) {
                    logger.trace("Messages remaining in the list are: {}", (Object)list);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Dispatcher thread is ending", (Object)this);
            }
        }

        private void pauseOrUnregisterProxy(Throwable t) {
            ClientHealthMonitor chm;
            if (this.getProxy().isDurable()) {
                try {
                    this.getProxy().pauseDispatching();
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: {}", (Object)this, (Object)ex);
                    }
                }
            } else {
                this._isStopped = true;
            }
            if ((chm = ClientHealthMonitor.getInstance()) != null) {
                ClientProxyMembershipID proxyID = this.getProxy().proxyID;
                chm.removeAllConnectionsAndUnregisterClient(proxyID, t);
                if (!this.getProxy().isDurable()) {
                    this.getProxy().getCacheClientNotifier().unregisterClient(proxyID, false);
                }
            }
        }

        protected boolean dispatchMessage(ClientMessage clientMessage) throws IOException {
            boolean isDispatched = false;
            if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                logger.trace(LogMarker.BRIDGE_SERVER, "Dispatching {}", (Object)clientMessage);
            }
            Message message = null;
            if (clientMessage instanceof ClientUpdateMessage) {
                byte[] latestValue = (byte[])((ClientUpdateMessage)clientMessage).getValue();
                if (logger.isTraceEnabled()) {
                    StringBuilder msg = new StringBuilder(100);
                    msg.append(this).append(": Using latest value: ").append(Arrays.toString(latestValue));
                    if (((ClientUpdateMessage)clientMessage).valueIsObject()) {
                        if (latestValue != null) {
                            msg.append(" (").append(this.deserialize(latestValue)).append(")");
                        }
                        msg.append(" for ").append(clientMessage);
                    }
                    logger.trace(msg.toString());
                }
                message = ((ClientUpdateMessageImpl)clientMessage).getMessage(this.getProxy(), latestValue);
                if (AFTER_MESSAGE_CREATION_FLAG) {
                    ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                    bo.afterMessageCreation(message);
                }
            } else {
                message = clientMessage.getMessage(this.getProxy(), true);
            }
            if (!this._proxy.isPaused()) {
                this.sendMessage(message);
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Dispatched {}", (Object)this, (Object)clientMessage);
                }
                isDispatched = true;
            } else if (logger.isDebugEnabled()) {
                logger.debug("Message Dispatcher of a Paused CCProxy is trying to dispatch message");
            }
            if (isDispatched) {
                this._messageQueue.getStatistics().incEventsDispatched();
            }
            return isDispatched;
        }

        private void sendMessage(Message message) throws IOException {
            if (message == null) {
                return;
            }
            this.socketWriteLock.lock();
            try {
                message.setComms(this.getSocket(), this.getCommBuffer(), this.getStatistics());
                message.send();
                this.getProxy().resetPingCounter();
            }
            finally {
                this.socketWriteLock.unlock();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Sent {}", (Object)this, (Object)message);
            }
        }

        protected void enqueueMessage(Conflatable clientMessage) {
            block5: {
                try {
                    this._messageQueue.put(clientMessage);
                    if (this._proxy.isPaused() && this._proxy.isDurable()) {
                        this._proxy._cacheClientNotifier.statistics.incEventEnqueuedWhileClientAwayCount();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Queued message while Durable Client is away {}", (Object)this, (Object)clientMessage);
                        }
                    }
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.isStopped()) break block5;
                    this._proxy._statistics.incMessagesFailedQueued();
                    logger.fatal((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0_EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_ADD_MESSAGE_TO_QUEUE, this), (Throwable)e);
                }
            }
        }

        protected void enqueueMarker(ClientMessage message) {
            block5: {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Queueing marker message. <{}>. The queue contains {} entries.", (Object)this, (Object)message, (Object)this.getQueueSize());
                    }
                    this._messageQueue.put(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Queued marker message. The queue contains {} entries.", (Object)this, (Object)this.getQueueSize());
                    }
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.isStopped()) break block5;
                    logger.fatal((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_ADD_MESSAGE_TO_QUEUE, this), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessageDirectly(ClientMessage clientMessage) {
            block10: {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Dispatching directly: {}", (Object)this, (Object)clientMessage);
                    }
                    Message message = clientMessage.getMessage(this.getProxy(), true);
                    this.sendMessage(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Dispatched directly: {}", (Object)this, (Object)clientMessage);
                    }
                }
                catch (MessageTooLargeException e) {
                    logger.warn("Message too large to send to client: {}, {}", (Object)clientMessage, (Object)e.getMessage());
                }
                catch (IOException e) {
                    Object object = this._stopDispatchingLock;
                    synchronized (object) {
                        if (!this.isStopped() && !this.getProxy().isPaused()) {
                            logger.fatal((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__AN_UNEXPECTED_EXCEPTION_OCCURRED, this), (Throwable)e);
                            this.pauseOrUnregisterProxy(e);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.isStopped()) break block10;
                    logger.fatal((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__AN_UNEXPECTED_EXCEPTION_OCCURRED, this), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForResumption() throws InterruptedException {
            Object object = this._pausedLock;
            synchronized (object) {
                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__PAUSING_PROCESSING, this));
                if (!this.getProxy().isPaused()) {
                    return;
                }
                while (this.getProxy().isPaused()) {
                    this._pausedLock.wait();
                }
                this._messageQueue.clearPeekedIDs();
            }
        }

        protected void resumeDispatching() {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CacheClientProxy_0__RESUMING_PROCESSING, this));
            this._pausedLock.notifyAll();
        }

        protected Object deserialize(byte[] serializedBytes) {
            Object deserializedObject = serializedBytes;
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(serializedBytes));
                deserializedObject = DataSerializer.readObject(dis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return deserializedObject;
        }

        protected void initializeTransients() {
            while (!this._messageQueue.isEmptyAckList() && this._messageQueue.isPeekInitialized()) {
                try {
                    this._messageQueue.remove();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this._messageQueue.initializeTransients();
        }
    }

    protected static class ClientInterestList {
        final CacheClientProxy ccp;
        final Object id;
        private final Object interestListLock = new Object();
        protected final Set<String> regions = new HashSet<String>();

        protected ClientInterestList(CacheClientProxy ccp, Object interestID) {
            this.ccp = ccp;
            this.id = interestID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean sendUpdatesAsInvalidates) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: registerClientInterest region={} key={}", (Object)this.ccp, (Object)regionName, keyOfInterest);
            }
            Set keysRegistered = null;
            Object object = this.interestListLock;
            synchronized (object) {
                LocalRegion r = (LocalRegion)this.ccp._cache.getRegion(regionName, true);
                if (r == null) {
                    throw new RegionDestroyedException("Region could not be found for interest registration", regionName);
                }
                if (!(r instanceof CacheDistributionAdvisee)) {
                    throw new IllegalArgumentException("region " + regionName + " is not distributed and does not support interest registration");
                }
                FilterProfile p = r.getFilterProfile();
                keysRegistered = p.registerClientInterest(this.id, keyOfInterest, interestType2, sendUpdatesAsInvalidates);
                this.regions.add(regionName);
            }
            if (keysRegistered != null && this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
                this.handleInterestEvent(regionName, keysRegistered, interestType2, true);
            }
        }

        protected FilterProfile getProfile(String regionName) {
            try {
                return this.ccp._cache.getFilterProfile(regionName);
            }
            catch (CancelException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregisterClientInterest(String regionName, Object keyOfInterest, int interestType2) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: unregisterClientInterest region={} key={}", (Object)this.ccp, (Object)regionName, keyOfInterest);
            }
            FilterProfile p = this.getProfile(regionName);
            Set keysUnregistered = null;
            Object object = this.interestListLock;
            synchronized (object) {
                if (p != null) {
                    keysUnregistered = p.unregisterClientInterest(this.id, keyOfInterest, interestType2);
                    if (!p.hasInterestFor(this.id)) {
                        this.regions.remove(regionName);
                    }
                } else {
                    this.regions.remove(regionName);
                }
            }
            if (keysUnregistered != null && !keysUnregistered.isEmpty()) {
                this.handleInterestEvent(regionName, keysUnregistered, interestType2, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerClientInterestList(String regionName, List keysOfInterest, boolean sendUpdatesAsInvalidates) {
            FilterProfile p = this.getProfile(regionName);
            if (p == null) {
                throw new RegionDestroyedException("Region not found during client interest registration", regionName);
            }
            Set keysRegistered = null;
            Object object = this.interestListLock;
            synchronized (object) {
                keysRegistered = p.registerClientInterestList(this.id, keysOfInterest, sendUpdatesAsInvalidates);
                this.regions.add(regionName);
            }
            if (this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
                this.handleInterestEvent(regionName, keysRegistered, 0, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregisterClientInterestList(String regionName, List keysOfInterest) {
            FilterProfile p = this.getProfile(regionName);
            Set keysUnregistered = null;
            Object object = this.interestListLock;
            synchronized (object) {
                if (p != null) {
                    keysUnregistered = p.unregisterClientInterestList(this.id, keysOfInterest);
                    if (!p.hasInterestFor(this.id)) {
                        this.regions.remove(regionName);
                    }
                } else {
                    this.regions.remove(regionName);
                }
            }
            if (!keysUnregistered.isEmpty()) {
                this.handleInterestEvent(regionName, keysUnregistered, 0, false);
            }
        }

        protected boolean hasInterest() {
            return this.regions.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearClientInterestList() {
            boolean isClosed = this.ccp.getCache().isClosed();
            Object object = this.interestListLock;
            synchronized (object) {
                for (String regionName : this.regions) {
                    FilterProfile p = this.getProfile(regionName);
                    if (p == null) continue;
                    if (!isClosed) {
                        Map<String, Pattern> patternsOfInterest;
                        Set keysOfInterest;
                        if (p.hasAllKeysInterestFor(this.id)) {
                            Set<String> allKeys = new HashSet<String>();
                            allKeys.add(".*");
                            allKeys = Collections.unmodifiableSet(allKeys);
                            this.handleInterestEvent(regionName, allKeys, 1, false);
                        }
                        if ((keysOfInterest = p.getKeysOfInterestFor(this.id)) != null && keysOfInterest.size() > 0) {
                            this.handleInterestEvent(regionName, keysOfInterest, 0, false);
                        }
                        if ((patternsOfInterest = p.getPatternsOfInterestFor(this.id)) != null && patternsOfInterest.size() > 0) {
                            this.handleInterestEvent(regionName, patternsOfInterest.keySet(), 1, false);
                        }
                    }
                    p.clearInterestFor(this.id);
                }
                this.regions.clear();
            }
        }

        private void handleInterestEvent(String regionName, Set keysOfInterest, int interestType2, boolean isRegister) {
            InterestRegistrationEventImpl event = null;
            if (NOTIFY_REGION_ON_INTEREST && this.ccp.isPrimary() && interestType2 == 0) {
                event = new InterestRegistrationEventImpl(this.ccp, regionName, keysOfInterest, interestType2, isRegister);
                try {
                    this.notifyRegionOfInterest(event);
                }
                catch (Exception e) {
                    logger.warn((Object)LocalizedStrings.CacheClientProxy_REGION_NOTIFICATION_OF_INTEREST_FAILED, (Throwable)e);
                }
            }
            if (this.containsInterestRegistrationListeners()) {
                if (event == null) {
                    event = new InterestRegistrationEventImpl(this.ccp, regionName, keysOfInterest, interestType2, isRegister);
                }
                this.notifyInterestRegistrationListeners(event);
            }
        }

        private void notifyRegionOfInterest(InterestRegistrationEvent event) {
            this.ccp.getCacheClientNotifier().handleInterestEvent(event);
        }

        private void notifyInterestRegistrationListeners(InterestRegistrationEvent event) {
            this.ccp.getCacheClientNotifier().notifyInterestRegistrationListeners(event);
        }

        private boolean containsInterestRegistrationListeners() {
            return this.ccp.getCacheClientNotifier().containsInterestRegistrationListeners();
        }
    }
}

