/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.internal.cache.persistence.UnixBackupInspector;
import org.apache.geode.internal.cache.persistence.WindowsBackupInspector;

public abstract class BackupInspector {
    protected Map<String, String> oplogLineMap = new HashMap<String, String>();
    protected Set<String> oplogFileNames = new HashSet<String>();
    protected File backupDir = null;

    public static BackupInspector createInspector(File backupDir) throws IOException {
        if (BackupInspector.isWindows()) {
            return new WindowsBackupInspector(backupDir);
        }
        return new UnixBackupInspector(backupDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupInspector(File backupDir) throws IOException {
        this.backupDir = backupDir;
        if (!backupDir.exists()) {
            throw new IOException("Backup directory " + backupDir.getAbsolutePath() + " does not exist.");
        }
        File restoreFile = this.getRestoreFile(backupDir);
        if (!restoreFile.exists()) {
            throw new IOException("Restore file " + restoreFile.getName() + " does not exist.");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(restoreFile));
            this.parseRestoreFile(reader);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    private void parseRestoreFile(BufferedReader reader) throws IOException {
        boolean markerFound = false;
        String line = null;
        String incrementalMarker = this.getIncrementalMarker();
        while (!markerFound && null != (line = reader.readLine())) {
            markerFound = line.startsWith(incrementalMarker);
        }
        if (markerFound) {
            this.parseOplogLines(reader);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public boolean isIncremental() {
        return !this.oplogFileNames.isEmpty();
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public String getScriptLineForOplogFile(String oplogFileName) {
        return this.oplogLineMap.get(oplogFileName);
    }

    public Set<String> getIncrementalOplogFileNames() {
        return Collections.unmodifiableSet(this.oplogFileNames);
    }

    protected abstract String getIncrementalMarker();

    protected abstract File getRestoreFile(File var1);

    public abstract String getCopyToForOplogFile(String var1);

    public abstract String getCopyFromForOplogFile(String var1);

    protected abstract void parseOplogLines(BufferedReader var1) throws IOException;
}

