/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class SatisfyRedundancyFPR
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        this.createFPRBucketsForThisNode();
        return false;
    }

    public void createFPRBucketsForThisNode() {
        HashMap<PartitionedRegionLoadModel.BucketRollup, PartitionedRegionLoadModel.Move> moves = new HashMap<PartitionedRegionLoadModel.BucketRollup, PartitionedRegionLoadModel.Move>();
        for (PartitionedRegionLoadModel.BucketRollup bucketRollup : this.model.getLowRedundancyBuckets()) {
            PartitionedRegionLoadModel.Move move = this.model.findBestTargetForFPR(bucketRollup, true);
            if (move == null && !this.model.enforceUniqueZones()) {
                move = this.model.findBestTargetForFPR(bucketRollup, false);
            }
            if (move != null) {
                moves.put(bucketRollup, move);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Skipping low redundancy bucket {} because no member will accept it", (Object)bucketRollup);
        }
        for (Map.Entry entry : moves.entrySet()) {
            PartitionedRegionLoadModel.BucketRollup bucket = (PartitionedRegionLoadModel.BucketRollup)entry.getKey();
            PartitionedRegionLoadModel.Move move = (PartitionedRegionLoadModel.Move)entry.getValue();
            PartitionedRegionLoadModel.Member targetMember = move.getTarget();
            this.model.createRedundantBucket(bucket, targetMember);
        }
        this.model.waitForOperations();
    }
}

