/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class RemoveIndexesMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private String indexName;
    private boolean removeSingleIndex;

    public RemoveIndexesMessage() {
    }

    public RemoveIndexesMessage(Set recipients, int regionId, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
    }

    public RemoveIndexesMessage(Set recipients, int regionId, ReplyProcessor21 processor, boolean removeSingleIndex, String indexName) {
        super(recipients, regionId, processor);
        this.removeSingleIndex = removeSingleIndex;
        this.indexName = indexName;
    }

    @Override
    protected boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        ReplyException replyEx = null;
        boolean result = true;
        int bucketIndexRemoved = 0;
        int numIndexesRemoved = 0;
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_WILL_REMOVE_THE_INDEXES_ON_THIS_PR___0, pr));
        try {
            bucketIndexRemoved = this.removeSingleIndex ? pr.removeIndex(this.indexName) : pr.removeIndexes(true);
            numIndexesRemoved = pr.getDataStore().getAllLocalBuckets().size();
        }
        catch (Exception ex) {
            result = false;
            replyEx = new ReplyException(ex);
        }
        this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, bucketIndexRemoved, numIndexesRemoved);
        return false;
    }

    void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, boolean result, int bucketIndexesRemoved, int totalNumBuckets) {
        RemoveIndexesReplyMessage.send(member, this.processorId, dm, ex, result, bucketIndexesRemoved, totalNumBuckets);
    }

    public static PartitionMessage.PartitionResponse send(PartitionedRegion pr, Index ind, boolean removeAllIndex) {
        RemoveIndexesResponse processor = null;
        RegionAdvisor advisor = (RegionAdvisor)pr.getDistributionAdvisor();
        HashSet<InternalDistributedMember> recipients = new HashSet<InternalDistributedMember>(advisor.adviseDataStore());
        recipients.remove(pr.getDistributionManager().getDistributionManagerId());
        if (recipients.size() > 0) {
            processor = (RemoveIndexesResponse)new RemoveIndexesMessage().createReplyProcessor(pr, recipients);
        }
        if (removeAllIndex) {
            RemoveIndexesMessage rm = new RemoveIndexesMessage(recipients, pr.getPRId(), (ReplyProcessor21)processor);
            pr.getDistributionManager().putOutgoing(rm);
        } else {
            RemoveIndexesMessage rm = new RemoveIndexesMessage(recipients, pr.getPRId(), processor, true, ind.getName());
            pr.getDistributionManager().putOutgoing(rm);
        }
        return processor;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new RemoveIndexesResponse(r.getSystem(), recipients);
    }

    @Override
    public int getDSFID() {
        return 59;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.removeSingleIndex = in.readBoolean();
        if (this.removeSingleIndex) {
            this.indexName = in.readUTF();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.removeSingleIndex);
        if (this.removeSingleIndex) {
            out.writeUTF(this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionManager dm) {
        Throwable thr = null;
        boolean sendReply = true;
        PartitionedRegion pr = null;
        try {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_TRYING_TO_GET_PR_WITH_ID___0, this.regionId));
            pr = PartitionedRegion.getPRFromId(this.regionId);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_REMOVE_INDEXES_MESSAGE_GOT_THE_PR__0, pr));
            if (pr == null) {
                throw new PartitionedRegionException(LocalizedStrings.RemoveIndexesMessage_COULD_NOT_GET_PARTITIONED_REGION_FROM_ID_0_FOR_MESSAGE_1_RECEIVED_ON_MEMBER_2_MAP_3.toLocalizedString(this.regionId, this, dm.getId(), PartitionedRegion.dumpPRId()));
            }
            sendReply = this.operateOnPartitionedRegion(dm, pr, 0L);
        }
        catch (PRLocallyDestroyedException pde) {
            if (logger.isDebugEnabled()) {
                logger.debug("Region is locally Destroyed ");
            }
            thr = pde;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.processorId == 0) {
                logger.debug("{} exception while processing message: {}", (Object)this, (Object)t.getMessage(), (Object)t);
            } else if (logger.isTraceEnabled(LogMarker.DM) && t instanceof RuntimeException) {
                logger.debug("Exception caught while processing message: {}", (Object)t.getMessage(), (Object)t);
            }
            if (t instanceof RegionDestroyedException && pr != null) {
                if (pr.isClosed) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_REGION_IS_LOCALLY_DESTROYED_THROWING_REGIONDESTROYEDEXCEPTION_FOR__0, pr));
                    thr = new RegionDestroyedException(LocalizedStrings.RemoveIndexesMessage_REGION_IS_LOCALLY_DESTROYED_ON_0.toLocalizedString(dm.getId()), pr.getFullPath());
                }
            } else {
                thr = t;
            }
        }
        finally {
            if (sendReply && this.processorId != 0) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex, pr, 0L);
            }
        }
    }

    public static class RemoveIndexesReplyMessage
    extends ReplyMessage {
        private boolean result;
        private int numBucketsIndexesRemoved;
        private int numTotalBuckets;

        public RemoveIndexesReplyMessage() {
        }

        RemoveIndexesReplyMessage(int processorId, ReplyException ex, boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            super.setException(ex);
            this.result = result;
            this.numBucketsIndexesRemoved = numBucketsIndexesRemoved;
            this.numTotalBuckets = numTotalBuckets;
            this.setProcessorId(processorId);
        }

        @Override
        public int getDSFID() {
            return 60;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.numBucketsIndexesRemoved = in.readInt();
            this.numTotalBuckets = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            out.writeInt(this.numBucketsIndexesRemoved);
            out.writeInt(this.numTotalBuckets);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException ex, boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            RemoveIndexesReplyMessage rmIndMsg = new RemoveIndexesReplyMessage(processorId, ex, result, numBucketsIndexesRemoved, numTotalBuckets);
            rmIndMsg.setRecipient(recipient);
            dm.putOutgoing(rmIndMsg);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 p) {
            RemoveIndexesResponse processor = (RemoveIndexesResponse)p;
            if (processor != null) {
                processor.setResponse(this.result, this.numBucketsIndexesRemoved, this.numTotalBuckets);
                processor.process(this);
            }
        }
    }

    public static class RemoveIndexesResult {
        public RemoveIndexesResult(int numBucketIndexRemoved) {
        }
    }

    public static class RemoveIndexesResponse
    extends PartitionMessage.PartitionResponse {
        private int numBucketIndexRemoved;
        private int numTotalRemoteBuckets;

        public RemoveIndexesResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public RemoveIndexesResult waitForResults() throws CacheException, ForceReattemptException {
            this.waitForCacheException();
            return new RemoveIndexesResult(0);
        }

        public void setResponse(boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            this.numBucketIndexRemoved += numBucketsIndexesRemoved;
            this.numTotalRemoteBuckets += numTotalBuckets;
        }

        public int getRemoteRemovedIndexes() {
            return this.numBucketIndexRemoved;
        }

        public int getTotalRemoteBuckets() {
            return this.numTotalRemoteBuckets;
        }
    }
}

