/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.lru;

import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.AbstractRegionEntry;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.cache.lru.LRUStatistics;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class NewLRUClockHand {
    private static final Logger logger = LogService.getLogger();
    private BucketRegion bucketRegion = null;
    protected LRUClockNode tail = new GuardNode();
    protected LRUClockNode head = new GuardNode();
    protected final HeadLock lock;
    private final LRUStatistics stats;
    protected int size = 0;
    public static final boolean debug = Boolean.getBoolean("gemfire.verbose-lru-clock");
    private static final int maxEntries;

    public NewLRUClockHand(Object region, EnableLRU ccHelper, InternalRegionArguments internalRegionArgs) {
        this.setBucketRegion(region);
        this.lock = new HeadLock();
        this.initHeadAndTail();
        if (this.bucketRegion != null) {
            this.stats = internalRegionArgs.getPartitionedRegion() != null ? internalRegionArgs.getPartitionedRegion().getEvictionController().stats : null;
        } else {
            LRUStatistics tmp = null;
            if (region instanceof PlaceHolderDiskRegion) {
                tmp = ((PlaceHolderDiskRegion)region).getPRLRUStats();
            } else if (region instanceof PartitionedRegion) {
                tmp = ((PartitionedRegion)region).getPRLRUStatsDuringInitialization();
                PartitionedRegion pr = (PartitionedRegion)region;
                if (tmp != null) {
                    pr.getEvictionController().stats = tmp;
                }
            }
            if (tmp == null) {
                DistributedSystem sf = GemFireCacheImpl.getExisting("").getDistributedSystem();
                tmp = ccHelper.initStats(region, sf);
            }
            this.stats = tmp;
        }
    }

    public void setBucketRegion(Object r) {
        if (r instanceof BucketRegion) {
            this.bucketRegion = (BucketRegion)r;
        }
    }

    public NewLRUClockHand(Region region, EnableLRU ccHelper, NewLRUClockHand oldList) {
        this.setBucketRegion(region);
        this.lock = new HeadLock();
        this.initHeadAndTail();
        if (oldList.stats == null) {
            DistributedSystem sf = region.getCache().getDistributedSystem();
            this.stats = ccHelper.initStats(region, sf);
        } else {
            this.stats = oldList.stats;
            if (this.bucketRegion != null) {
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.resetCounter();
            } else {
                this.stats.resetCounter();
            }
        }
    }

    public void close() {
        this.closeStats();
        if (this.bucketRegion != null) {
            this.bucketRegion.close();
        }
    }

    public void closeStats() {
        LRUStatistics ls = this.stats;
        if (ls != null) {
            ls.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendEntry(LRUClockNode aNode) {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            if (aNode.nextLRUNode() != null || aNode.prevLRUNode() != null) {
                return;
            }
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_ADDING_ANODE_TO_LRU_LIST, aNode));
            }
            aNode.setNextLRUNode(this.tail);
            this.tail.prevLRUNode().setNextLRUNode(aNode);
            aNode.setPrevLRUNode(this.tail.prevLRUNode());
            this.tail.setPrevLRUNode(aNode);
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LRUClockNode getHeadEntry() {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            LRUClockNode aNode = this.head.nextLRUNode();
            if (aNode == this.tail) {
                return null;
            }
            LRUClockNode next = aNode.nextLRUNode();
            this.head.setNextLRUNode(next);
            next.setPrevLRUNode(this.head);
            aNode.setNextLRUNode(null);
            aNode.setPrevLRUNode(null);
            --this.size;
            return aNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LRUClockNode getLRUEntry() {
        LRUClockNode aNode;
        long numEvals = 0L;
        while (true) {
            aNode = null;
            aNode = this.getHeadEntry();
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                logger.trace(LogMarker.LRU_CLOCK, "lru considering {}", (Object)aNode);
            }
            if (aNode == null) {
                this.stats.incEvaluations(numEvals);
                return aNode;
            }
            ++numEvals;
            LRUClockNode lRUClockNode = aNode;
            synchronized (lRUClockNode) {
                if (aNode instanceof AbstractRegionEntry && ((AbstractRegionEntry)((Object)aNode)).isInUseByTransaction()) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_REMOVING_TRANSACTIONAL_ENTRY_FROM_CONSIDERATION));
                    }
                    continue;
                }
                if (aNode.testEvicted()) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_DISCARDING_EVICTED_ENTRY));
                    }
                    continue;
                }
                if (maxEntries > 0 && numEvals > (long)maxEntries) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_GREEDILY_PICKING_AN_AVAILABLE_ENTRY));
                    }
                    this.stats.incGreedyReturns(1L);
                    break block13;
                }
                if (!aNode.testRecentlyUsed()) break;
                aNode.unsetRecentlyUsed();
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                    logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_SKIPPING_RECENTLY_USED_ENTRY, aNode));
                }
                this.appendEntry(aNode);
            }
        }
        {
            block13: {
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                    logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_RETURNING_UNUSED_ENTRY, aNode));
                }
            }
            this.stats.incEvaluations(numEvals);
            return aNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpList() {
        boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.LRU_CLOCK);
        if (!isDebugEnabled) {
            return;
        }
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            int idx = 1;
            for (LRUClockNode aNode = this.head; aNode != null; aNode = aNode.nextLRUNode()) {
                if (!isDebugEnabled) continue;
                logger.trace(LogMarker.LRU_CLOCK, "  ({}) {}", (Object)idx++, (Object)aNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpensiveListCount() {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            long count = 0L;
            for (LRUClockNode aNode = this.head.nextLRUNode(); aNode != this.tail; aNode = aNode.nextLRUNode()) {
                ++count;
            }
            return count;
        }
    }

    public String getAuditReport() {
        int totalNodes = 0;
        int evictedNodes = 0;
        int usedNodes = 0;
        for (LRUClockNode h = this.head; h != null; h = h.nextLRUNode()) {
            ++totalNodes;
            if (h.testEvicted()) {
                ++evictedNodes;
            }
            if (!h.testRecentlyUsed()) continue;
            ++usedNodes;
        }
        StringBuffer result = new StringBuffer(128);
        result.append("LRUList Audit: listEntries = ").append(totalNodes).append(" evicted = ").append(evictedNodes).append(" used = ").append(usedNodes);
        return result.toString();
    }

    public void audit() {
        System.out.println(this.getAuditReport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlinkEntry(LRUClockNode entry) {
        if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
            logger.trace(LogMarker.LRU_CLOCK, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_UNLINKENTRY_CALLED, entry));
        }
        entry.setEvicted();
        this.stats().incDestroys();
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            LRUClockNode next = entry.nextLRUNode();
            LRUClockNode prev = entry.prevLRUNode();
            if (next == null || prev == null) {
                return false;
            }
            next.setPrevLRUNode(prev);
            prev.setNextLRUNode(next);
            entry.setNextLRUNode(null);
            entry.setPrevLRUNode(null);
            --this.size;
        }
        return true;
    }

    public LRUStatistics stats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(RegionVersionVector rvv) {
        if (rvv != null) {
            return;
        }
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            if (this.bucketRegion != null) {
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.resetCounter();
            } else {
                this.stats.resetCounter();
            }
            this.initHeadAndTail();
        }
    }

    private void initHeadAndTail() {
        this.head = new GuardNode();
        this.tail = new GuardNode();
        this.head.setNextLRUNode(this.tail);
        this.tail.setPrevLRUNode(this.head);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    static {
        String squelch = System.getProperty("gemfire.lru.maxSearchEntries");
        maxEntries = squelch == null ? -1 : Integer.parseInt(squelch);
    }

    private static class GuardNode
    implements LRUClockNode {
        private LRUClockNode next;
        LRUClockNode prev;

        private GuardNode() {
        }

        @Override
        public int getEntrySize() {
            return 0;
        }

        @Override
        public LRUClockNode nextLRUNode() {
            return this.next;
        }

        @Override
        public LRUClockNode prevLRUNode() {
            return this.prev;
        }

        @Override
        public void setEvicted() {
        }

        @Override
        public void setNextLRUNode(LRUClockNode next) {
            this.next = next;
        }

        @Override
        public void setPrevLRUNode(LRUClockNode prev) {
            this.prev = prev;
        }

        @Override
        public void setRecentlyUsed() {
        }

        @Override
        public boolean testEvicted() {
            return false;
        }

        @Override
        public boolean testRecentlyUsed() {
            return false;
        }

        @Override
        public void unsetEvicted() {
        }

        @Override
        public void unsetRecentlyUsed() {
        }

        @Override
        public int updateEntrySize(EnableLRU ccHelper) {
            return 0;
        }

        @Override
        public int updateEntrySize(EnableLRU ccHelper, Object value) {
            return 0;
        }
    }

    protected static class HeadLock {
        protected HeadLock() {
        }
    }
}

