/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntry;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryHeapUUIDKey;

public abstract class VersionedThinLRURegionEntryHeap
extends VersionedThinLRURegionEntry {
    private static final VersionedThinLRURegionEntryHeapFactory factory = new VersionedThinLRURegionEntryHeapFactory();

    public VersionedThinLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

