/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedThinDiskLRURegionEntryHeapUUIDKey
extends VersionedThinDiskLRURegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VersionedThinDiskLRURegionEntryHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VersionedThinDiskLRURegionEntryHeapUUIDKey.class, "lastModified");
    private volatile Object value;
    protected DiskId id;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private VersionSource memberID;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VersionedThinDiskLRURegionEntryHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext drs, Object value) {
        boolean isBackup;
        if (drs instanceof LocalRegion) {
            isBackup = ((LocalRegion)drs).getDiskRegion().isBackup();
        } else if (drs instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a LocalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(drs, value);
        }
    }

    @Override
    public synchronized int updateAsyncEntrySize(EnableLRU capacityController) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
        DiskStoreImpl ds = r.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, ds.needsLinkedList());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long time) {
        this.setLastModified(time);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberID;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag tag) {
        this.memberID = tag.getMemberID();
        int eVersion = tag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = tag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = tag.getRegionVersionLowBytes();
        if (!tag.isGatewayTag() && this.distributedSystemId == tag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= tag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(tag.getVersionTimeStamp());
            } else {
                tag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(tag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(tag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberID) {
        this.memberID = memberID;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberID);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource thisVM, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(r, tag, isTombstoneFromGII, hasDelta, thisVM, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

