/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntry;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryHeap;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VersionedStatsLRURegionEntryOffHeapUUIDKey;

public abstract class VersionedStatsLRURegionEntryOffHeap
extends VersionedStatsLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsLRURegionEntryOffHeapFactory factory = new VersionedStatsLRURegionEntryOffHeapFactory();

    public VersionedStatsLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsLRURegionEntryHeap.getEntryFactory();
        }
    }
}

