/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntry;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapUUIDKey;

public abstract class VersionedStatsDiskLRURegionEntryOffHeap
extends VersionedStatsDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsDiskLRURegionEntryOffHeapFactory factory = new VersionedStatsDiskLRURegionEntryOffHeapFactory();

    public VersionedStatsDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

