/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.NewLRUClockHand;
import org.apache.geode.internal.cache.persistence.DiskExceptionHandler;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ValidatingDiskRegion
extends DiskRegion
implements DiskRecoveryStore {
    private final ConcurrentMap<Object, DiskEntry> map = new ConcurrentHashMap<Object, DiskEntry>();

    protected ValidatingDiskRegion(DiskStoreImpl ds, DiskRegionView drv) {
        super(ds, drv.getName(), drv.isBucket(), true, false, true, new DiskRegionStats(ds.getCache().getDistributedSystem(), drv.getName()), new DummyCancelCriterion(), new DummyDiskExceptionHandler(), null, drv.getFlags(), drv.getPartitionName(), drv.getStartingBucketId(), drv.getCompressorClassName(), drv.getOffHeap());
        this.setConfig(drv.getLruAlgorithm(), drv.getLruAction(), drv.getLruLimit(), drv.getConcurrencyLevel(), drv.getInitialCapacity(), drv.getLoadFactor(), drv.getStatisticsEnabled(), drv.isBucket(), drv.getFlags(), drv.getPartitionName(), drv.getStartingBucketId(), drv.getCompressorClassName(), drv.getOffHeap());
    }

    static ValidatingDiskRegion create(DiskStoreImpl dsi, DiskRegionView drv) {
        assert (dsi != null);
        ValidatingDiskRegion result = new ValidatingDiskRegion(dsi, drv);
        result.register();
        return result;
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this;
    }

    @Override
    public DiskEntry getDiskEntry(Object key) {
        return (DiskEntry)this.map.get(key);
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        ValidatingDiskEntry de = new ValidatingDiskEntry(key, re);
        if (this.map.putIfAbsent(key, de) != null) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_ENTRY_ALREADY_EXISTED_0.toLocalizedString(key));
        }
        return de;
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        ValidatingDiskEntry de = new ValidatingDiskEntry(key, re);
        this.map.put(key, de);
        return de;
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
        this.map.remove(key);
    }

    @Override
    public void foreachRegionEntry(LocalRegion.RegionEntryCallback callback) {
        throw new IllegalStateException("foreachRegionEntry should not be called when validating disk store");
    }

    @Override
    public boolean lruLimitExceeded() {
        return false;
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        throw new IllegalStateException("copyRecoveredEntries should not be called on ValidatingDiskRegion");
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newSize, int bytesOnDisk) {
        throw new IllegalStateException("updateSizeOnFaultIn should not be called on ValidatingDiskRegion");
    }

    @Override
    public int calculateValueSize(Object val) {
        return 0;
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry re) {
        return 0;
    }

    @Override
    public RegionMap getRegionMap() {
        throw new IllegalStateException("getRegionMap should not be called on ValidatingDiskRegion");
    }

    @Override
    public void handleDiskAccessException(DiskAccessException dae) {
        throw new IllegalStateException("handleDiskAccessException should not be called on ValidatingDiskRegion");
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        throw new IllegalStateException("initializeStats should not be called on ValidatingDiskRegion");
    }

    public int size() {
        return this.map.size();
    }

    private static class DummyCancelCriterion
    extends CancelCriterion {
        private DummyCancelCriterion() {
        }

        @Override
        public String cancelInProgress() {
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            return new RuntimeException(e);
        }
    }

    public static class DummyDiskExceptionHandler
    implements DiskExceptionHandler {
        @Override
        public void handleDiskAccessException(DiskAccessException dae) {
        }

        public boolean shouldStopServer() {
            return false;
        }
    }

    static class ValidatingDiskEntry
    implements DiskEntry,
    RegionEntry {
        private final Object key;
        private final DiskId diskId;

        public ValidatingDiskEntry(Object key, DiskEntry.RecoveredEntry re) {
            this.key = key;
            this.diskId = DiskId.createDiskId(1L, true, false);
            this.diskId.setKeyId(re.getRecoveredKeyId());
            this.diskId.setOffsetInOplog(re.getOffsetInOplog());
            this.diskId.setOplogId(re.getOplogId());
            this.diskId.setUserBits(re.getUserBits());
            this.diskId.setValueLength(re.getValueLength());
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object _getValue() {
            return null;
        }

        @Override
        public Token getValueAsToken() {
            return null;
        }

        @Override
        public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
            return null;
        }

        @Override
        public boolean isValueNull() {
            throw new IllegalStateException("should never be called");
        }

        public void _setValue(RegionEntryContext context, Object value) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void setValueWithContext(RegionEntryContext context, Object value) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void handleValueOverflow(RegionEntryContext context) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public Object prepareValueForCache(RegionEntryContext r, Object val, boolean isEntryUpdate) {
            throw new IllegalStateException("Should never be called");
        }

        public void _removePhase1() {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public DiskId getDiskId() {
            return this.diskId;
        }

        @Override
        public long getLastModified() {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public int updateAsyncEntrySize(EnableLRU capacityController) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public DiskEntry getPrev() {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public DiskEntry getNext() {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void setPrev(DiskEntry v) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void setNext(DiskEntry v) {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public VersionStamp getVersionStamp() {
            return null;
        }

        @Override
        public boolean isRemovedFromDisk() {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public boolean hasStats() {
            return false;
        }

        @Override
        public long getLastAccessed() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public long getHitCount() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public long getMissCount() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public void updateStatsForPut(long lastModifiedTime, long lastAccessedTime) {
        }

        @Override
        public VersionTag generateVersionTag(VersionSource member, boolean withDelta, LocalRegion region, EntryEventImpl event) {
            return null;
        }

        @Override
        public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
            return false;
        }

        @Override
        public void setRecentlyUsed() {
        }

        @Override
        public void updateStatsForGet(boolean hit, long time) {
        }

        @Override
        public void txDidDestroy(long currTime) {
        }

        @Override
        public void resetCounts() throws InternalStatisticsDisabledException {
        }

        @Override
        public void makeTombstone(LocalRegion r, VersionTag version) throws RegionClearedException {
        }

        @Override
        public void removePhase1(LocalRegion r, boolean clear) throws RegionClearedException {
        }

        @Override
        public void removePhase2() {
        }

        @Override
        public boolean isRemoved() {
            return false;
        }

        @Override
        public boolean isRemovedPhase2() {
            return false;
        }

        @Override
        public boolean isTombstone() {
            return false;
        }

        @Override
        public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr, Version version) {
            return false;
        }

        @Override
        public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
            return false;
        }

        @Override
        public Object getValue(RegionEntryContext context) {
            return null;
        }

        @Override
        public Object getValueRetain(RegionEntryContext context) {
            return null;
        }

        @Override
        public void setValue(RegionEntryContext context, Object value) throws RegionClearedException {
        }

        @Override
        public void setValueWithTombstoneCheck(Object value, EntryEvent event) throws RegionClearedException {
        }

        @Override
        public Object getTransformedValue() {
            return null;
        }

        @Override
        public Object getValueInVM(RegionEntryContext context) {
            return null;
        }

        @Override
        public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
            return null;
        }

        @Override
        public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
            return null;
        }

        @Override
        public boolean initialImagePut(LocalRegion region, long lastModified, Object newValue, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
            return false;
        }

        @Override
        public boolean initialImageInit(LocalRegion region, long lastModified, Object newValue, boolean create, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
            return false;
        }

        @Override
        public boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException, RegionClearedException {
            return false;
        }

        @Override
        public boolean getValueWasResultOfSearch() {
            return false;
        }

        @Override
        public void setValueResultOfSearch(boolean v) {
        }

        @Override
        public Object getSerializedValueOnDisk(LocalRegion localRegion) {
            return null;
        }

        @Override
        public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
            return null;
        }

        @Override
        public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
            return null;
        }

        @Override
        public boolean isUpdateInProgress() {
            return false;
        }

        @Override
        public void setUpdateInProgress(boolean underUpdate) {
        }

        @Override
        public boolean isInvalid() {
            return false;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public boolean isDestroyedOrRemoved() {
            return false;
        }

        @Override
        public boolean isDestroyedOrRemovedButNotTombstone() {
            return false;
        }

        @Override
        public boolean isInvalidOrRemoved() {
            return false;
        }

        @Override
        public void setValueToNull() {
        }

        @Override
        public void returnToPool() {
        }

        @Override
        public boolean isCacheListenerInvocationInProgress() {
            return false;
        }

        @Override
        public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
        }

        @Override
        public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        }

        @Override
        public boolean isInUseByTransaction() {
            return false;
        }

        @Override
        public void setInUseByTransaction(boolean v) {
        }

        @Override
        public void incRefCount() {
        }

        @Override
        public void decRefCount(NewLRUClockHand lruList, LocalRegion lr) {
        }

        @Override
        public void resetRefCount(NewLRUClockHand lruList) {
        }

        @Override
        public Object prepareValueForCache(RegionEntryContext r, Object val, EntryEventImpl event, boolean isEntryUpdate) {
            throw new IllegalStateException("Should never be called");
        }
    }
}

