/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeap;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinRegionEntryOffHeapUUIDKey
extends VMThinRegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinRegionEntryOffHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinRegionEntryOffHeapUUIDKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VMThinRegionEntryOffHeapUUIDKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VMThinRegionEntryOffHeapUUIDKey.class, "ohAddress");
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VMThinRegionEntryOffHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

