/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMThinRegionEntry;
import org.apache.geode.internal.cache.VMThinRegionEntryHeap;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VMThinRegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeap;

public abstract class VMThinRegionEntryOffHeap
extends VMThinRegionEntry
implements OffHeapRegionEntry {
    private static final VMThinRegionEntryOffHeapFactory factory = new VMThinRegionEntryOffHeapFactory();

    public VMThinRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMThinRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinRegionEntryHeap.getEntryFactory();
        }
    }
}

