/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VMThinDiskRegionEntryOffHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinDiskRegionEntryOffHeapStringKey2
extends VMThinDiskRegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryOffHeapStringKey2> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryOffHeapStringKey2.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryOffHeapStringKey2> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryOffHeapStringKey2.class, "ohAddress");
    protected DiskId id;
    private final long bits1;
    private final long bits2;

    public VMThinDiskRegionEntryOffHeapStringKey2(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tmpBits1 = 0L;
        long tmpBits2 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 7) {
                    tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                    tmpBits1 <<= 8;
                    continue;
                }
                tmpBits2 <<= 8;
                tmpBits2 |= (long)((byte)key.charAt(i) & 0xFF);
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 3) {
                    tmpBits1 |= (long)key.charAt(i);
                    tmpBits1 <<= 16;
                    continue;
                }
                tmpBits2 <<= 16;
                tmpBits2 |= (long)key.charAt(i);
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
        this.bits2 = tmpBits2;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EnableLRU capacityController) {
        throw new IllegalStateException("should never be called");
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        long tmpBits2 = this.bits2;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                if (i < 7) {
                    chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFL);
                tmpBits2 >>= 8;
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                if (i < 3) {
                    chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFFFL);
                tmpBits2 >>= 16;
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                long tmpBits2 = this.bits2;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 7) {
                            c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFL);
                            tmpBits2 >>= 8;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 3) {
                            c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFFFL);
                            tmpBits2 >>= 16;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

