/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntry;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeap;

public abstract class VMThinDiskLRURegionEntryHeap
extends VMThinDiskLRURegionEntry {
    private static final VMThinDiskLRURegionEntryHeapFactory factory = new VMThinDiskLRURegionEntryHeapFactory();

    public VMThinDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMThinDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

