/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public abstract class TXMessage
extends SerialDistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    private int processorId;
    private int txUniqId;
    private InternalDistributedMember txMemberId = null;

    public TXMessage() {
    }

    public TXMessage(int txUniqueId, InternalDistributedMember onBehalfOfMember, ReplyProcessor21 processor) {
        this.txUniqId = txUniqueId;
        this.txMemberId = onBehalfOfMember;
        this.processorId = processor == null ? 0 : processor.getProcessorId();
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        Throwable thr = null;
        boolean sendReply = true;
        try {
            GemFireCacheImpl cache;
            if (logger.isDebugEnabled()) {
                logger.debug("processing {}", (Object)this);
            }
            if (this.checkCacheClosing(cache = GemFireCacheImpl.getInstance()) || this.checkDSClosing(cache.getInternalDistributedSystem())) {
                thr = new CacheClosedException(LocalizedStrings.PartitionMessage_REMOTE_CACHE_IS_CLOSED_0.toLocalizedString(dm.getId()));
                return;
            }
            TXManagerImpl txMgr = cache.getTXMgr();
            TXStateProxy tx = null;
            try {
                assert (this.txUniqId != -1);
                TXId txId = new TXId(this.getMemberToMasqueradeAs(), this.txUniqId);
                tx = txMgr.masqueradeAs(this);
                sendReply = this.operateOnTx(txId, dm);
                txMgr.unmasquerade(tx);
            }
            catch (Throwable throwable) {
                txMgr.unmasquerade(tx);
                throw throwable;
            }
        }
        catch (CommitConflictException cce) {
            thr = cce;
        }
        catch (DistributedSystemDisconnectedException se) {
            sendReply = false;
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown caught, abandoning message: " + se);
            }
        }
        catch (RegionDestroyedException rde) {
            thr = new ForceReattemptException(LocalizedStrings.PartitionMessage_REGION_IS_DESTROYED_IN_0.toLocalizedString(dm.getDistributionManagerId()), rde);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (sendReply) {
                thr = t;
            }
        }
        finally {
            ReplySender rs = this.getReplySender(dm);
            if (sendReply && (this.processorId != 0 || rs != dm)) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex);
            }
        }
    }

    private boolean checkDSClosing(InternalDistributedSystem distributedSystem) {
        return distributedSystem == null || distributedSystem.isDisconnecting();
    }

    private boolean checkCacheClosing(InternalCache cache) {
        return cache == null || cache.isClosed();
    }

    private void sendReply(InternalDistributedMember recipient, int processorId2, DistributionManager dm, ReplyException rex) {
        ReplyMessage.send(recipient, processorId2, rex, this.getReplySender(dm));
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(".cache.") + ".cache.".length()));
        buff.append("(txId=").append(this.txUniqId).append("; txMbr=").append(this.txMemberId).append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId);
        this.appendFields(buff);
        buff.append(")");
        return buff.toString();
    }

    public void appendFields(StringBuffer buff) {
    }

    protected abstract boolean operateOnTx(TXId var1, DistributionManager var2) throws RemoteOperationException;

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeInt(this.txUniqId);
        DataSerializer.writeObject(this.txMemberId, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.txUniqId = in.readInt();
        this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return false;
    }
}

